/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.report;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.define.ide.traceability.report.IReportDataCollector;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public abstract class AbstractReport {
    protected static final String EMPTY_STRING = "";
    private final Set<IReportDataCollector> dataCollectors = new HashSet<IReportDataCollector>();

    public void addReportDataCollector(IReportDataCollector collector) {
        if (collector != null) {
            this.dataCollectors.add(collector);
        }
    }

    public void removeReportDataCollector(IReportDataCollector collector) {
        if (collector != null) {
            this.dataCollectors.remove(collector);
        }
    }

    protected void notifyOnTableHeader(String ... header) {
        if (header != null && header.length > 0) {
            for (IReportDataCollector collector : this.dataCollectors) {
                collector.addTableHeader(header);
            }
        }
    }

    protected void notifyOnRowData(Artifact rowArt, String ... rowData) {
        if (rowData != null && rowData.length > 0) {
            for (IReportDataCollector collector : this.dataCollectors) {
                collector.addRow(rowArt, rowData);
            }
        }
    }

    protected void notifyOnEndTable() {
        for (IReportDataCollector collector : this.dataCollectors) {
            collector.endTable();
        }
    }

    public abstract void process(IProgressMonitor var1);

    public void clear() {
    }
}

