/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public final class Readers {
    public static final void xmlForward(Reader reader, Appendable appendable, CharSequence elementName) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("reader can not be null");
        }
        if (elementName == null) {
            throw new IllegalArgumentException("elementName can not be null");
        }
        String CLOSE_TAG = "</" + elementName + ">";
        String EMPTY_TAG = "<" + elementName + "/>";
        String OPEN_TAG = "<" + elementName + ">";
        String OPEN_TAG_WITH_ATTR = "<" + elementName + " ";
        CharSequence[] TAGS = new CharSequence[]{CLOSE_TAG, EMPTY_TAG, OPEN_TAG, OPEN_TAG_WITH_ATTR};
        int elementDepthCount = 1;
        StringBuilder read = null;
        if (appendable != null) {
            read = new StringBuilder();
        }
        while (elementDepthCount > 0) {
            CharSequence stopTag = Readers.forward(reader, appendable, TAGS);
            if (stopTag == null) {
                throw new IllegalStateException("end of reader met when expecting an end of a tag");
            }
            if (stopTag.equals(CLOSE_TAG)) {
                --elementDepthCount;
                continue;
            }
            if (stopTag.equals(OPEN_TAG)) {
                ++elementDepthCount;
                continue;
            }
            if (stopTag.equals(OPEN_TAG_WITH_ATTR)) {
                if (Readers.forward(reader, read, new CharSequence[]{">"}) == null) {
                    throw new IllegalStateException("end of reader met when expecting >");
                }
                if (read != null && !read.toString().endsWith("/>")) {
                    ++elementDepthCount;
                }
                if (appendable == null || read == null) continue;
                appendable.append(read);
                read.setLength(0);
                continue;
            }
            if (stopTag.equals(EMPTY_TAG)) continue;
            throw new IllegalStateException("unexpected element returned");
        }
    }

    public static final CharSequence forward(Reader reader, CharSequence ... sequences) throws IOException {
        return Readers.forward(reader, null, sequences);
    }

    public static final CharSequence forward(Reader reader, Appendable appendable, CharSequence ... sequences) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("reader can not be null");
        }
        if (sequences == null) {
            throw new IllegalArgumentException("sequences can not be null");
        }
        if (sequences.length == 0) {
            throw new IllegalArgumentException("must provide at least one sequence");
        }
        int[] lengths = new int[sequences.length];
        int x = 0;
        while (x < sequences.length) {
            if (sequences[x] == null) {
                throw new IllegalArgumentException("character sequence can not be null");
            }
            lengths[x] = sequences[x].length();
            if (lengths[x] == 0) {
                throw new IllegalArgumentException("character sequence can not have length zero");
            }
            ++x;
        }
        int[] seqIndex = new int[sequences.length];
        Arrays.fill(seqIndex, 0);
        char[] buffer = new char[1];
        while (reader.read(buffer) != -1) {
            if (appendable != null) {
                appendable.append(buffer[0]);
            }
            int x2 = 0;
            while (x2 < sequences.length) {
                if (sequences[x2].charAt(seqIndex[x2]) == buffer[0]) {
                    int n = x2;
                    seqIndex[n] = seqIndex[n] + 1;
                    if (seqIndex[x2] == lengths[x2]) {
                        return sequences[x2];
                    }
                } else {
                    seqIndex[x2] = 0;
                }
                ++x2;
            }
        }
        return null;
    }
}

