/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.support.test.util.review;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class ReviewOsgiXml {
    public static String IGNORE_LINE = "ReviewOsgiXml.IgnoreLine";
    Integer breakAfterFile = null;
    XResultData rd = new XResultData();
    Collection<String> ignoreShouldBeBind = Arrays.asList("setLog");

    public void run() {
        this.rd.logf("Reviewing OSGI Files...\n\n", new Object[0]);
        this.rd.logf("Search for Error: and Warning: and resolve\n", new Object[0]);
        this.rd.addResultsTag();
        Collection<String> files = this.findFiles();
        if (files.isEmpty()) {
            this.rd.logf("No Files found", new Object[0]);
            return;
        }
        int x = 0;
        for (String xmlfilename : files) {
            this.rd.logf("\n=================================================================\n", new Object[0]);
            this.rd.logf("\nOSGI [%s]\n", new Object[]{xmlfilename});
            this.validateFile(xmlfilename);
            if (this.breakAfterFile == null || ++x != this.breakAfterFile) continue;
            this.rd.logf("\n\nStopping early at count itemCount\n", new Object[0]);
            break;
        }
        this.rd.logf("\n", new Object[0]);
        String path = String.valueOf(System.getProperty("user.home")) + File.separator + "ReviewOsgiXml.html";
        File outFile = new File(path);
        String html = this.rd.getHtml();
        try {
            Lib.writeStringToFile((String)html, (File)outFile);
            Desktop.getDesktop().open(outFile);
        }
        catch (Exception exception) {}
    }

    private Collection<String> findFiles() {
        String pathStr;
        File thisClass = new File(ReviewOsgiXml.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        String basePath = pathStr = thisClass.getAbsolutePath();
        basePath = basePath.replaceFirst("org.eclipse.osee.*$", "");
        return ReviewOsgiXml.getOsgiFiles(new File(basePath), new ArrayList<String>());
    }

    public static List<String> getOsgiFiles(File dir, List<String> filenames) {
        List<String> ignoreDirs = Arrays.asList(".git", ".postgresql.", ".help.", ".support.", ".integration.tests.", "\\target\\", "\\bin", "\\src");
        try {
            File[] fileList;
            File[] fileArray = fileList = dir.listFiles();
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    boolean skipDir = false;
                    for (String dirName : ignoreDirs) {
                        if (!file.getAbsolutePath().contains(dirName)) continue;
                        skipDir = true;
                        break;
                    }
                    if (!skipDir) {
                        ReviewOsgiXml.getOsgiFiles(file, filenames);
                    }
                } else if (file.getAbsolutePath().contains("OSGI-INF")) {
                    filenames.add(file.getAbsolutePath());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filenames;
    }

    public void validateFile(String xmlfilename) {
        String line;
        String xmlFileContents;
        try {
            xmlFileContents = Lib.fileToString((File)new File(xmlfilename));
        }
        catch (IOException ex) {
            this.rd.errorf("===> Error: Exception loading xml file [%s] exception %s", new Object[]{xmlfilename, Lib.exceptionToString((Exception)ex)});
            return;
        }
        String[] lines = xmlFileContents.split("\n");
        String className = "Unknown";
        String javaFileContents = "";
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            line = stringArray[n2];
            if (line.contains("implementation class")) {
                this.rd.logf("xml   %s\n", new Object[]{line});
                String fileqname = line;
                fileqname = fileqname.replaceFirst("^.*class *= *\"", "");
                fileqname = fileqname.replaceAll("\".*$", "");
                this.rd.logf("==> File Qual Name [%s]\n", new Object[]{fileqname});
                className = fileqname;
                className = className.replaceFirst("^.*\\.", "");
                String existsFileName = this.validateFileExists(xmlfilename, fileqname);
                if (!Strings.isInValid((String)existsFileName)) {
                    try {
                        javaFileContents = Lib.fileToString((File)new File(existsFileName));
                    }
                    catch (IOException ex) {
                        this.rd.errorf("===> Error: Exception loading java file [%s] exception %s", new Object[]{existsFileName, Lib.exceptionToString((Exception)ex)});
                    }
                }
            }
            ++n2;
        }
        stringArray = lines;
        n = lines.length;
        n2 = 0;
        while (n2 < n) {
            line = stringArray[n2];
            this.rd.logf("xml   %s\n", new Object[]{line});
            if (line.contains("reference")) {
                this.rd.logf("\n== Reference =======\n", new Object[0]);
                String iface = line;
                iface = iface.replaceFirst("^.*interface=\"", "");
                iface = iface.replaceAll("\".*", "");
                this.rd.logf("==> Interface [%s]\n", new Object[]{iface});
                boolean addRemove = line.contains("cardinality=\"0..n\"") || line.contains("cardinality=\"1..n\"");
                String bind = "";
                String unbind = "";
                boolean validateBind = false;
                if (line.contains("bind=")) {
                    bind = line;
                    bind = bind.replaceFirst("^.* bind=\"", "");
                    bind = bind.replaceFirst("\".*", "");
                    this.rd.logf("==> Bind [%s]\n", new Object[]{bind});
                    validateBind = true;
                }
                if (line.contains("unbind=")) {
                    unbind = line;
                    unbind = unbind.replaceFirst("^.*unbind=\"", "");
                    unbind = unbind.replaceFirst("\".*", "");
                    this.rd.logf("==> UnBind [%s]\n", new Object[]{unbind});
                    validateBind = true;
                }
                if (validateBind) {
                    this.validateBind(javaFileContents, bind, unbind, iface, className, addRemove);
                }
                this.rd.logf("== End Reference ===\n", new Object[0]);
                this.rd.logf("\n", new Object[0]);
            }
            ++n2;
        }
    }

    public void validateBind(String filecontents, String bind, String unbind, String iface, String className, boolean addRemove) {
        Collection<String> mLines;
        String ifaceClass = iface;
        ifaceClass = ifaceClass.replaceAll("^.*\\.", "");
        this.rd.logf("==> IFace Class [%s]\n", new Object[]{ifaceClass});
        if (Strings.isValid((String)bind)) {
            if (ifaceClass.startsWith("I")) {
                this.rd.warningf("==> Warning - Remove I from interface [%s]\n", new Object[]{ifaceClass});
            }
            ifaceClass = ifaceClass.replaceFirst("^I", "");
            String expectedBind = "";
            expectedBind = addRemove ? "add" + ifaceClass : "set" + ifaceClass;
            this.rd.logf("==> XML Expected Bind [%s] Actual [%s] (based on interface)\n", new Object[]{expectedBind, bind});
            if (!expectedBind.equals(bind) && !this.ignoreShouldBeBind.contains(expectedBind)) {
                this.rd.warningf("==> Warning - Bind method should be [%s] not [%s]\n", new Object[]{expectedBind, bind});
            }
            if ((mLines = this.getMethodLines(filecontents, bind)).isEmpty()) {
                this.rd.errorf("==> Error - No bind method [%s] found in class [%s]\n", new Object[]{bind, className});
            } else if (mLines.size() > 1) {
                this.rd.errorf("==> Error - %s bind methods [%s] found in class [%s]; expect 1\n", new Object[]{mLines.size(), bind, className});
                for (String line : mLines) {
                    this.rd.logf("java [%s]\n", new Object[]{line});
                }
            } else {
                this.rd.logf("==> SUCCESS - Bind methods match\n", new Object[0]);
            }
        }
        if (Strings.isValid((String)unbind)) {
            String expectedUnBind = "";
            if (addRemove) {
                expectedUnBind = "remove" + ifaceClass;
            }
            this.rd.logf("==> XML Expected UnBind [%s] Actual [%s] (based on interface)\n", new Object[]{expectedUnBind, unbind});
            if (!expectedUnBind.equals(unbind)) {
                this.rd.warningf("==> Warning - UnBind method should be [%s] not [%s]\n", new Object[]{expectedUnBind, unbind});
            }
            if ((mLines = this.getMethodLines(filecontents, unbind)).isEmpty()) {
                this.rd.errorf("==> Error - No unbind method [%s] found in class [%s]\n", new Object[]{unbind, className});
            } else if (mLines.size() > 1) {
                this.rd.errorf("==> Error - %s bind methods [%s] found in class [%s]; expect 1\n", new Object[]{mLines.size(), unbind, className});
                for (String line : mLines) {
                    this.rd.logf("java [%s]\n", new Object[]{line});
                }
            } else {
                this.rd.logf("==> SUCCESS - UnBind methods match\n", new Object[0]);
            }
        }
    }

    public Collection<String> getMethodLines(String filecontents, String method) {
        String[] lines = filecontents.split("\n");
        ArrayList<String> results = new ArrayList<String>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.contains("void " + method + "(") && !line.contains(IGNORE_LINE)) {
                results.add(line);
            }
            ++n2;
        }
        return results;
    }

    public String validateFileExists(String xmlfilename, String fileqname) {
        String bundle = xmlfilename;
        bundle = bundle.replaceFirst("OSGI-INF.*", "src");
        bundle = String.valueOf(bundle) + "/";
        bundle = Matcher.quoteReplacement(bundle);
        this.rd.logf("==> Bundle [%s]\n", new Object[]{bundle});
        String bundleNamespace = xmlfilename;
        bundleNamespace = bundleNamespace.replaceFirst("^.*plugins\\\\", "");
        bundleNamespace = bundleNamespace.replaceFirst("\\\\.*$", "");
        this.rd.logf("==> Bundle Namespace [%s]\n", new Object[]{bundleNamespace});
        if (!fileqname.contains(bundleNamespace)) {
            this.rd.errorf("==> Error: file [%s] in wrong bundle [%s]; should be same as .xml file bundle [%s].\n", new Object[]{fileqname, bundle, bundleNamespace});
            return null;
        }
        String filename = fileqname;
        filename = filename.replaceAll("\\.", "/");
        filename = filename.replaceFirst("^", bundle);
        filename = filename.replaceFirst("$", ".java");
        this.rd.logf("==> FileName [%s]\n", new Object[]{filename});
        if (new File(filename).exists()) {
            return filename;
        }
        this.rd.errorf("==> Error: file not found [%s]\n", new Object[]{filename});
        return null;
    }

    public static void main(String[] args) {
        ReviewOsgiXml op = new ReviewOsgiXml();
        op.run();
    }
}

