/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.reports.output;

import java.util.Date;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.ote.ui.define.reports.output.ExcelReportWriter;
import org.eclipse.osee.ote.ui.define.reports.output.IReportWriter;
import org.eclipse.osee.ote.ui.define.reports.output.OutputFormat;
import org.eclipse.osee.ote.ui.define.reports.output.ReportWriter;

public class OutputFactory {
    private static final String SEPARATOR = ".";

    private OutputFactory() {
    }

    public static IReportWriter getReportWriter(OutputFormat format) {
        IReportWriter toReturn = null;
        switch (format) {
            case EXCEL: {
                toReturn = new ExcelReportWriter();
                break;
            }
            case HTML: 
            case PDF: 
            case RTF: {
                toReturn = new ReportWriter(format.name());
                break;
            }
            default: {
                throw new OseeArgumentException("Unsupported format [%s]", new Object[]{format});
            }
        }
        return toReturn;
    }

    public static String getOutputFilename(OutputFormat format, String reportId) {
        String extension = "";
        switch (format) {
            case HTML: {
                extension = "html";
                break;
            }
            case EXCEL: {
                extension = "xml";
                break;
            }
            case PDF: {
                extension = "pdf";
                break;
            }
            case RTF: {
                extension = "rtf";
                break;
            }
            default: {
                throw new OseeArgumentException("Unsupported format [%s]", new Object[]{format});
            }
        }
        StringBuilder builder = new StringBuilder(reportId);
        builder.append(SEPARATOR);
        builder.append(Long.toString(new Date().getTime()));
        builder.append(SEPARATOR);
        builder.append(extension);
        return builder.toString();
    }

    public static String getContentType(OutputFormat format) {
        String toReturn = "";
        switch (format) {
            case HTML: {
                toReturn = "text/html";
                break;
            }
            case EXCEL: {
                toReturn = "application/excel";
                break;
            }
            case PDF: {
                toReturn = "application/pdf";
                break;
            }
            case RTF: {
                toReturn = "application/rtf";
                break;
            }
            default: {
                throw new OseeArgumentException("Unsupported format [%s]", new Object[]{format});
            }
        }
        return toReturn;
    }
}

