/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.database.init.internal;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.core.client.OseeClientProperties;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.exception.OseeDataStoreException;
import org.eclipse.osee.framework.core.exception.OseeNotFoundException;
import org.eclipse.osee.framework.database.init.IDbInitializationTask;
import org.eclipse.osee.framework.database.init.internal.Activator;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.ExtensionPoints;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.exportImport.HttpBranchExchange;
import org.osgi.framework.Bundle;

public class SkynetDbBranchDataImport
implements IDbInitializationTask {
    private static final String ELEMENT_NAME = "OseeDbImportData";
    private static final String EXTENSION_POINT = "org.eclipse.osee.framework.database.init.OseeDbImportData";
    private static final String BRANCH_NAME = "branchName";
    private static final String BRANCH_DATA = "branchData";
    private static final String BRANCHES_TO_IMPORT = "BranchesToImport";

    @Override
    public void run() {
        if (OseeClientProperties.isOseeImportAllowed()) {
            for (BranchId branch : BranchManager.getBranches((BranchArchivedState)BranchArchivedState.UNARCHIVED, (BranchType[])new BranchType[]{BranchType.WORKING, BranchType.BASELINE})) {
                if (!branch.notEqual((Id)CoreBranches.COMMON)) continue;
                BranchManager.purgeBranch((BranchId)branch);
            }
            Collection<ImportData> importDatas = this.loadDataFromExtensions();
            for (ImportData importData : importDatas) {
                OseeLog.logf(Activator.class, (Level)Level.INFO, (String)"Import Branch Data: [%s]", (Object[])new Object[]{importData});
                try {
                    File importFile = importData.getExchangeFile();
                    HttpBranchExchange.importBranches((String)importFile.toURI().toASCIIString(), (boolean)true, (boolean)true, (BranchId[])new BranchId[0]);
                }
                catch (OseeDataStoreException ex) {
                    OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Exception while importing branch: [%s]", (Object[])new Object[]{importData});
                    throw ex;
                }
            }
        }
    }

    private Collection<ImportData> loadDataFromExtensions() {
        ArrayList<ImportData> toReturn = new ArrayList<ImportData>();
        HashMap<String, String> selectedBranches = new HashMap<String, String>();
        List elements = ExtensionPoints.getExtensionElements((String)EXTENSION_POINT, (String)ELEMENT_NAME);
        for (IConfigurationElement element : elements) {
            String bundleName = element.getContributor().getName();
            String branchData = element.getAttribute(BRANCH_DATA);
            if (Strings.isValid((String)bundleName) && Strings.isValid((String)branchData)) {
                File exchangeFile;
                try {
                    exchangeFile = this.getExchangeFile(bundleName, branchData);
                }
                catch (Exception ex) {
                    throw OseeCoreException.wrap((Throwable)ex);
                }
                ImportData importData = new ImportData(exchangeFile);
                IConfigurationElement[] iConfigurationElementArray = element.getChildren(BRANCHES_TO_IMPORT);
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement innerElement = iConfigurationElementArray[n2];
                    String branchName = innerElement.getAttribute(BRANCH_NAME);
                    if (Strings.isValid((String)branchName)) {
                        importData.addSelectedBranch(branchName);
                        if (!selectedBranches.containsKey(branchName.toLowerCase())) {
                            selectedBranches.put(branchName.toLowerCase(), element.getDeclaringExtension().getUniqueIdentifier());
                        } else {
                            throw new OseeDataStoreException("Branch import error - cannot import twice into a branch - [%s] was already specified by [%s] ", new Object[]{branchName, selectedBranches.get(branchName.toLowerCase())});
                        }
                    }
                    ++n2;
                }
                toReturn.add(importData);
                continue;
            }
            throw new OseeDataStoreException(String.format("Branch import error: [%s] attributes were empty.", element.getDeclaringExtension().getExtensionPointUniqueIdentifier()), new Object[0]);
        }
        return toReturn;
    }

    private File getExchangeFile(String bundleName, String exchangeFile) {
        if (!exchangeFile.endsWith("zip")) {
            throw new OseeArgumentException(String.format("Branch data file is invalid [%s] ", exchangeFile), new Object[0]);
        }
        Bundle bundle = Platform.getBundle((String)bundleName);
        URL url = bundle.getResource(exchangeFile);
        try {
            url = FileLocator.toFileURL((URL)url);
            String urlValue = url.toString();
            URI uri = new URI(urlValue.replaceAll(" ", "%20"));
            File toReturn = new File(uri);
            if (!toReturn.exists()) {
                throw new OseeNotFoundException(String.format("Branch data file cannot be found [%s]", exchangeFile), new Object[0]);
            }
            return toReturn;
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private static final class ImportData {
        private final File exchangeFile;
        private final Set<String> selectedBranches;

        public ImportData(File exchangeFile) {
            this.exchangeFile = exchangeFile;
            this.selectedBranches = new HashSet<String>();
        }

        public void addSelectedBranch(String branchName) {
            this.selectedBranches.add(branchName);
        }

        public String toString() {
            return String.format("%s - %s", this.exchangeFile, this.selectedBranches);
        }

        public File getExchangeFile() {
            return this.exchangeFile;
        }
    }
}

