/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io;

import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class UriWatcher {
    private final Timer timer = new Timer();
    private final Map<URI, Long> urisToWatch = new ConcurrentHashMap<URI, Long>(128);
    private final Set<UriWatcherListener> listeners = new CopyOnWriteArraySet<UriWatcherListener>();
    private final long interval;

    public UriWatcher(long time, TimeUnit unit) {
        this.interval = unit.toMillis(time);
    }

    public void start() {
        this.timer.schedule((TimerTask)new UriWatcherTimerTask(), this.interval, this.interval);
    }

    public void stop() {
        this.timer.cancel();
        this.listeners.clear();
        this.urisToWatch.clear();
    }

    public void addUri(URI uri) {
        this.urisToWatch.put(uri, -1L);
    }

    public Long removeFile(URI uri) {
        return this.urisToWatch.remove(uri);
    }

    public void addListener(UriWatcherListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(UriWatcherListener listener) {
        this.listeners.remove(listener);
    }

    static /* synthetic */ Map access$0(UriWatcher uriWatcher) {
        return uriWatcher.urisToWatch;
    }

    static /* synthetic */ Set access$1(UriWatcher uriWatcher) {
        return uriWatcher.listeners;
    }

    public static interface UriWatcherListener {
        public void modificationDateChanged(Collection<URI> var1);

        public void handleException(Exception var1);
    }

    final class UriWatcherTimerTask
    extends TimerTask {
        UriWatcherTimerTask() {
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block8: {
                try {
                    uris = new LinkedList<URI>();
                    for (Map.Entry<K, Long> entry : UriWatcher.access$0(UriWatcher.this).entrySet()) {
                        connection = ((URI)entry.getKey()).toURL().openConnection();
                        try {
                            latestLastModified = connection.getLastModified();
                            storedLastModified = (Long)entry.getValue();
                            if (storedLastModified.equals(latestLastModified)) continue;
                            entry.setValue(latestLastModified);
                            if (storedLastModified == -1L) continue;
                            uris.add((URI)entry.getKey());
                        }
                        finally {
                            Lib.close(connection.getInputStream());
                        }
                    }
                    if (uris.isEmpty()) break block8;
                    for (UriWatcherListener listener : UriWatcher.access$1(UriWatcher.this)) {
                        listener.modificationDateChanged(uris);
                    }
                    break block8;
                }
                catch (Exception ex) {
                    ** for (listener : UriWatcher.access$1((UriWatcher)UriWatcher.this))
                }
lbl-1000:
                // 1 sources

                {
                    listener.handleException(ex);
                    continue;
                }
            }
        }
    }
}

