/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.users;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.eclipse.osee.cache.admin.Cache;
import org.eclipse.osee.cache.admin.CacheAdmin;
import org.eclipse.osee.cache.admin.CacheConfiguration;
import org.eclipse.osee.cache.admin.CacheDataLoader;
import org.eclipse.osee.cache.admin.CacheKeysLoader;
import org.eclipse.osee.framework.jdk.core.type.LazyObject;
import org.eclipse.osee.framework.skynet.core.User;

public class UserCacheProvider
extends LazyObject<Cache<String, User>> {
    private final CacheAdmin cacheAdmin;
    private final CacheDataLoader<String, User> loader;
    private final CacheKeysLoader<String> keyProvider;

    public UserCacheProvider(CacheAdmin cacheAdmin, CacheDataLoader<String, User> loader, CacheKeysLoader<String> keyProvider) {
        this.cacheAdmin = cacheAdmin;
        this.loader = loader;
        this.keyProvider = keyProvider;
    }

    protected FutureTask<Cache<String, User>> createLoaderTask() {
        Callable<Cache<String, User>> callable = new Callable<Cache<String, User>>(){

            @Override
            public Cache<String, User> call() throws Exception {
                CacheConfiguration configuration = CacheConfiguration.newConfiguration();
                Cache userCache = UserCacheProvider.this.cacheAdmin.createLoadingCache(configuration, UserCacheProvider.this.loader, UserCacheProvider.this.keyProvider);
                userCache.getAll();
                return userCache;
            }
        };
        return new FutureTask<Cache<String, User>>(callable);
    }
}

