/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionChange;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionEvent;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionEventType;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.revision.ChangeManager;

public final class PurgeTransactionEventUtil {
    private PurgeTransactionEventUtil() {
    }

    public static Pair<TransactionEvent, Map<String, Long>> createPurgeTransactionEvent(Collection<TransactionRecord> purgedTransactions) {
        TransactionEvent transactionEvent = new TransactionEvent();
        transactionEvent.setEventType(TransactionEventType.Purged);
        HashMap<String, Long> guidToId = new HashMap<String, Long>();
        for (TransactionRecord transId : purgedTransactions) {
            TransactionChange txChg = new TransactionChange();
            txChg.setBranch(transId.getBranch());
            txChg.setTransactionId(transId.getId().intValue());
            transactionEvent.getTransactionChanges().add(txChg);
            ArrayList<Change> changes = new ArrayList<Change>();
            IOperation operation = ChangeManager.comparedToPreviousTx((TransactionToken)transId, changes);
            Operations.executeWorkAndCheckStatus((IOperation)operation);
            if (changes.isEmpty()) continue;
            for (Change change : changes) {
                try {
                    Artifact art = ArtifactQuery.getArtifactFromId(change.getArtId(), transId.getBranch(), DeletionFlag.INCLUDE_DELETED);
                    guidToId.put(art.getGuid(), art.getId());
                    DefaultBasicGuidArtifact guidArt = new DefaultBasicGuidArtifact(change.getBranch(), change.getArtifactType(), art.getGuid());
                    txChg.getArtifacts().add(guidArt);
                }
                catch (ArtifactDoesNotExist ex) {
                    OseeLog.log(Activator.class, (Level)Level.WARNING, (Throwable)ex);
                }
            }
        }
        return new Pair((Object)transactionEvent, guidToId);
    }

    public static void handleRemotePurgeTransactionEvent(TransactionEvent transEvent) {
        if (transEvent.getEventType() == TransactionEventType.Purged) {
            HashSet<Artifact> artifactsInCache = new HashSet<Artifact>();
            for (TransactionChange transChange : transEvent.getTransactionChanges()) {
                for (DefaultBasicGuidArtifact guidArt : transChange.getArtifacts()) {
                    try {
                        Artifact artifact = ArtifactCache.getActive(guidArt);
                        if (artifact == null) continue;
                        artifactsInCache.add(artifact);
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
            }
            if (!artifactsInCache.isEmpty()) {
                try {
                    ArtifactQuery.reloadArtifacts(artifactsInCache);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        }
    }
}

