/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactLoader;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.jdbc.JdbcStatement;

public class AttributeLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void loadAttributeData(int queryId, CompositeKeyHashMap<ArtifactId, Id, Artifact> tempCache, boolean historical, DeletionFlag allowDeletedArtifacts, LoadLevel loadLevel, boolean isArchived, OrcsTokenService tokenservice) {
        if (loadLevel == LoadLevel.ARTIFACT_DATA) return;
        if (loadLevel == LoadLevel.RELATION_DATA) {
            return;
        }
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            String sql = AttributeLoader.getSql(allowDeletedArtifacts, loadLevel, historical, isArchived);
            chStmt.runPreparedQuery(tempCache.size() * 8, sql, new Object[]{queryId});
            Artifact currentArtifact = null;
            AttrData previousAttr = new AttrData();
            ArrayList<AttrData> currentAttributes = new ArrayList<AttrData>();
            while (chStmt.next()) {
                AttrData nextAttr = new AttrData(chStmt, historical, tokenservice);
                if (AttrData.isDifferentArtifact(previousAttr, nextAttr)) {
                    AttributeLoader.loadAttributesFor(currentArtifact, currentAttributes, historical);
                    currentAttributes.clear();
                    currentArtifact = AttributeLoader.getArtifact(nextAttr, historical, tempCache);
                }
                currentAttributes.add(nextAttr);
                previousAttr = nextAttr;
            }
            AttributeLoader.loadAttributesFor(currentArtifact, currentAttributes, historical);
        }
        for (Artifact art : tempCache.values()) {
            Class<ArtifactCache> clazz = ArtifactCache.class;
            // MONITORENTER : org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache.class
            ArtifactCache.cache(art);
            // MONITOREXIT : clazz
        }
    }

    private static Artifact getArtifact(AttrData current, boolean historical, CompositeKeyHashMap<ArtifactId, Id, Artifact> tempCache) {
        Artifact artifact = null;
        Object key2 = historical ? current.stripeId : current.branch;
        artifact = (Artifact)((Object)tempCache.get((Object)current.artifactId, key2));
        if (artifact == null) {
            OseeLog.logf(ArtifactLoader.class, (Level)Level.WARNING, (String)"Orphaned attribute id [%s] for artifact id[%s] branch[%s]", (Object[])new Object[]{current.attrId, current.artifactId, current.branch});
        }
        return artifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadAttributesFor(Artifact artifact, List<AttrData> attributes, boolean historical) {
        if (artifact == null) {
            return;
        }
        TransactionRecord maxTransaction = TransactionRecord.SENTINEL;
        AttrData previous = new AttrData();
        Artifact artifact2 = artifact;
        synchronized (artifact2) {
            if (!artifact.isAttributesLoaded()) {
                for (AttrData current : attributes) {
                    if (AttrData.multipleVersionsExist(current, previous)) {
                        AttributeLoader.handleMultipleVersions(previous, current, historical);
                    } else {
                        AttributeLoader.loadAttribute(artifact, current, previous);
                        if (current.transaction.isGreaterThan((Id)maxTransaction)) {
                            maxTransaction = current.transaction;
                        }
                    }
                    previous = current;
                }
                artifact.setTransactionId(maxTransaction);
                artifact.meetMinimumAttributeCounts(false);
            }
        }
    }

    private static void handleMultipleVersions(AttrData previous, AttrData current, boolean historical) {
        if (!historical) {
            OseeLog.logf(ArtifactLoader.class, (Level)Level.WARNING, (String)"multiple attribute version for attribute id [%s] artifact id[%s] branch[%s] previousGammaId[%s] currentGammaId[%s] previousModType[%s] currentModType[%s]", (Object[])new Object[]{current.attrId, current.artifactId, current.branch, previous.gammaId, current.gammaId, previous.modType, current.modType});
        }
    }

    private static void loadAttribute(Artifact artifact, AttrData current, AttrData previous) {
        boolean markDirty = false;
        artifact.internalInitializeAttribute(current.attributeType, current.attrId, current.gammaId, current.modType, current.applicabilityId, markDirty, current.value, current.uri);
    }

    private static String getSql(DeletionFlag allowDeletedArtifacts, LoadLevel loadLevel, boolean historical, boolean isArchived) {
        OseeSql sqlKey = historical && isArchived ? OseeSql.LOAD_HISTORICAL_ARCHIVED_ATTRIBUTES : (historical ? OseeSql.LOAD_HISTORICAL_ATTRIBUTES : (isArchived && allowDeletedArtifacts == DeletionFlag.INCLUDE_DELETED ? OseeSql.LOAD_CURRENT_ARCHIVED_ATTRIBUTES_WITH_DELETED : (isArchived ? OseeSql.LOAD_CURRENT_ARCHIVED_ATTRIBUTES : (allowDeletedArtifacts == DeletionFlag.INCLUDE_DELETED ? OseeSql.LOAD_CURRENT_ATTRIBUTES_WITH_DELETED : OseeSql.LOAD_CURRENT_ATTRIBUTES))));
        return ServiceUtil.getSql(sqlKey);
    }

    private static final class AttrData {
        public ArtifactId artifactId = ArtifactId.SENTINEL;
        public BranchId branch = BranchId.SENTINEL;
        public AttributeId attrId = AttributeId.SENTINEL;
        public GammaId gammaId = GammaId.SENTINEL;
        public ModificationType modType;
        public TransactionRecord transaction;
        public AttributeTypeToken attributeType = AttributeTypeToken.SENTINEL;
        public Object value = "";
        public TransactionId stripeId = TransactionId.SENTINEL;
        public String uri = "";
        public ApplicabilityId applicabilityId = ApplicabilityId.BASE;

        public AttrData() {
        }

        public AttrData(JdbcStatement chStmt, boolean historical, OrcsTokenService tokenservice) {
            this.artifactId = ArtifactId.valueOf((Long)chStmt.getLong("art_id"));
            this.branch = BranchId.valueOf((Long)chStmt.getLong("id1"));
            this.attrId = AttributeId.valueOf((Long)chStmt.getLong("attr_id"));
            this.gammaId = GammaId.valueOf((Long)chStmt.getLong("gamma_id"));
            this.modType = ModificationType.valueOf((long)chStmt.getInt("mod_type"));
            this.transaction = TransactionManager.loadTransaction(this.branch, chStmt);
            this.attributeType = tokenservice.getAttributeTypeOrCreate(Long.valueOf(chStmt.getLong("attr_type_id")));
            this.value = chStmt.loadAttributeValue(this.attributeType);
            if (historical) {
                this.stripeId = TransactionId.valueOf((Long)chStmt.getLong("stripe_transaction_id"));
            }
            this.uri = chStmt.getString("uri");
            this.applicabilityId = ApplicabilityId.valueOf((Long)chStmt.getLong("app_id"));
        }

        public static boolean isDifferentArtifact(AttrData previous, AttrData current) {
            return current.branch.notEqual((Id)previous.branch) || current.artifactId.notEqual((Id)previous.artifactId);
        }

        public static boolean multipleVersionsExist(AttrData current, AttrData previous) {
            return current.attrId.equals(previous.attrId) && current.branch.equals(previous.branch) && current.artifactId.equals(previous.artifactId);
        }
    }
}

