/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public final class OseeSystemArtifacts {
    public static Artifact getGlobalPreferenceArtifact() {
        return ArtifactQuery.getArtifactFromToken(CoreArtifactTokens.GlobalPreferences);
    }

    public static Artifact getDefaultHierarchyRootArtifact(BranchId branch) {
        return ArtifactQuery.getArtifactFromId((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, branch);
    }

    public static Artifact getOrCreateArtifact(ArtifactTypeToken artifactType, String artifactName, BranchToken branch) {
        return OseeSystemArtifacts.getOrCreateCachedArtifact(artifactType, artifactName, branch, null, true);
    }

    public static Artifact getOrCreateArtifact(ArtifactToken artifactToken, BranchToken branch) {
        return OseeSystemArtifacts.getOrCreateCachedArtifact(artifactToken.getArtifactType(), artifactToken.getName(), branch, artifactToken.getGuid(), artifactToken.getUuid(), true);
    }

    public static Artifact getCachedArtifact(ArtifactTypeToken artifactType, String artifactName, BranchToken branch) {
        return OseeSystemArtifacts.getOrCreateCachedArtifact(artifactType, artifactName, branch, null, false);
    }

    private static Artifact getOrCreateCachedArtifact(ArtifactTypeToken artifactType, String artifactName, BranchToken branch, String guid, boolean create) {
        return OseeSystemArtifacts.getOrCreateCachedArtifact(artifactType, artifactName, branch, guid, null, create);
    }

    private static Artifact getOrCreateCachedArtifact(ArtifactTypeToken artifactType, String artifactName, BranchToken branch, String guid, Long uuid, boolean create) {
        Artifact artifact = ArtifactQuery.checkArtifactFromTypeAndName((ArtifactTypeId)artifactType, artifactName, (BranchId)branch);
        if (artifact == null && create) {
            artifact = Strings.isValid((String)guid) && uuid != null && uuid > 0L ? ArtifactTypeManager.addArtifact(artifactType, branch, artifactName, guid, uuid) : (Strings.isValid((String)guid) ? ArtifactTypeManager.addArtifact(artifactType, branch, artifactName, guid) : (uuid != null && uuid > 0L ? ArtifactTypeManager.addArtifact(artifactType, branch, artifactName, uuid) : ArtifactTypeManager.addArtifact(artifactType, branch, artifactName)));
        }
        if (artifact == null) {
            throw new ArtifactDoesNotExist("Artifact of type [%s] with name [%s] does not exist on branch [%s]", new Object[]{artifactType, artifactName, branch});
        }
        return artifact;
    }
}

