/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix.util;

import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.ASTNodeNotFoundException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.FieldDeclarationNotFoundException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.MethodDeclarationNotFoundException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.StatementNotFoundException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.TypeDeclarationNotFoundException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ImportDeclarationComparator;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.SourceLineVisitor;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

public class ASTUtil {
    private static Comparator<? super ImportDeclaration> defaultImportComparator = new ImportDeclarationComparator<ImportDeclaration>();
    private static Map<String, Class<?>> primitiveTypes = new HashMap();

    public static void addImports(ASTRewrite rewrite, CompilationUnit compilationUnit, String ... imports) {
        ASTUtil.addImports(rewrite, compilationUnit, false, imports);
    }

    public static void addStaticImports(ASTRewrite rewrite, CompilationUnit compilationUnit, String ... imports) {
        ASTUtil.addImports(rewrite, compilationUnit, true, imports);
    }

    public static void addImports(ASTRewrite rewrite, CompilationUnit compilationUnit, boolean staticImports, String ... imports) {
        ASTUtil.addImports(rewrite, compilationUnit, defaultImportComparator, staticImports, imports);
    }

    public static void addImports(ASTRewrite rewrite, CompilationUnit compilationUnit, Comparator<? super ImportDeclaration> comparator, boolean staticImports, String ... imports) {
        Objects.requireNonNull(comparator, "import comparator");
        Objects.requireNonNull(imports, "imports");
        AST ast = rewrite.getAST();
        TreeSet<ImportDeclaration> importDeclarations = new TreeSet<ImportDeclaration>(comparator);
        for (String importName : imports) {
            ImportDeclaration importDeclaration = ast.newImportDeclaration();
            importDeclaration.setName(ast.newName(importName));
            importDeclaration.setStatic(staticImports);
            importDeclarations.add(importDeclaration);
        }
        ASTUtil.addImports(rewrite, compilationUnit, importDeclarations);
    }

    public static void addImports(ASTRewrite rewrite, CompilationUnit compilationUnit, SortedSet<ImportDeclaration> imports) {
        Objects.requireNonNull(rewrite, "ast-rewrite");
        Objects.requireNonNull(compilationUnit, "compilation-unit");
        Objects.requireNonNull(imports, "imports");
        ListRewrite importRewrite = rewrite.getListRewrite((ASTNode)compilationUnit, CompilationUnit.IMPORTS_PROPERTY);
        ASTUtil.addImports(importRewrite, imports.comparator(), imports.iterator());
    }

    private static void addImports(ListRewrite importRewrite, Comparator<? super ImportDeclaration> comparator, Iterator<ImportDeclaration> newImports) {
        try {
            ImportDeclaration newImport = newImports.next();
            List imports = importRewrite.getRewrittenList();
            for (Object importObj : imports) {
                ImportDeclaration anImport = (ImportDeclaration)importObj;
                int comp = comparator.compare((ImportDeclaration)newImport, (ImportDeclaration)anImport);
                if (comp > 0) continue;
                if (comp < 0) {
                    importRewrite.insertBefore((ASTNode)newImport, (ASTNode)anImport, null);
                }
                newImport = newImports.next();
            }
            importRewrite.insertLast((ASTNode)newImport, null);
            while (newImports.hasNext()) {
                importRewrite.insertLast((ASTNode)newImports.next(), null);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public static ASTNode getASTNode(CompilationUnit compilationUnit, SourceLineAnnotation sourceLineAnno) throws ASTNodeNotFoundException {
        Objects.requireNonNull(sourceLineAnno, "source line annotation");
        return ASTUtil.getASTNode(compilationUnit, sourceLineAnno.getStartLine(), sourceLineAnno.getEndLine());
    }

    public static ASTNode getASTNode(CompilationUnit compilationUnit, int startLine, int endLine) throws ASTNodeNotFoundException {
        Objects.requireNonNull(compilationUnit, "compilation unit");
        ASTNode node = ASTUtil.searchASTNode(compilationUnit, startLine, endLine);
        if (node == null) {
            throw new ASTNodeNotFoundException("No ast node found between " + startLine + " and " + endLine + ".");
        }
        return node;
    }

    public static TypeDeclaration getTypeDeclaration(CompilationUnit compilationUnit, ClassAnnotation classAnno) throws TypeDeclarationNotFoundException {
        Objects.requireNonNull(classAnno, "class annotation");
        return ASTUtil.getTypeDeclaration(compilationUnit, classAnno.getClassName());
    }

    public static TypeDeclaration getTypeDeclaration(CompilationUnit compilationUnit, String typeName) throws TypeDeclarationNotFoundException {
        String packageName;
        Objects.requireNonNull(compilationUnit, "compilation unit");
        Objects.requireNonNull(typeName, "class name");
        int index = typeName.lastIndexOf(46);
        String string = packageName = index > 0 ? typeName.substring(0, index) : "";
        if (!ASTUtil.matchesPackage(compilationUnit.getPackage(), packageName)) {
            throw new TypeDeclarationNotFoundException(compilationUnit, typeName, "The package '" + packageName + "' doesn't match the package of the compilation unit.");
        }
        TypeDeclaration type = ASTUtil.searchTypeDeclaration(compilationUnit.types(), typeName.substring(index + 1));
        if (type == null) {
            throw new TypeDeclarationNotFoundException(compilationUnit, typeName);
        }
        return type;
    }

    public static FieldDeclaration getFieldDeclaration(TypeDeclaration type, FieldAnnotation fieldAnno) throws FieldDeclarationNotFoundException {
        Objects.requireNonNull(fieldAnno, "field annotation");
        return ASTUtil.getFieldDeclaration(type, fieldAnno.getFieldName());
    }

    public static FieldDeclaration getFieldDeclaration(TypeDeclaration type, String fieldName) throws FieldDeclarationNotFoundException {
        Objects.requireNonNull(type, "type declaration");
        Objects.requireNonNull(fieldName, "field name");
        for (FieldDeclaration field : type.getFields()) {
            for (Object fragObj : field.fragments()) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragObj;
                if (!fieldName.equals(fragment.getName().getIdentifier())) continue;
                return field;
            }
        }
        throw new FieldDeclarationNotFoundException(type, fieldName);
    }

    public static MethodDeclaration getMethodDeclaration(TypeDeclaration type, MethodAnnotation methodAnno) throws MethodDeclarationNotFoundException {
        Objects.requireNonNull(methodAnno, "method annotation");
        return ASTUtil.getMethodDeclaration(type, methodAnno.getMethodName(), methodAnno.getMethodSignature());
    }

    public static MethodDeclaration getMethodDeclaration(TypeDeclaration type, String methodName, String methodSignature) throws MethodDeclarationNotFoundException {
        Objects.requireNonNull(type, "type declaration");
        Objects.requireNonNull(methodName, "method name");
        Objects.requireNonNull(methodSignature, "method signature");
        MethodDeclaration method = ASTUtil.searchMethodDeclaration(type.getAST(), type.getMethods(), methodName, methodSignature);
        if (method == null) {
            throw new MethodDeclarationNotFoundException(type, methodName, methodSignature);
        }
        return method;
    }

    public static Statement getStatement(CompilationUnit compilationUnit, MethodDeclaration method, SourceLineAnnotation sourceLineAnno) throws StatementNotFoundException {
        Objects.requireNonNull(sourceLineAnno, "source line annotation");
        return ASTUtil.getStatement(compilationUnit, method, sourceLineAnno.getStartLine(), sourceLineAnno.getEndLine());
    }

    public static Statement getStatement(CompilationUnit compilationUnit, MethodDeclaration method, int startLine, int endLine) throws StatementNotFoundException {
        Objects.requireNonNull(compilationUnit, "compilation unit");
        Objects.requireNonNull(method, "method declaration");
        Statement statement = ASTUtil.searchStatement(compilationUnit, method.getBody().statements(), startLine, endLine);
        if (statement == null) {
            throw new StatementNotFoundException(compilationUnit, startLine, endLine);
        }
        return statement;
    }

    @CheckForNull
    protected static ASTNode searchASTNode(CompilationUnit compilationUnit, int startLine, int endLine) {
        Assert.isNotNull((Object)compilationUnit);
        Assert.isTrue((startLine <= endLine ? 1 : 0) != 0);
        SourceLineVisitor visitor = new SourceLineVisitor(compilationUnit, startLine, endLine);
        compilationUnit.accept((ASTVisitor)visitor);
        return visitor.getASTNode();
    }

    @CheckForNull
    protected static TypeDeclaration searchTypeDeclaration(List<?> declarations, String typeName) {
        Assert.isNotNull(declarations);
        Assert.isNotNull((Object)typeName);
        int index = typeName.indexOf(36);
        String innerClassName = null;
        if (index >= 0) {
            innerClassName = typeName.substring(index + 1);
            typeName = typeName.substring(0, index);
        }
        for (Object declaration : declarations) {
            TypeDeclaration type;
            if (!(declaration instanceof TypeDeclaration) || !typeName.equals((type = (TypeDeclaration)declaration).getName().getFullyQualifiedName())) continue;
            if (index < 0) {
                return type;
            }
            return ASTUtil.searchTypeDeclaration(type.bodyDeclarations(), innerClassName);
        }
        return null;
    }

    @CheckForNull
    protected static MethodDeclaration searchMethodDeclaration(AST ast, MethodDeclaration[] methods, String methodName, String methodSignature) {
        Assert.isNotNull((Object)methods);
        Assert.isNotNull((Object)methodName);
        Assert.isNotNull((Object)methodSignature);
        String[] parameters = ASTUtil.parseParameters(methodSignature);
        for (MethodDeclaration method : methods) {
            if (!methodName.equals(method.getName().getFullyQualifiedName()) || !ASTUtil.matchesParams(method.parameters(), parameters)) continue;
            return method;
        }
        return null;
    }

    @CheckForNull
    protected static Statement searchStatement(CompilationUnit compilationUnit, List<?> statements, int startLine, int endLine) {
        Assert.isNotNull((Object)compilationUnit);
        Assert.isNotNull(statements);
        for (Object statementObj : statements) {
            Statement statement = (Statement)statementObj;
            int lineNumber = compilationUnit.getLineNumber(statement.getStartPosition());
            if (startLine > lineNumber || lineNumber > endLine) continue;
            return statement;
        }
        return null;
    }

    protected static String[] parseParameters(String methodSignature) {
        Assert.isNotNull((Object)methodSignature);
        int leftParenthesis = methodSignature.indexOf(40);
        int rightParenthesis = methodSignature.indexOf(41);
        methodSignature = methodSignature.substring(leftParenthesis + 1, rightParenthesis);
        if (methodSignature.length() == 0) {
            return new String[0];
        }
        String[] parameters = methodSignature.split(";");
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = ASTUtil.normalizeParameter(parameters[i]);
        }
        return parameters;
    }

    protected static String normalizeParameter(String parameter) {
        Assert.isNotNull((Object)parameter);
        Class<?> primitiveClass = primitiveTypes.get(parameter);
        if (primitiveClass != null) {
            return primitiveClass.getName();
        }
        if (parameter.startsWith("L")) {
            return parameter.substring(1).replaceAll("[/$]", ".");
        }
        if (parameter.startsWith("[")) {
            return ASTUtil.normalizeParameter(parameter.substring(1)) + "[]";
        }
        throw new IllegalStateException("Unknown parameter type '" + parameter + "'.");
    }

    private static boolean matchesPackage(PackageDeclaration apackage, String packageName) {
        return apackage != null && packageName.equals(apackage.getName().getFullyQualifiedName()) || packageName.length() == 0;
    }

    private static boolean matchesParams(List<?> methodParams, String[] paramTypeNames) {
        return ASTUtil.matchesParams(methodParams.toArray(new SingleVariableDeclaration[methodParams.size()]), paramTypeNames);
    }

    private static boolean matchesParams(SingleVariableDeclaration[] methodParams, String[] paramTypeNames) {
        if (methodParams.length != paramTypeNames.length) {
            return false;
        }
        for (int i = 0; i < methodParams.length; ++i) {
            String typeName = ASTUtil.getPrettyTypeName(methodParams[i].getType());
            if (typeName.equals(paramTypeNames[i])) continue;
            return false;
        }
        return true;
    }

    private static String getPrettyTypeName(Type type) {
        if (type.isArrayType()) {
            return ASTUtil.getPrettyTypeName((ArrayType)type);
        }
        if (type.isParameterizedType()) {
            return ASTUtil.getPrettyTypeName((ParameterizedType)type);
        }
        if (type.isPrimitiveType()) {
            return ASTUtil.getPrettyTypeName((PrimitiveType)type);
        }
        if (type.isQualifiedType()) {
            return ASTUtil.getPrettyTypeName((QualifiedType)type);
        }
        if (type.isSimpleType()) {
            return ASTUtil.getPrettyTypeName((SimpleType)type);
        }
        return "";
    }

    private static String getPrettyTypeName(ArrayType type) {
        return ASTUtil.getPrettyTypeName(type.getComponentType()) + "[]";
    }

    private static String getPrettyTypeName(PrimitiveType type) {
        return type.getPrimitiveTypeCode().toString();
    }

    private static String getPrettyTypeName(ParameterizedType type) {
        String typeName = type.resolveBinding().getQualifiedName();
        return typeName.substring(0, typeName.indexOf(60));
    }

    private static String getPrettyTypeName(QualifiedType type) {
        return type.resolveBinding().getQualifiedName();
    }

    private static String getPrettyTypeName(SimpleType type) {
        return type.resolveBinding().getQualifiedName();
    }

    static {
        primitiveTypes.put("B", Byte.TYPE);
        primitiveTypes.put("C", Character.TYPE);
        primitiveTypes.put("S", Short.TYPE);
        primitiveTypes.put("I", Integer.TYPE);
        primitiveTypes.put("J", Long.TYPE);
        primitiveTypes.put("F", Float.TYPE);
        primitiveTypes.put("D", Double.TYPE);
    }
}

