/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;

public class QuickFixContribution {
    final String clazzFqn;
    final String label;
    final String pattern;
    final Callable<? extends BugResolution> producer;
    final Map<String, String> args;

    public QuickFixContribution(@Nonnull String clazzFqn, @Nonnull String label, @Nonnull String pattern, @Nonnull Set<String> args, @Nonnull Callable<BugResolution> producer) {
        this.clazzFqn = clazzFqn;
        this.label = label;
        this.pattern = pattern;
        this.args = QuickFixContribution.convertToMap(args);
        this.producer = producer;
    }

    private static Map<String, String> convertToMap(Set<String> args) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String keyValue : args) {
            String[] keyValueArr = keyValue.split("\\s*=\\s*");
            if (keyValueArr.length <= 1) continue;
            params.put(keyValueArr[0], keyValueArr[1]);
        }
        return params.size() == 0 ? Collections.EMPTY_MAP : Collections.unmodifiableMap(params);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.clazzFqn.hashCode();
        result = 31 * result + this.label.hashCode();
        result = 31 * result + this.pattern.hashCode();
        result = 31 * result + this.args.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("QuickFixContribution [clazzFqn=").append(this.clazzFqn);
        builder.append(", label=").append(this.label).append(", pattern=");
        builder.append(this.pattern).append(", args=").append(this.args).append("]");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QuickFixContribution)) {
            return false;
        }
        QuickFixContribution other = (QuickFixContribution)obj;
        if (!this.clazzFqn.equals(other.clazzFqn)) {
            return false;
        }
        if (!this.label.equals(other.label)) {
            return false;
        }
        if (!this.pattern.equals(other.pattern)) {
            return false;
        }
        return this.args.equals(other.args);
    }
}

