/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import java.util.Map;
import javax.annotation.Nonnull;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

public class CreateSuperCallResolution
extends BugResolution {
    private boolean insertFirst;

    @Override
    public void setOptions(@Nonnull Map<String, String> options) {
        this.insertFirst = Boolean.parseBoolean(options.get("insertFirst"));
    }

    public boolean isInsertFirst() {
        return this.insertFirst;
    }

    @Override
    protected void repairBug(ASTRewrite rewrite, CompilationUnit workingUnit, BugInstance bug) throws BugResolutionException {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)workingUnit);
        Assert.isNotNull((Object)bug);
        TypeDeclaration type = ASTUtil.getTypeDeclaration(workingUnit, bug.getPrimaryClass());
        MethodDeclaration method = ASTUtil.getMethodDeclaration(type, bug.getPrimaryMethod());
        AST ast = rewrite.getAST();
        SuperMethodInvocation superCall = this.createSuperMethodInvocation(rewrite, method);
        ExpressionStatement statement = ast.newExpressionStatement((Expression)superCall);
        Block methodBody = method.getBody();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)methodBody, Block.STATEMENTS_PROPERTY);
        if (this.isInsertFirst()) {
            listRewrite.insertFirst((ASTNode)statement, null);
        } else {
            listRewrite.insertLast((ASTNode)statement, null);
        }
    }

    protected SuperMethodInvocation createSuperMethodInvocation(ASTRewrite rewrite, MethodDeclaration method) {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)method);
        AST ast = rewrite.getAST();
        SuperMethodInvocation invocation = ast.newSuperMethodInvocation();
        invocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)method.getName()));
        return invocation;
    }

    @Override
    protected boolean resolveBindings() {
        return true;
    }
}

