/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolutionAssociations;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.QuickFixContribution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.QuickFixesExtensionHelper;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class BugResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private BugResolutionAssociations bugResolutions;
    private boolean bugResolutionsLoaded;

    public BugResolutionAssociations getBugResolutions() {
        if (!this.bugResolutionsLoaded) {
            this.bugResolutionsLoaded = true;
            try {
                this.bugResolutions = BugResolutionGenerator.loadBugResolutions();
            }
            catch (Exception e) {
                FindbugsPlugin.getDefault().logException(e, "Could not read load bug resolutions");
            }
        }
        return this.bugResolutions;
    }

    private static BugResolutionAssociations loadBugResolutions() {
        Map<String, List<QuickFixContribution>> quickFixes = QuickFixesExtensionHelper.getContributedQuickFixes();
        return new BugResolutionAssociations(quickFixes);
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        String type = MarkerUtil.getBugPatternString(marker);
        if (type == null) {
            return null;
        }
        BugResolutionAssociations resolutions = this.getBugResolutions();
        if (resolutions == null) {
            return new IMarkerResolution[0];
        }
        return resolutions.createBugResolutions(type, marker);
    }

    public boolean hasResolutions(IMarker marker) {
        String type = MarkerUtil.getBugPatternString(marker);
        if (type == null) {
            return false;
        }
        BugResolutionAssociations resolutions = this.getBugResolutions();
        if (resolutions == null) {
            return false;
        }
        return resolutions.containsBugResolution(type);
    }
}

