/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.ApplicabilityVisitor;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.CustomLabelVisitor;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.ASTNodeNotFoundException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.ui.views.markers.internal.Util;

public abstract class BugResolution
extends WorkbenchMarkerResolution {
    private static final String MISSING_BUG_INSTANCE = "This bug is no longer in the system. The bugs somehow got out of sync with the memory representation. Try running FindBugs again. If that does not work, check the error log.";
    protected static final String PLACEHOLDER_STRING = "YYY";
    public static final String DEFAULT_REPLACEMENT = "XXX";
    private String label;
    private IProgressMonitor monitor;
    private String bugPattern;
    private IMarker currentMarker;
    private final Map<CompilationUnit, ASTRewrite> reusableRewrites = new HashMap<CompilationUnit, ASTRewrite>();
    private ICompilationUnit cachedCompilationUnitKey;
    private CompilationUnit cachedCompilationUnit;
    protected String customizedLabel;

    public BugResolution() {
        this.label = ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void setOptions(@Nonnull Map<String, String> options) {
    }

    @Nonnull
    public String getLabel() {
        ASTVisitor labelFixingVisitor = this.getCustomLabelVisitor();
        if (labelFixingVisitor instanceof CustomLabelVisitor) {
            if (this.customizedLabel == null) {
                String labelReplacement = this.findLabelReplacement(labelFixingVisitor);
                this.customizedLabel = this.label.replace(PLACEHOLDER_STRING, labelReplacement);
            }
            return this.customizedLabel;
        }
        return this.label;
    }

    @Nonnull
    private String findLabelReplacement(ASTVisitor labelFixingVisitor) {
        IMarker marker = this.getMarker();
        try {
            ASTNode node = this.getNodeForMarker(marker);
            if (node != null) {
                node.accept(labelFixingVisitor);
                String retVal = ((CustomLabelVisitor)labelFixingVisitor).getLabelReplacement();
                return retVal == null ? DEFAULT_REPLACEMENT : retVal;
            }
        }
        catch (ASTNodeNotFoundException | RuntimeException | JavaModelException e) {
            FindbugsPlugin.getDefault().logException(e, e.getLocalizedMessage());
            return DEFAULT_REPLACEMENT;
        }
        return DEFAULT_REPLACEMENT;
    }

    @CheckForNull
    protected ASTVisitor getCustomLabelVisitor() {
        return null;
    }

    @CheckForNull
    protected ASTNode getNodeForMarker(IMarker marker) throws JavaModelException, ASTNodeNotFoundException {
        BugInstance bug = MarkerUtil.findBugInstanceForMarker(marker);
        if (bug == null) {
            return null;
        }
        ICompilationUnit originalUnit = this.getCompilationUnit(marker);
        if (originalUnit == null) {
            return null;
        }
        CompilationUnit workingUnit = this.createWorkingCopy(originalUnit);
        return ASTUtil.getASTNode(workingUnit, bug.getPrimarySourceLineAnnotation());
    }

    public void setLabel(String label) {
        Objects.requireNonNull(label, "label");
        this.label = label;
    }

    public String getDescription() {
        return this.getLabel();
    }

    public Image getImage() {
        ImageRegistry registry = FindbugsPlugin.getDefault().getImageRegistry();
        return registry.get("buggy-tiny-gray.png");
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        HashSet<IMarker> set = new HashSet<IMarker>(markers.length);
        for (IMarker other : markers) {
            String pattern;
            if (this.currentMarker == other || !MarkerUtil.isFindBugsMarker(other) || (pattern = MarkerUtil.getBugPatternString(other)) == null || !pattern.equals(this.bugPattern)) continue;
            set.add(other);
        }
        IMarker[] retVal = set.toArray(new IMarker[set.size()]);
        de.tobject.findbugs.util.Util.sortIMarkers(retVal);
        return retVal;
    }

    @CheckForNull
    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void run(IMarker[] markers, IProgressMonitor multipleFixMonitor) {
        de.tobject.findbugs.util.Util.sortIMarkers(markers);
        ArrayList<PendingRewrite> pendingRewrites = new ArrayList<PendingRewrite>(markers.length);
        for (int i = 0; i < markers.length; ++i) {
            if (multipleFixMonitor != null) {
                multipleFixMonitor.subTask(Util.getProperty((String)"message", (IMarker)markers[i]));
            }
            pendingRewrites.add(this.resolveWithoutWriting(markers[i]));
        }
        for (PendingRewrite pendingRewrite : pendingRewrites) {
            this.completeRewrite(pendingRewrite);
        }
    }

    @CheckForNull
    private IRegion completeRewrite(PendingRewrite p) {
        try {
            if (p != null) {
                return this.rewriteCompilationUnit(p.rewrite, (IDocument)p.doc, p.originalUnit);
            }
        }
        catch (JavaModelException | BadLocationException e) {
            this.reportException((Exception)e);
        }
        return null;
    }

    @CheckForNull
    private PendingRewrite resolveWithoutWriting(IMarker marker) {
        Objects.requireNonNull(marker, "marker");
        ICompilationUnit originalUnit = null;
        try {
            BugInstance bug = MarkerUtil.findBugInstanceForMarker(marker);
            if (bug == null) {
                throw new BugResolutionException(MISSING_BUG_INSTANCE);
            }
            IProject project = marker.getResource().getProject();
            originalUnit = this.getCompilationUnit(marker);
            if (originalUnit == null) {
                throw new BugResolutionException("No compilation unit found for marker " + marker.getType() + " (" + marker.getId() + ')');
            }
            Document doc = new Document(originalUnit.getBuffer().getContents());
            CompilationUnit workingUnit = this.makeOrReuseWorkingCopy(originalUnit);
            ASTRewrite rewrite = this.makeOrReuseRewrite(workingUnit);
            this.repairBug(rewrite, workingUnit, bug);
            marker.delete();
            FindbugsPlugin.getBugCollection(project, this.monitor).remove(bug);
            return new PendingRewrite(rewrite, doc, originalUnit);
        }
        catch (BugResolutionException | CoreException e) {
            try {
                if (originalUnit != null) {
                    originalUnit.discardWorkingCopy();
                }
            }
            catch (JavaModelException e1) {
                this.reportException((Exception)((Object)e1));
            }
            this.reportException((Exception)e);
            return null;
        }
    }

    private CompilationUnit makeOrReuseWorkingCopy(@Nonnull ICompilationUnit originalUnit) throws JavaModelException {
        if (originalUnit.equals(this.cachedCompilationUnitKey)) {
            return this.cachedCompilationUnit;
        }
        this.cachedCompilationUnit = this.createWorkingCopy(originalUnit);
        this.cachedCompilationUnitKey = originalUnit;
        return this.cachedCompilationUnit;
    }

    private ASTRewrite makeOrReuseRewrite(CompilationUnit workingUnit) {
        ASTRewrite rewrite = this.reusableRewrites.get(workingUnit);
        if (rewrite != null) {
            return rewrite;
        }
        rewrite = ASTRewrite.create((AST)workingUnit.getAST());
        this.reusableRewrites.put(workingUnit, rewrite);
        return rewrite;
    }

    public void run(IMarker marker) {
        Objects.requireNonNull(marker, "marker");
        try {
            this.runInternal(marker);
        }
        catch (CoreException e) {
            this.reportException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInternal(IMarker marker) throws CoreException {
        Assert.isNotNull((Object)marker);
        PendingRewrite pending = this.resolveWithoutWriting(marker);
        if (pending == null) {
            return;
        }
        try {
            IRegion region = this.completeRewrite(pending);
            if (region == null) {
                return;
            }
            IEditorPart part = EditorUtility.isOpenInEditor((Object)pending.originalUnit);
            if (part instanceof ITextEditor) {
                ((ITextEditor)part).selectAndReveal(region.getOffset(), region.getLength());
            }
        }
        finally {
            pending.originalUnit.discardWorkingCopy();
        }
    }

    protected abstract boolean resolveBindings();

    protected abstract void repairBug(ASTRewrite var1, CompilationUnit var2, BugInstance var3) throws BugResolutionException;

    @CheckForNull
    protected ICompilationUnit getCompilationUnit(IMarker marker) {
        IJavaElement element;
        IResource res = marker.getResource();
        if (res instanceof IFile && res.isAccessible() && (element = JavaCore.create((IFile)((IFile)res))) instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }

    protected void reportException(Exception e) {
        Assert.isNotNull((Object)e);
        FindbugsPlugin.getDefault().logException(e, e.getLocalizedMessage());
        MessageDialog.openError((Shell)FindbugsPlugin.getShell(), (String)"BugResolution failed.", (String)e.getLocalizedMessage());
    }

    @Nonnull
    protected final CompilationUnit createWorkingCopy(@Nonnull ICompilationUnit unit) throws JavaModelException {
        unit.becomeWorkingCopy(this.monitor);
        ASTParser parser = BugResolution.createAstParser();
        parser.setSource(unit);
        parser.setResolveBindings(this.resolveBindings());
        return (CompilationUnit)parser.createAST(this.monitor);
    }

    private static ASTParser createAstParser() {
        ASTParser parser;
        int safeLevel = 3;
        int JLS4 = 4;
        int JLS8 = 8;
        try {
            parser = ASTParser.newParser((int)JLS8);
        }
        catch (IllegalArgumentException e1) {
            try {
                parser = ASTParser.newParser((int)JLS4);
            }
            catch (IllegalArgumentException e2) {
                parser = ASTParser.newParser((int)safeLevel);
            }
        }
        return parser;
    }

    private IRegion rewriteCompilationUnit(ASTRewrite rewrite, IDocument doc, ICompilationUnit originalUnit) throws JavaModelException, BadLocationException {
        TextEdit edits = rewrite.rewriteAST(doc, originalUnit.getJavaProject().getOptions(true));
        edits.apply(doc);
        originalUnit.getBuffer().setContents(doc.get());
        originalUnit.commitWorkingCopy(false, this.monitor);
        return edits.getRegion();
    }

    @CheckForNull
    public String getBugPattern() {
        return this.bugPattern;
    }

    public void setBugPattern(@Nonnull String pattern) {
        Objects.requireNonNull(pattern);
        this.bugPattern = pattern;
    }

    public IMarker getMarker() {
        return this.currentMarker;
    }

    public void setMarker(IMarker initialMarker) {
        Objects.requireNonNull(initialMarker);
        this.currentMarker = initialMarker;
    }

    public boolean isApplicable(IMarker marker) {
        ASTVisitor prescanVisitor = this.getApplicabilityVisitor();
        if (prescanVisitor instanceof ApplicabilityVisitor) {
            return this.findApplicability(prescanVisitor, marker);
        }
        return true;
    }

    private boolean findApplicability(ASTVisitor prescanVisitor, IMarker marker) {
        try {
            ASTNode node = this.getNodeForMarker(marker);
            if (node != null) {
                node.accept(prescanVisitor);
                return ((ApplicabilityVisitor)prescanVisitor).isApplicable();
            }
        }
        catch (ASTNodeNotFoundException | RuntimeException | JavaModelException e) {
            FindbugsPlugin.getDefault().logException(e, e.getLocalizedMessage());
            return true;
        }
        return true;
    }

    protected ASTVisitor getApplicabilityVisitor() {
        return null;
    }

    private static class PendingRewrite {
        public ICompilationUnit originalUnit;
        public Document doc;
        public ASTRewrite rewrite;

        public PendingRewrite(ASTRewrite rewrite, Document doc, ICompilationUnit originalUnit) {
            this.rewrite = rewrite;
            this.doc = doc;
            this.originalUnit = originalUnit;
        }
    }
}

