/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.Util;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.bcel.classfile.Code;

public class InfiniteLoop
extends OpcodeStackDetector {
    ArrayList<BitSet> regModifiedAt = new ArrayList();
    BugReporter bugReporter;
    HashSet<Jump> backwardReach = new HashSet();
    HashSet<BackwardsBranch> backwardBranches = new HashSet();
    HashSet<ForwardConditionalBranch> forwardConditionalBranches = new HashSet();
    LinkedList<Jump> forwardJumps = new LinkedList();
    static final boolean DEBUG = false;

    @Nonnull
    BitSet getModifiedBitSet(int reg) {
        while (this.regModifiedAt.size() <= reg) {
            this.regModifiedAt.add(new BitSet());
        }
        return this.regModifiedAt.get(reg);
    }

    private void regModifiedAt(int reg, int pc) {
        BitSet b = this.getModifiedBitSet(reg);
        b.set(pc);
    }

    private void clearRegModified() {
        for (BitSet b : this.regModifiedAt) {
            b.clear();
        }
    }

    private boolean isRegModified(int reg, int firstPC, int lastPC) {
        if (reg < 0) {
            return false;
        }
        BitSet b = this.getModifiedBitSet(reg);
        int modified = b.nextSetBit(firstPC);
        return modified >= firstPC && modified <= lastPC;
    }

    void purgeForwardJumps(int before) {
    }

    void addForwardJump(int from, int to) {
        if (from >= to) {
            return;
        }
        this.purgeForwardJumps(from);
        this.forwardJumps.add(new Jump(from, to));
    }

    int getFurthestJump(int from) {
        int result = Integer.MIN_VALUE;
        int from2 = this.getBackwardsReach(from);
        assert (from2 <= from);
        from = from2;
        for (Jump f : this.forwardJumps) {
            if (f.from < from || f.to <= result) continue;
            result = f.to;
        }
        return result;
    }

    public InfiniteLoop(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Code obj) {
        this.clearRegModified();
        this.backwardBranches.clear();
        this.forwardConditionalBranches.clear();
        this.forwardJumps.clear();
        this.backwardReach.clear();
        super.visit(obj);
        block0: for (BackwardsBranch bb : this.backwardBranches) {
            int reg1;
            LinkedList<ForwardConditionalBranch> myForwardBranches = new LinkedList<ForwardConditionalBranch>();
            int myBackwardsReach = this.getBackwardsReach(bb.to);
            for (ForwardConditionalBranch fcb : this.forwardConditionalBranches) {
                if (myBackwardsReach >= fcb.from || fcb.from >= bb.from || bb.from >= fcb.to) continue;
                myForwardBranches.add(fcb);
            }
            if (myForwardBranches.size() != 1) continue;
            ForwardConditionalBranch fcb = (ForwardConditionalBranch)myForwardBranches.get(0);
            for (Jump fj : this.forwardJumps) {
                if (fcb.from == fj.from || myBackwardsReach >= fj.from || fj.from >= bb.from || bb.from >= fj.to) continue;
                continue block0;
            }
            if (!this.isConstant(fcb.item0, bb) || !this.isConstant(fcb.item1, bb)) continue;
            SourceLineAnnotation loopBottom = SourceLineAnnotation.fromVisitedInstruction(this.getClassContext(), this, bb.from);
            int loopBottomLine = loopBottom.getStartLine();
            SourceLineAnnotation loopTop = SourceLineAnnotation.fromVisitedInstruction(this.getClassContext(), this, bb.to);
            int loopTopLine = loopTop.getStartLine();
            BugInstance bug = new BugInstance(this, "IL_INFINITE_LOOP", 1).addClassAndMethod(this).addSourceLine(this, fcb.from).addSourceLine(loopBottom).describe("SOURCE_LINE_LOOP_BOTTOM");
            int reg0 = fcb.item0.getRegisterNumber();
            boolean reg0Invariant = true;
            if (reg0 >= 0 && fcb.item0.getConstant() == null) {
                reg0Invariant = !this.isRegModified(reg0, myBackwardsReach, bb.from);
                SourceLineAnnotation lastChange = SourceLineAnnotation.fromVisitedInstruction(this.getClassContext(), this, this.constantSince(fcb.item0));
                int lastChangeLine = lastChange.getEndLine();
                if (loopBottomLine != -1 && lastChangeLine != -1 && loopTopLine != -1 && loopTopLine <= lastChangeLine && lastChangeLine < loopBottomLine) continue;
                bug.add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), reg0, fcb.from, bb.from)).addSourceLine(lastChange).describe("SOURCE_LINE_LAST_CHANGE");
            }
            if ((reg1 = fcb.item1.getRegisterNumber()) >= 0 && reg1 != reg0 && fcb.item1.getConstant() == null) {
                SourceLineAnnotation lastChange = SourceLineAnnotation.fromVisitedInstruction(this.getClassContext(), this, this.constantSince(fcb.item1));
                int lastChangeLine = lastChange.getEndLine();
                if (loopBottomLine != -1 && lastChangeLine != -1 && loopTopLine != -1 && loopTopLine <= lastChangeLine && lastChangeLine < loopBottomLine) continue;
                bug.add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), reg1, fcb.from, bb.from)).addSourceLine(lastChange).describe("SOURCE_LINE_LAST_CHANGE");
            }
            boolean reg1Invariant = true;
            if (reg1 >= 0) {
                boolean bl = reg1Invariant = !this.isRegModified(reg1, myBackwardsReach, bb.from);
            }
            if (!reg0Invariant || !reg1Invariant) continue;
            this.bugReporter.reportBug(bug);
        }
    }

    private boolean isConstant(OpcodeStack.Item item0, BackwardsBranch bb) {
        int reg = item0.getRegisterNumber();
        if (reg >= 0) {
            return bb.invariantRegisters.contains(reg) || reg >= bb.numLastUpdates;
        }
        return item0.getConstant() != null;
    }

    @Override
    public void sawBranchTo(int target) {
        this.addForwardJump(this.getPC(), target);
    }

    @Override
    public void sawOpcode(int seen) {
        if (this.isRegisterStore()) {
            this.regModifiedAt(this.getRegisterOperand(), this.getPC());
        }
        switch (seen) {
            case 167: {
                if (this.getBranchOffset() >= 0) break;
                BackwardsBranch bb = new BackwardsBranch(this.stack, this.getPC(), this.getBranchTarget());
                if (bb.invariantRegisters.size() > 0) {
                    this.backwardBranches.add(bb);
                }
                this.addBackwardsReach();
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                this.addForwardJump(this.getPC(), Integer.MAX_VALUE);
                break;
            }
            case 170: 
            case 171: {
                OpcodeStack.Item item0 = this.stack.getStackItem(0);
                if (this.getDefaultSwitchOffset() > 0) {
                    this.forwardConditionalBranches.add(new ForwardConditionalBranch(item0, item0, this.getPC(), this.getPC() + this.getDefaultSwitchOffset()));
                }
                for (int offset : this.getSwitchOffsets()) {
                    if (offset <= 0) continue;
                    this.forwardConditionalBranches.add(new ForwardConditionalBranch(item0, item0, this.getPC(), this.getPC() + offset));
                }
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.addBackwardsReach();
                OpcodeStack.Item item0 = this.stack.getStackItem(0);
                int target = this.getBranchTarget();
                if (this.getBranchOffset() > 0) {
                    this.forwardConditionalBranches.add(new ForwardConditionalBranch(item0, item0, this.getPC(), target));
                    break;
                }
                if (this.getFurthestJump(target) > this.getPC() || !this.constantSince(item0, target)) break;
                int since0 = this.constantSince(item0);
                BugInstance bug = new BugInstance(this, "IL_INFINITE_LOOP", 1).addClassAndMethod(this).addSourceLine(this, this.getPC());
                int reg0 = item0.getRegisterNumber();
                if (reg0 >= 0) {
                    bug.add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), reg0, this.getPC(), target)).addSourceLine(this, since0);
                }
                if (reg0 >= 0 && this.isRegModified(reg0, target, this.getPC())) break;
                this.reportPossibleBug(bug);
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                int reg1;
                this.addBackwardsReach();
                OpcodeStack.Item item0 = this.stack.getStackItem(0);
                OpcodeStack.Item item1 = this.stack.getStackItem(1);
                int target = this.getBranchTarget();
                if (this.getBranchOffset() > 0) {
                    this.forwardConditionalBranches.add(new ForwardConditionalBranch(item0, item1, this.getPC(), target));
                    break;
                }
                if (this.getFurthestJump(target) > this.getPC() || !this.constantSince(item0, target) || !this.constantSince(item1, target)) break;
                BugInstance bug = new BugInstance(this, "IL_INFINITE_LOOP", 1).addClassAndMethod(this).addSourceLine(this, this.getPC());
                int reg0 = item0.getRegisterNumber();
                if (reg0 >= 0) {
                    bug.add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), reg0, this.getPC(), target));
                }
                if ((reg1 = item1.getRegisterNumber()) >= 0) {
                    bug.add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), reg1, this.getPC(), target));
                }
                this.reportPossibleBug(bug);
                break;
            }
        }
    }

    private void addBackwardsReach() {
        if (this.getBranchOffset() >= 0) {
            return;
        }
        int target = this.getBranchTarget();
        for (Jump j : this.backwardReach) {
            if (j.to >= target || target > j.from) continue;
            target = j.to;
        }
        assert (target <= this.getBranchTarget());
        assert (target < this.getPC());
        Iterator<Jump> i = this.backwardReach.iterator();
        while (i.hasNext()) {
            Jump j;
            j = i.next();
            if (target > j.to || this.getPC() < j.from) continue;
            i.remove();
        }
        this.backwardReach.add(new Jump(this.getPC(), target));
    }

    private int getBackwardsReach(int target) {
        int originalTarget = target;
        for (Jump j : this.backwardReach) {
            if (j.to >= target || target > j.from) continue;
            target = j.to;
        }
        assert (target <= originalTarget);
        return target;
    }

    private boolean constantSince(OpcodeStack.Item item1, int branchTarget) {
        int reg = item1.getRegisterNumber();
        if (reg >= 0) {
            return this.stack.getLastUpdate(reg) < this.getBackwardsReach(branchTarget);
        }
        return item1.getConstant() != null;
    }

    private int constantSince(OpcodeStack.Item item1) {
        int reg = item1.getRegisterNumber();
        if (reg >= 0) {
            return this.stack.getLastUpdate(reg);
        }
        return Integer.MAX_VALUE;
    }

    void reportPossibleBug(BugInstance bug) {
        int catchSize = Util.getSizeOfSurroundingTryBlock(this.getConstantPool(), this.getCode(), "java/io/EOFException", this.getPC());
        if (catchSize < Integer.MAX_VALUE) {
            bug.lowerPriorityALot();
        } else {
            catchSize = Util.getSizeOfSurroundingTryBlock(this.getConstantPool(), this.getCode(), "java/lang/NoSuchElementException", this.getPC());
            if (catchSize < Integer.MAX_VALUE) {
                bug.lowerPriorityALot();
            } else {
                LocalVariableAnnotation lv = bug.getPrimaryLocalVariableAnnotation();
                if (lv == null && "run".equals(this.getMethodName())) {
                    bug.lowerPriority();
                }
            }
        }
        this.bugReporter.reportBug(bug);
    }

    static class ForwardConditionalBranch
    extends Jump {
        final OpcodeStack.Item item0;
        final OpcodeStack.Item item1;

        ForwardConditionalBranch(OpcodeStack.Item item0, OpcodeStack.Item item1, int from, int to) {
            super(from, to);
            this.item0 = item0;
            this.item1 = item1;
        }

        @Override
        public int hashCode() {
            return 37 * super.hashCode() + 17 * this.item0.hashCode() + this.item1.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            ForwardConditionalBranch that = (ForwardConditionalBranch)o;
            return this.item0.sameValue(that.item0) && this.item1.sameValue(that.item1);
        }
    }

    static class BackwardsBranch
    extends Jump {
        final List<Integer> invariantRegisters = new LinkedList<Integer>();
        final int numLastUpdates;

        BackwardsBranch(OpcodeStack stack, int from, int to) {
            super(from, to);
            this.numLastUpdates = stack.getNumLastUpdates();
            for (int i = 0; i < this.numLastUpdates; ++i) {
                if (stack.getLastUpdate(i) >= to) continue;
                this.invariantRegisters.add(i);
            }
        }

        @Override
        public int hashCode() {
            return 37 * super.hashCode() + 17 * this.invariantRegisters.hashCode() + this.numLastUpdates;
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            BackwardsBranch that = (BackwardsBranch)o;
            return this.invariantRegisters.equals(that.invariantRegisters) && this.numLastUpdates == that.numLastUpdates;
        }
    }

    static class Jump {
        final int from;
        final int to;

        Jump(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return this.from + " -> " + this.to;
        }

        public int hashCode() {
            return this.from * 37 + this.to;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Jump that = (Jump)o;
            return this.from == that.from && this.to == that.to;
        }
    }
}

