/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.Confidence;
import edu.umd.cs.findbugs.annotations.DesireNoWarning;
import edu.umd.cs.findbugs.annotations.DesireWarning;
import edu.umd.cs.findbugs.annotations.ExpectWarning;
import edu.umd.cs.findbugs.annotations.NoWarning;
import edu.umd.cs.findbugs.annotations.Priority;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.classfile.analysis.EnumValue;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.CheckForNull;

public class CheckExpectedWarnings
implements Detector2,
NonReportingDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean("cew.debug");
    private BugReporter reporter;
    private final BugCollection bugCollection;
    private boolean initialized = false;
    private Map<ClassDescriptor, Collection<BugInstance>> warningsByClass;
    private Map<MethodDescriptor, Collection<BugInstance>> warningsByMethod;
    private Map<FieldDescriptor, Collection<BugInstance>> warningsByField;
    private ClassDescriptor expectWarning;
    private ClassDescriptor noWarning;
    private ClassDescriptor desireWarning;
    private ClassDescriptor desireNoWarning;
    private boolean warned;

    public CheckExpectedWarnings(BugReporter bugReporter) {
        this.bugCollection = bugReporter.getBugCollection();
        if (this.bugCollection != null) {
            this.reporter = bugReporter;
            this.expectWarning = DescriptorFactory.createClassDescriptor(ExpectWarning.class);
            this.noWarning = DescriptorFactory.createClassDescriptor(NoWarning.class);
            this.desireWarning = DescriptorFactory.createClassDescriptor(DesireWarning.class);
            this.desireNoWarning = DescriptorFactory.createClassDescriptor(DesireNoWarning.class);
        }
    }

    @Override
    public void visitClass(ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        if (this.reporter == null) {
            if (!this.warned) {
                System.err.println("*** NOTE ***: CheckExpectedWarnings disabled because bug reporter doesn't use a BugCollection");
                this.warned = true;
            }
            return;
        }
        if (!this.initialized) {
            this.initialized = true;
            this.warningsByClass = new HashMap<ClassDescriptor, Collection<BugInstance>>();
            this.warningsByMethod = new HashMap<MethodDescriptor, Collection<BugInstance>>();
            this.warningsByField = new HashMap<FieldDescriptor, Collection<BugInstance>>();
            for (BugInstance warning : this.bugCollection) {
                ClassAnnotation clazz;
                FieldAnnotation fieldAnnotation;
                MethodAnnotation method = warning.getPrimaryMethod();
                if (method != null) {
                    MethodDescriptor methodDescriptor = method.toMethodDescriptor();
                    Collection<BugInstance> warnings = this.warningsByMethod.get(methodDescriptor);
                    if (warnings == null) {
                        warnings = new LinkedList<BugInstance>();
                        this.warningsByMethod.put(methodDescriptor, warnings);
                    }
                    warnings.add(warning);
                }
                if ((fieldAnnotation = warning.getPrimaryField()) != null) {
                    FieldDescriptor fieldDescriptor;
                    Collection<BugInstance> warnings;
                    if (DEBUG) {
                        System.out.println("primary field of " + fieldAnnotation + " for " + warning);
                    }
                    if ((warnings = this.warningsByField.get(fieldDescriptor = fieldAnnotation.toFieldDescriptor())) == null) {
                        warnings = new LinkedList<BugInstance>();
                        this.warningsByField.put(fieldDescriptor, warnings);
                    }
                    warnings.add(warning);
                }
                if ((clazz = warning.getPrimaryClass()) == null) continue;
                ClassDescriptor classDesc = clazz.getClassDescriptor();
                if (fieldAnnotation != null && classDesc.equals(fieldAnnotation.getClassDescriptor()) || method != null && classDesc.equals(method.getClassDescriptor())) continue;
                Collection<BugInstance> warnings = this.warningsByClass.get(classDesc);
                if (warnings == null) {
                    warnings = new LinkedList<BugInstance>();
                    this.warningsByClass.put(classDesc, warnings);
                }
                warnings.add(warning);
            }
        }
        XClass xclass = Global.getAnalysisCache().getClassAnalysis(XClass.class, classDescriptor);
        List<? extends XMethod> methods = xclass.getXMethods();
        if (DEBUG) {
            System.out.println("CEW: checking " + xclass.toString());
        }
        if (xclass.isSynthetic()) {
            if (DEBUG) {
                System.out.println("Skipping synthetic classxclass " + xclass.toString());
            }
            return;
        }
        this.check(xclass, this.expectWarning, true, 1);
        this.check(xclass, this.desireWarning, true, 2);
        this.check(xclass, this.noWarning, false, 1);
        this.check(xclass, this.desireNoWarning, false, 2);
        for (XMethod xMethod : methods) {
            if (DEBUG) {
                System.out.println("CEW: checking " + xMethod.toString());
            }
            if (xMethod.isSynthetic()) {
                if (!DEBUG) continue;
                System.out.println("Skipping synthetic method " + xMethod.toString());
                continue;
            }
            this.check(xMethod, this.expectWarning, true, 1);
            this.check(xMethod, this.desireWarning, true, 2);
            this.check(xMethod, this.noWarning, false, 1);
            this.check(xMethod, this.desireNoWarning, false, 2);
        }
        for (XField xField : xclass.getXFields()) {
            if (DEBUG) {
                System.out.println("CEW: checking " + xField.toString());
            }
            if (xField.isSynthetic()) {
                if (!DEBUG) continue;
                System.out.println("Skipping synthetic field " + xField.toString());
                continue;
            }
            this.check(xField, this.expectWarning, true, 1);
            this.check(xField, this.desireWarning, true, 2);
            this.check(xField, this.noWarning, false, 1);
            this.check(xField, this.desireNoWarning, false, 2);
        }
    }

    private void check(XClass xclass, ClassDescriptor annotation, boolean expectWarnings, int priority) {
        AnnotationValue expect = xclass.getAnnotation(annotation);
        if (expect == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("*** Found " + annotation + " annotation on " + xclass);
        }
        ClassDescriptor descriptor = xclass.getClassDescriptor();
        Collection<BugInstance> warnings = this.warningsByClass.get(descriptor);
        this.check(expect, descriptor, warnings, expectWarnings, priority, descriptor);
    }

    private void check(XMethod xmethod, ClassDescriptor annotation, boolean expectWarnings, int priority) {
        AnnotationValue expect = xmethod.getAnnotation(annotation);
        if (expect == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("*** Found " + annotation + " annotation on " + xmethod);
        }
        MethodDescriptor descriptor = xmethod.getMethodDescriptor();
        Collection<BugInstance> warnings = this.warningsByMethod.get(descriptor);
        this.check(expect, descriptor, warnings, expectWarnings, priority, descriptor.getClassDescriptor());
    }

    private void check(XField xfield, ClassDescriptor annotation, boolean expectWarnings, int priority) {
        AnnotationValue expect = xfield.getAnnotation(annotation);
        if (expect == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("*** Found " + annotation + " annotation on " + xfield);
        }
        FieldDescriptor descriptor = xfield.getFieldDescriptor();
        Collection<BugInstance> warnings = this.warningsByField.get(descriptor);
        this.check(expect, descriptor, warnings, expectWarnings, priority, descriptor.getClassDescriptor());
    }

    private void check(AnnotationValue expect, Object descriptor, Collection<BugInstance> warnings, boolean expectWarnings, int priority, ClassDescriptor cd) {
        if (expect != null) {
            Integer rank;
            String expectedBugCodes = (String)expect.getValue("value");
            EnumValue wantedConfidence = (EnumValue)expect.getValue("confidence");
            EnumValue wantedPriority = (EnumValue)expect.getValue("priority");
            Integer num = (Integer)expect.getValue("num");
            if (num == null) {
                num = expectWarnings ? 1 : 0;
            }
            if ((rank = (Integer)expect.getValue("rank")) == null) {
                rank = 20;
            }
            int minPriority = Confidence.LOW.getConfidenceValue();
            if (wantedConfidence != null) {
                minPriority = Confidence.valueOf((String)wantedConfidence.value).getConfidenceValue();
            } else if (wantedPriority != null) {
                minPriority = Priority.valueOf((String)wantedPriority.value).getPriorityValue();
            }
            if (DEBUG) {
                if (warnings == null) {
                    System.out.println("Checking " + expectedBugCodes + " against no bugs");
                } else {
                    System.out.println("Checking " + expectedBugCodes + " against " + warnings.size() + " bugs");
                    for (BugInstance b : warnings) {
                        System.out.println("  " + b.getType());
                    }
                }
            }
            if (expectedBugCodes == null || expectedBugCodes.trim().length() == 0) {
                this.checkAnnotation(null, warnings, expectWarnings, priority, rank, num, descriptor, minPriority, cd);
            } else {
                StringTokenizer tok = new StringTokenizer(expectedBugCodes, ",");
                while (tok.hasMoreTokens()) {
                    String bugCode = tok.nextToken().trim();
                    this.checkAnnotation(bugCode, warnings, expectWarnings, priority, rank, num, descriptor, minPriority, cd);
                }
            }
        }
    }

    public void checkAnnotation(@CheckForNull String bugCode, Collection<BugInstance> warnings, boolean expectWarnings, int priority, Integer rank, Integer num, Object methodDescriptor, int minPriority, ClassDescriptor cd) {
        String bugCodeMessage = bugCode != null ? bugCode : "any bug";
        Collection<SourceLineAnnotation> bugs = CheckExpectedWarnings.countWarnings(warnings, bugCode, minPriority, rank);
        if (expectWarnings && bugs.size() < num) {
            if (DetectorFactoryCollection.instance().isDisabledByDefault(bugCode)) {
                return;
            }
            BugInstance bug = this.makeWarning("FB_MISSING_EXPECTED_WARNING", methodDescriptor, priority, cd).addString(bugCodeMessage);
            if (!bugs.isEmpty()) {
                bug.addString(String.format("Expected %d bugs, saw %d", num, bugs.size()));
            }
            this.reporter.reportBug(bug);
        } else if (bugs.size() > num) {
            BugInstance bug = this.makeWarning("FB_UNEXPECTED_WARNING", methodDescriptor, priority, cd).addString(bugCodeMessage);
            if (!expectWarnings) {
                for (SourceLineAnnotation s : bugs) {
                    this.reporter.reportBug(bug.add(s));
                }
            } else if (num > 1) {
                bug.addString(String.format("Expected %d bugs, saw %d", num, bugs.size()));
                this.reporter.reportBug(bug);
            }
        }
    }

    public BugInstance makeWarning(String bugPattern, Object descriptor, int priority, ClassDescriptor cd) {
        BugInstance bug = new BugInstance(this, bugPattern, priority).addClass(cd);
        if (descriptor instanceof FieldDescriptor) {
            bug.addField((FieldDescriptor)descriptor);
        } else if (descriptor instanceof MethodDescriptor) {
            bug.addMethod((MethodDescriptor)descriptor);
        } else if (descriptor instanceof ClassDescriptor) {
            bug.addClass((ClassDescriptor)descriptor);
        }
        if (DEBUG) {
            System.out.println("Reporting " + bug);
        }
        return bug;
    }

    private static Collection<SourceLineAnnotation> countWarnings(Collection<BugInstance> warnings, @CheckForNull String bugCode, int desiredPriority, int rank) {
        HashSet<SourceLineAnnotation> matching = new HashSet<SourceLineAnnotation>();
        DetectorFactoryCollection i18n = DetectorFactoryCollection.instance();
        boolean matchPattern = false;
        try {
            i18n.getBugCode(bugCode);
        }
        catch (IllegalArgumentException e) {
            matchPattern = true;
        }
        if (warnings != null) {
            for (BugInstance warning : warnings) {
                if (warning.getPriority() > desiredPriority || warning.getBugRank() > rank) continue;
                if (bugCode == null) {
                    matching.add(warning.getPrimarySourceLineAnnotation());
                    matching.addAll(warning.getAnotherInstanceSourceLineAnnotations());
                    continue;
                }
                BugPattern pattern = warning.getBugPattern();
                String match = matchPattern ? pattern.getType() : pattern.getAbbrev();
                if (!match.equals(bugCode)) continue;
                matching.add(warning.getPrimarySourceLineAnnotation());
                matching.addAll(warning.getAnotherInstanceSourceLineAnnotations());
            }
        }
        return matching;
    }

    @Override
    public void finishPass() {
        HashSet<BugPattern> claimedReported = new HashSet<BugPattern>();
        for (DetectorFactory d : DetectorFactoryCollection.instance().getFactories()) {
            claimedReported.addAll(d.getReportedBugPatterns());
        }
        for (BugPattern b : DetectorFactoryCollection.instance().getBugPatterns()) {
            String category = b.getCategory();
            if (b.isDeprecated() || "EXPERIMENTAL".equals(category) || claimedReported.contains(b)) continue;
            AnalysisContext.logError("No detector claims " + b.getType());
        }
    }

    @Override
    public String getDetectorClassName() {
        return CheckExpectedWarnings.class.getName();
    }
}

