/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.properties;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.util.Util;
import de.tobject.findbugs.view.AbstractFindbugsView;
import de.tobject.findbugs.view.BugExplorerView;
import de.tobject.findbugs.view.explorer.BugGroup;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.Plugin;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class PropertyPageAdapterFactory
implements IAdapterFactory {
    static List<Method> getGetters(Object obj) {
        Method[] methods;
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method method : methods = obj.getClass().getMethods()) {
            String name;
            if (method.getParameterTypes().length != 0 || !(name = method.getName()).startsWith("get") && !name.startsWith("is") && !name.startsWith("has") || "getClass".equals(name) || "hashCode".equals(name)) continue;
            methodList.add(method);
        }
        return methodList;
    }

    public static String getReadableName(Method method) {
        String name = method.getName();
        return name.startsWith("get") || name.startsWith("has") ? name.substring(3) : (name.startsWith("is") ? name.substring(2) : name);
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IPropertySheetPage.class && (adaptableObject instanceof BugExplorerView || adaptableObject instanceof JavaEditor || adaptableObject instanceof AbstractFindbugsView)) {
            return new BugPropertySheetPage();
        }
        if (adapterType == IPropertySource.class) {
            if (adaptableObject instanceof BugPattern || adaptableObject instanceof BugInstance || adaptableObject instanceof DetectorFactory || adaptableObject instanceof Plugin || adaptableObject instanceof BugInstance.XmlProps || adaptableObject instanceof BugGroup || adaptableObject instanceof BugAnnotation) {
                return new PropertySource(adaptableObject);
            }
            IMarker marker = Util.getAdapter(IMarker.class, adaptableObject);
            if (!MarkerUtil.isFindBugsMarker(marker)) {
                return null;
            }
            return new MarkerPropertySource(marker);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IPropertySheetPage.class, IPropertySource.class};
    }

    private static class BugPropertySheetPage
    extends TabbedPropertySheetPage {
        private boolean isDisposed;
        static ITabbedPropertySheetPageContributor contributor = new ITabbedPropertySheetPageContributor(){

            public String getContributorId() {
                return "de.tobject.findbugs.view.bugtreeview";
            }
        };

        public BugPropertySheetPage() {
            super(contributor);
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (this.isDisposed) {
                return;
            }
            if (part instanceof ITextEditor && selection instanceof ITextSelection) {
                IMarker marker = MarkerUtil.getMarkerFromEditor((ITextSelection)selection, (IEditorPart)((ITextEditor)part));
                selection = marker != null ? new StructuredSelection((Object)marker) : new StructuredSelection();
            }
            super.selectionChanged(part, selection);
        }

        public void dispose() {
            this.isDisposed = true;
            super.dispose();
        }
    }

    public static class MarkerPropertySource
    implements IPropertySource {
        private final IMarker marker;
        private final IPropertyDescriptor[] propertyDescriptors;

        public MarkerPropertySource(IMarker marker) {
            this.marker = marker;
            ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
            try {
                Map attributes = marker.getAttributes();
                TreeSet keySet = new TreeSet(attributes.keySet());
                for (Object object : keySet) {
                    props.add(new PropertyDescriptor(object, "" + object));
                }
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException(e, "MarkerPropertySource: marker access failed");
            }
            props.add(new PropertyDescriptor((Object)PropId.Bug, "Bug"));
            props.add(new PropertyDescriptor((Object)PropId.Resource, "Resource"));
            props.add(new PropertyDescriptor((Object)PropId.Id, "Marker id"));
            props.add(new PropertyDescriptor((Object)PropId.Type, "Marker type"));
            props.add(new PropertyDescriptor((Object)PropId.CreationTime, "Creation time"));
            this.propertyDescriptors = (IPropertyDescriptor[])props.toArray(new PropertyDescriptor[0]);
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        public Object getPropertyValue(Object propId) {
            try {
                if (propId instanceof PropId) {
                    PropId id = (PropId)((Object)propId);
                    switch (id) {
                        case Bug: {
                            return MarkerUtil.findBugInstanceForMarker(this.marker);
                        }
                        case Resource: {
                            return this.marker.getResource();
                        }
                        case Id: {
                            return this.marker.getId();
                        }
                        case CreationTime: {
                            return new Date(this.marker.getCreationTime());
                        }
                        case Type: {
                            return this.marker.getType();
                        }
                    }
                } else if (propId instanceof String) {
                    return this.marker.getAttribute((String)propId);
                }
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException(e, "getPropertyValue: marker access failed");
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }

    static enum PropId {
        Type,
        Resource,
        Bug,
        Id,
        CreationTime;

    }

    public static class ArrayPropertySource
    implements IPropertySource {
        private final Object[] array;
        private final IPropertyDescriptor[] propertyDescriptors;

        public ArrayPropertySource(Object[] object) {
            this.array = object;
            ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
            for (Object obj : this.array) {
                props.add(new PropertyDescriptor(obj, this.getDisplayName(obj)));
            }
            this.propertyDescriptors = (IPropertyDescriptor[])props.toArray(new PropertyDescriptor[0]);
        }

        private String getDisplayName(Object obj) {
            if (obj instanceof IMarker) {
                return "Marker " + ((IMarker)obj).getId();
            }
            return "" + obj;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        public Object getPropertyValue(Object propId) {
            return propId;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }

    public static class PropertySource
    implements IPropertySource {
        private final Object object;
        private final IPropertyDescriptor[] propertyDescriptors;

        public PropertySource(Object object) {
            this.object = object;
            ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
            List<Method> getters = PropertyPageAdapterFactory.getGetters(object);
            for (Method method : getters) {
                props.add(new PropertyDescriptor((Object)method, PropertyPageAdapterFactory.getReadableName(method)));
            }
            this.propertyDescriptors = (IPropertyDescriptor[])props.toArray(new PropertyDescriptor[0]);
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        public Object getPropertyValue(Object propId) {
            if (propId instanceof Method) {
                Method method = (Method)propId;
                try {
                    Object object2 = method.invoke(this.object, (Object[])null);
                    if (object2 != null) {
                        if (object2.getClass().isArray()) {
                            return new ArrayPropertySource((Object[])object2);
                        }
                        if (Collection.class.isAssignableFrom(object2.getClass())) {
                            Collection coll = (Collection)object2;
                            return new ArrayPropertySource(coll.toArray());
                        }
                    }
                    return object2;
                }
                catch (Exception e) {
                    FindbugsPlugin.getDefault().logException(e, "getPropertyValue: method access failed");
                }
            }
            return null;
        }

        public Object getEditableValue() {
            return null;
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }
}

