/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.marker.FindBugsMarker;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.view.explorer.BugGroup;
import de.tobject.findbugs.view.explorer.MarkerMapper;
import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Plugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IWorkingSet;

public enum GroupType {
    Workspace(false, MarkerMapper.NO_MAPPING),
    WorkingSet(false, MarkerMapper.NO_MAPPING),
    DetectorPlugin(true, new MarkerMapper<Plugin>(){

        @Override
        Plugin getIdentifier(IMarker marker) {
            return MarkerUtil.findDetectorPluginFor(marker);
        }

        @Override
        String getShortDescription(Plugin id) {
            return id.getProvider();
        }

        @Override
        String getDebugDescription(IMarker marker) throws CoreException {
            return "plugin id: " + marker.getAttribute("DETECTOR_PLUGIN_ID");
        }
    }),
    Project(true, new MarkerMapper<IProject>(){

        @Override
        IProject getIdentifier(IMarker marker) {
            return marker.getResource().getProject();
        }

        @Override
        String getShortDescription(IProject id) {
            return id.getName();
        }

        @Override
        String getDebugDescription(IMarker marker) {
            return "project of resource: " + marker.getResource();
        }
    }),
    Package(true, new MarkerMapper<IPackageFragment>(){

        @Override
        IPackageFragment getIdentifier(IMarker marker) {
            IJavaElement javaElement = MarkerUtil.findJavaElementForMarker(marker);
            if (javaElement == null) {
                javaElement = JavaCore.create((IResource)marker.getResource());
            }
            if (javaElement != null) {
                return (IPackageFragment)javaElement.getAncestor(4);
            }
            return null;
        }

        @Override
        String getShortDescription(IPackageFragment id) {
            String name = id.getElementName();
            if (name == null || name.length() == 0) {
                name = "default package";
            }
            return name;
        }

        @Override
        String getDebugDescription(IMarker marker) throws CoreException {
            return "package of element with unique Java id: " + marker.getAttribute("UNIQUE_JAVA_ID");
        }
    }),
    Class(true, new MarkerMapper<IJavaElement>(){

        @Override
        IJavaElement getIdentifier(IMarker marker) {
            IJavaElement javaElement = MarkerUtil.findJavaElementForMarker(marker);
            if (javaElement != null) {
                return javaElement;
            }
            return JavaCore.create((IResource)marker.getResource());
        }

        @Override
        String getShortDescription(IJavaElement id) {
            return id.getElementName();
        }

        @Override
        String getDebugDescription(IMarker marker) throws CoreException {
            return "class of element with unique Java id: " + marker.getAttribute("UNIQUE_JAVA_ID");
        }
    }),
    Confidence(true, new MarkerMapper<FindBugsMarker.MarkerConfidence>(){

        @Override
        FindBugsMarker.MarkerConfidence getIdentifier(IMarker marker) {
            return MarkerUtil.findConfidenceForMarker(marker);
        }

        @Override
        String getShortDescription(FindBugsMarker.MarkerConfidence id) {
            return id.name() + " confidence";
        }

        @Override
        String getDebugDescription(IMarker marker) throws CoreException {
            return "confidence: " + marker.getAttribute("CONFIDENCE");
        }
    }),
    BugRank(true, new MarkerMapper<FindBugsMarker.MarkerRank>(){

        @Override
        FindBugsMarker.MarkerRank getIdentifier(IMarker marker) {
            return FindBugsMarker.MarkerRank.getRank(MarkerUtil.findBugRankForMarker(marker));
        }

        @Override
        String getShortDescription(FindBugsMarker.MarkerRank id) {
            return id.toString();
        }

        @Override
        String getDebugDescription(IMarker marker) throws CoreException {
            return "rank: " + marker.getAttribute("RANK");
        }
    }),
    Category(true, new MarkerMapper<BugCategory>(){

        @Override
        BugCategory getIdentifier(IMarker marker) {
            BugPattern bugPattern = MarkerUtil.findBugPatternForMarker(marker);
            if (bugPattern == null) {
                BugInstance bug = MarkerUtil.findBugInstanceForMarker(marker);
                if (bug == null) {
                    return null;
                }
                return DetectorFactoryCollection.instance().getBugCategory(bug.getBugPattern().getCategory());
            }
            return DetectorFactoryCollection.instance().getBugCategory(bugPattern.getCategory());
        }

        @Override
        String getShortDescription(BugCategory id) {
            return id.getShortDescription();
        }

        @Override
        String getDebugDescription(IMarker marker) throws CoreException {
            return "category of: " + marker.getAttribute("FINDBUGS_UNIQUE_ID") + "/" + marker.getAttribute("BUGTYPE");
        }
    }),
    PatternType(true, new MarkerMapper<BugCode>(){

        @Override
        BugCode getIdentifier(IMarker marker) {
            BugCode code = MarkerUtil.findBugCodeForMarker(marker);
            if (code == null) {
                BugInstance bug = MarkerUtil.findBugInstanceForMarker(marker);
                if (bug == null) {
                    return null;
                }
                return DetectorFactoryCollection.instance().getBugCode(bug.getAbbrev());
            }
            return code;
        }

        @Override
        String getShortDescription(BugCode id) {
            return id.getDescription();
        }

        @Override
        String getDebugDescription(IMarker marker) throws CoreException {
            return "pattern type: " + marker.getAttribute("PATTERNTYPE");
        }
    }),
    Pattern(true, new MarkerMapper<BugPattern>(){

        @Override
        BugPattern getIdentifier(IMarker marker) {
            return MarkerUtil.findBugPatternForMarker(marker);
        }

        @Override
        String getShortDescription(BugPattern id) {
            return id.getShortDescription();
        }

        @Override
        String getDebugDescription(IMarker marker) throws CoreException {
            return "pattern: " + marker.getAttribute("BUGTYPE");
        }
    }),
    Marker(false, MarkerMapper.NO_MAPPING),
    Undefined(false, MarkerMapper.NO_MAPPING);

    private final boolean visible;
    private final MarkerMapper<?> mapper;

    private GroupType(boolean visible, MarkerMapper<?> mapper) {
        this.visible = visible;
        this.mapper = mapper;
        if (mapper != MarkerMapper.NO_MAPPING) {
            mapper.setType(this);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    MarkerMapper<?> getMapper() {
        return this.mapper;
    }

    public static List<GroupType> getVisible() {
        GroupType[] values;
        ArrayList<GroupType> visible = new ArrayList<GroupType>();
        for (GroupType type : values = GroupType.values()) {
            if (!type.isVisible()) continue;
            visible.add(type);
        }
        return visible;
    }

    public static GroupType getType(Object element) {
        if (element instanceof BugGroup) {
            return ((BugGroup)element).getType();
        }
        if (element instanceof IMarker) {
            return Marker;
        }
        if (element instanceof IProject) {
            return Project;
        }
        if (element instanceof IWorkingSet) {
            return WorkingSet;
        }
        if (element instanceof IWorkspaceRoot) {
            return Workspace;
        }
        if (element instanceof IPackageFragment) {
            return Package;
        }
        if (element instanceof IJavaElement) {
            return Class;
        }
        if (element instanceof BugCode) {
            return PatternType;
        }
        if (element instanceof BugPattern) {
            return Pattern;
        }
        if (element instanceof BugCategory) {
            return Category;
        }
        if (element instanceof FindBugsMarker.MarkerConfidence) {
            return Confidence;
        }
        if (element instanceof FindBugsMarker.MarkerRank) {
            return BugRank;
        }
        if (element instanceof String) {
            GroupType[] values;
            for (GroupType type : values = GroupType.values()) {
                if (!type.toString().equals(element)) continue;
                return type;
            }
            if ("Priority".equals(element)) {
                return Confidence;
            }
        }
        return Undefined;
    }
}

