/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.view.explorer.BugGroup;
import java.text.Collator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class BugPrioritySorter
extends ViewerSorter {
    public BugPrioritySorter() {
    }

    public BugPrioritySorter(Collator collator) {
        super(collator);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (e1 instanceof IMarker && e2 instanceof IMarker) {
            return BugPrioritySorter.compareMarkers((IMarker)e1, (IMarker)e2);
        }
        if (e1 instanceof BugGroup && e2 instanceof BugGroup) {
            return BugPrioritySorter.compareGroups((BugGroup)e1, (BugGroup)e2);
        }
        return super.compare(viewer, e1, e2);
    }

    public int category(Object element) {
        if (element instanceof IMarker) {
            return 1;
        }
        if (element instanceof BugGroup) {
            return 5;
        }
        return super.category(element);
    }

    static int compareGroups(BugGroup m1, BugGroup m2) {
        int result = m1.compareTo(m2);
        if (result == 0) {
            return m1.getShortDescription().compareToIgnoreCase(m2.getShortDescription());
        }
        return result;
    }

    static int compareMarkers(IMarker m1, IMarker m2) {
        int prio2;
        int rank2;
        if (m1 == null || m2 == null || !m1.exists() || !m2.exists()) {
            return 0;
        }
        int rank1 = MarkerUtil.findBugRankForMarker(m1);
        int result = rank1 - (rank2 = MarkerUtil.findBugRankForMarker(m2));
        if (result != 0) {
            return result;
        }
        int prio1 = MarkerUtil.findConfidenceForMarker(m1).ordinal();
        result = prio1 - (prio2 = MarkerUtil.findConfidenceForMarker(m2).ordinal());
        if (result != 0) {
            return result;
        }
        String a1 = m1.getAttribute("message", "");
        String a2 = m2.getAttribute("message", "");
        return a1.compareToIgnoreCase(a2);
    }
}

