/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.view.AbstractFindbugsView;
import de.tobject.findbugs.view.MarkerSelectionListener;
import de.tobject.findbugs.view.SigninStatusBox;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.cloud.Cloud;
import java.util.Calendar;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.CheckForNull;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;

public class UserAnnotationsView
extends AbstractFindbugsView {
    private String userAnnotation = "";
    private String firstVersionText = "";
    private String cloudText = "";
    @CheckForNull
    private MarkerUtil.BugCollectionAndInstance theBug;
    private Text userAnnotationTextField;
    private Text cloudTextField;
    private Label firstVersionLabel;
    private Combo designationComboBox;
    private SigninStatusBox signinStatusBox;
    private ISelectionListener selectionListener;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private Cloud lastCloud;
    private final Cloud.CloudListener cloudListener = new Cloud.CloudListener(){

        @Override
        public void statusUpdated() {
        }

        @Override
        public void issueUpdated(BugInstance bug) {
            MarkerUtil.BugCollectionAndInstance bug2 = UserAnnotationsView.this.theBug;
            if (bug2 != null && bug.equals(bug2.getBugInstance())) {
                UserAnnotationsView.this.updateBugInfo();
            }
        }

        @Override
        public void taskStarted(Cloud.CloudTask task) {
        }
    };
    private IWorkbenchPart contributingPart;

    @Override
    public Composite createRootControl(Composite parent) {
        Composite main = new Composite(parent, 512);
        main.setLayout((Layout)new GridLayout(2, false));
        this.designationComboBox = new Combo(main, 16396);
        this.designationComboBox.setToolTipText("My bug designation");
        this.designationComboBox.setLayoutData((Object)new GridData());
        for (String s : I18N.instance().getUserDesignationKeys(true)) {
            this.designationComboBox.add(I18N.instance().getUserDesignation(s));
        }
        this.designationComboBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                final MarkerUtil.BugCollectionAndInstance bug = UserAnnotationsView.this.theBug;
                if (bug == null) {
                    return;
                }
                final BugInstance bugInstance = bug.getBugInstance();
                if (bugInstance == null) {
                    return;
                }
                final int selectionIndex = UserAnnotationsView.this.designationComboBox.getSelectionIndex();
                UserAnnotationsView.this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        bugInstance.setUserDesignationKeyIndex(selectionIndex, bug.getBugCollection());
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.designationComboBox.setEnabled(false);
        this.signinStatusBox = new SigninStatusBox(main, 0);
        this.signinStatusBox.setLayoutData(new GridData(2, 2, false, false));
        this.firstVersionLabel = new Label(main, 16384);
        this.firstVersionLabel.setToolTipText("The earliest version in which the bug was present");
        this.firstVersionLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        this.userAnnotationTextField = new Text(main, 18496);
        this.userAnnotationTextField.setToolTipText("My bug comments");
        this.userAnnotationTextField.setEnabled(false);
        GridData uatfData = new GridData(1808);
        uatfData.horizontalSpan = 2;
        this.userAnnotationTextField.setLayoutData((Object)uatfData);
        this.userAnnotationTextField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                final MarkerUtil.BugCollectionAndInstance bug = UserAnnotationsView.this.theBug;
                if (bug != null && bug.getBugInstance() != null) {
                    final String txt = UserAnnotationsView.this.userAnnotationTextField.getText();
                    UserAnnotationsView.this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            bug.getBugInstance().setAnnotationText(txt, bug.getBugCollection());
                        }
                    });
                }
            }
        });
        Label cloudLabel = new Label(main, 16384);
        cloudLabel.setText("Cloud info:");
        GridData lData = new GridData(16384, 128, true, false);
        lData.horizontalSpan = 2;
        cloudLabel.setLayoutData((Object)lData);
        this.cloudTextField = new Text(main, 18504);
        this.cloudTextField.setToolTipText("This information about this issue was retrieved from the cloud");
        GridData ctfData = new GridData(1808);
        ctfData.horizontalSpan = 2;
        this.cloudTextField.setLayoutData((Object)ctfData);
        ISelectionService theService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionListener = new MarkerSelectionListener(this);
        theService.addSelectionListener(this.selectionListener);
        return main;
    }

    @Override
    public void dispose() {
        if (this.selectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
        if (this.lastCloud != null) {
            this.lastCloud.removeListener(this.cloudListener);
        }
        this.signinStatusBox.dispose();
        this.contributingPart = null;
        super.dispose();
    }

    private void updateDisplay() {
        this.firstVersionLabel.setSize(this.firstVersionLabel.computeSize(-1, -1));
    }

    public void setContent(MarkerUtil.BugCollectionAndInstance bci) {
        this.theBug = bci;
        this.updateBugInfo();
    }

    private void updateBugInfo() {
        MarkerUtil.BugCollectionAndInstance theBug2 = this.theBug;
        if (theBug2 == null) {
            this.setCloud(null);
            this.userAnnotationTextField.setEnabled(false);
            this.designationComboBox.setEnabled(false);
            this.userAnnotation = "";
            this.firstVersionText = "";
            this.cloudText = "";
        } else {
            BugInstance bug = theBug2.getBugInstance();
            long timestamp = theBug2.getBugCollection().getAppVersionFromSequenceNumber(bug.getFirstVersion()).getTimestamp();
            String firstVersion = "First seen: " + UserAnnotationsView.convertTimestamp(timestamp);
            Cloud cloud = theBug2.getBugCollection().getCloud();
            this.setCloud(cloud);
            if (cloud.canStoreUserAnnotation(bug)) {
                String userDesignation = cloud.getUserEvaluation(bug);
                this.userAnnotation = userDesignation == null ? "" : userDesignation.trim();
                this.firstVersionText = firstVersion.trim();
                this.cloudText = cloud.getCloudReport(bug);
                this.userAnnotationTextField.setEnabled(true);
                this.designationComboBox.setEnabled(true);
                int comboIndex = bug.getUserDesignationKeyIndex();
                if (comboIndex == -1) {
                    FindbugsPlugin.getDefault().logError("Cannot find user designation");
                } else {
                    this.designationComboBox.select(comboIndex);
                }
            } else {
                this.userAnnotationTextField.setEnabled(false);
                this.designationComboBox.setEnabled(false);
                this.userAnnotation = "";
                this.firstVersionText = "";
                this.cloudText = "";
            }
        }
        this.userAnnotationTextField.setText(this.userAnnotation);
        this.firstVersionLabel.setText(this.firstVersionText);
        this.cloudTextField.setText(this.cloudText);
        this.updateDisplay();
    }

    private void setCloud(Cloud cloud) {
        this.signinStatusBox.setCloud(cloud);
        if (cloud != this.lastCloud) {
            if (this.lastCloud != null) {
                this.lastCloud.removeListener(this.cloudListener);
            }
            if (cloud != null) {
                cloud.addListener(this.cloudListener);
            }
            this.lastCloud = cloud;
        }
    }

    private void showInView(IMarker marker) {
        MarkerUtil.BugCollectionAndInstance bci = marker == null ? null : MarkerUtil.findBugCollectionAndInstanceForMarker(marker);
        this.setContent(bci);
    }

    @Override
    public void markerSelected(IWorkbenchPart thePart, IMarker newMarker) {
        this.contributingPart = thePart;
        this.showInView(newMarker);
        if (!this.isVisible()) {
            this.activate();
        }
    }

    private static String convertTimestamp(long timestamp) {
        if (timestamp == -2L) {
            return "ERROR - Timestamp not found";
        }
        if (timestamp == -1L) {
            return "First version analyzed";
        }
        Calendar theCalendar = Calendar.getInstance();
        theCalendar.setTimeInMillis(System.currentTimeMillis());
        theCalendar.set(theCalendar.get(1), theCalendar.get(2), theCalendar.get(5), 0, 0, 0);
        long beginningOfToday = theCalendar.getTimeInMillis();
        long beginningOfYesterday = beginningOfToday - 86400000L;
        theCalendar.setTimeInMillis(timestamp);
        String timeString = theCalendar.getTime().toString();
        if (timestamp >= beginningOfToday) {
            return "Today " + timeString.substring(timeString.indexOf(":") - 2, timeString.indexOf(":") + 3);
        }
        if (timestamp >= beginningOfYesterday) {
            return "Yesterday " + timeString.substring(timeString.indexOf(":") - 2, timeString.indexOf(":") + 3);
        }
        return timeString.substring(0, timeString.indexOf(":") + 3);
    }

    @Override
    public void setFocus() {
        this.designationComboBox.setFocus();
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
    }

    public IWorkbenchPart getContributingPart() {
        return this.contributingPart;
    }
}

