/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.themes.ITheme;

public class FindBugsConsole
extends MessageConsole
implements IPropertyChangeListener {
    private static final String CONSOLE_FONT = "findBugsEclipsePlugin.consoleFont";
    static FindBugsConsole console;
    boolean disposed;

    private FindBugsConsole(String name, ImageDescriptor imageDescriptor, boolean autoLifecycle) {
        super(name, imageDescriptor, autoLifecycle);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (CONSOLE_FONT.equals(event.getProperty())) {
            this.setConsoleFont();
        }
    }

    protected void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
            theme.removePropertyChangeListener((IPropertyChangeListener)this);
            super.dispose();
        }
    }

    private void setConsoleFont() {
        if (Display.getCurrent() == null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FindBugsConsole.this.setConsoleFont();
                }
            });
        } else {
            ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
            Font font = theme.getFontRegistry().get(CONSOLE_FONT);
            console.setFont(font);
        }
    }

    public static FindBugsConsole showConsole() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        boolean exists = false;
        if (console != null) {
            IConsole[] existing = manager.getConsoles();
            for (int i = 0; i < existing.length; ++i) {
                if (console != existing[i]) continue;
                exists = true;
            }
        } else {
            console = new FindBugsConsole("FindBugs", null, true);
        }
        if (!exists) {
            manager.addConsoles(new IConsole[]{console});
        }
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        theme.addPropertyChangeListener((IPropertyChangeListener)console);
        console.setConsoleFont();
        manager.showConsoleView((IConsole)console);
        return console;
    }

    public static MessageConsole getConsole() {
        return console;
    }

    public static class FindBugsConsolePageParticipant
    implements IConsolePageParticipant {
        private RemoveAction removeAction;

        public void activated() {
        }

        public void deactivated() {
        }

        public void dispose() {
            this.removeAction = null;
        }

        public void init(IPageBookViewPage page, IConsole console1) {
            this.removeAction = new RemoveAction();
            IActionBars bars = page.getSite().getActionBars();
            bars.getToolBarManager().appendToGroup("launchGroup", (IAction)this.removeAction);
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    public static class FindBugsConsoleFactory
    implements IConsoleFactory {
        public void openConsole() {
            FindBugsConsole.showConsole();
        }
    }

    private static class RemoveAction
    extends Action {
        public RemoveAction() {
            super("Close FindBugs console", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        }

        public void run() {
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            if (console != null) {
                manager.removeConsoles(new IConsole[]{console});
                console = null;
            }
        }
    }
}

