/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.marker.FindBugsMarker;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.util.EditorUtil;
import de.tobject.findbugs.util.Util;
import de.tobject.findbugs.view.AbstractFindbugsView;
import de.tobject.findbugs.view.MarkerSelectionListener;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugRankCategory;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.TypeAnnotation;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.xml.OutputStreamXMLOutput;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.ide.IDE;

public class BugInfoView
extends AbstractFindbugsView {
    private Browser browser;
    private Composite rootComposite;
    private BugPattern pattern;
    private String oldText;
    private BugInstance bug;
    private String browserId;
    private volatile boolean allowUrlChange;
    private List annotationList;
    private IMarker marker;
    private IFile file;
    private IJavaElement javaElt;
    private ISelectionListener selectionListener;
    private IWorkbenchPart contributingPart;
    private volatile boolean showingAnnotation;
    private final IExpansionListener expansionListener = new IExpansionListener(){

        public void expansionStateChanging(ExpansionEvent e) {
        }

        public void expansionStateChanged(ExpansionEvent e) {
            BugInfoView.this.rootComposite.layout(true, true);
            BugInfoView.this.rootComposite.redraw();
        }
    };

    @Override
    public Composite createRootControl(Composite parent) {
        this.createRootComposite(parent);
        this.createAnnotationList(this.rootComposite);
        this.createBrowser(this.rootComposite);
        ISelectionService theService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionListener = new MarkerSelectionListener(this);
        theService.addSelectionListener(this.selectionListener);
        return this.rootComposite;
    }

    private void createRootComposite(Composite parent) {
        this.rootComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginLeft = -5;
        layout.marginTop = -5;
        layout.marginBottom = -5;
        layout.marginRight = -5;
        this.rootComposite.setLayout((Layout)layout);
        this.rootComposite.setSize(-1, -1);
    }

    private void createBrowser(Composite parent) {
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        try {
            this.browser = new Browser(parent, 262144);
            this.browser.setLayoutData((Object)data);
            this.browser.setBackground(parent.getBackground());
            this.browser.addOpenWindowListener(new OpenWindowListener(){

                public void open(WindowEvent event) {
                    event.required = true;
                }
            });
            this.browser.addLocationListener(new LocationListener(){

                public void changed(LocationEvent event) {
                }

                public void changing(LocationEvent event) {
                    if (BugInfoView.this.allowUrlChange || "about:blank".equals(event.location)) {
                        return;
                    }
                    event.doit = false;
                    BugInfoView.this.openBrowserInEditor(event);
                }
            });
        }
        catch (SWTError e) {
            FindbugsPlugin plugin = FindbugsPlugin.getDefault();
            plugin.logException(new RuntimeException(e.getMessage(), e), "Could not create org.eclipse.swt.widgets.Composite.Browser");
        }
    }

    private void createAnnotationList(Composite parent) {
        ExpandableComposite exp = new ExpandableComposite(parent, 0, 100);
        exp.addExpansionListener(this.expansionListener);
        exp.setText("Navigation");
        this.annotationList = new List((Composite)exp, 2816);
        GridData data = new GridData(768);
        exp.setLayoutData((Object)data);
        exp.setClient((Control)this.annotationList);
        exp.setBackground(parent.getBackground());
        exp.setFont(JFaceResources.getDialogFont());
        this.annotationList.setFont(JFaceResources.getDialogFont());
        this.annotationList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evnt) {
                BugInfoView.this.selectInEditor(false);
            }
        });
        this.annotationList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                BugInfoView.this.selectInEditor(true);
            }
        });
        Menu menu = new Menu((Control)this.annotationList);
        final MenuItem item = new MenuItem(menu, 8);
        item.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"));
        item.setText("Copy To Clipboard");
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                BugInfoView.this.copyInfoToClipboard();
            }
        });
        menu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                item.setEnabled(BugInfoView.this.bug != null);
            }
        });
        this.annotationList.setToolTipText("Click on lines or methods to go to them");
        this.annotationList.setMenu(menu);
        this.annotationList.pack(true);
    }

    private void refreshBrowser() {
        String html = null;
        if (this.browser != null && !this.browser.isDisposed() && !(html = this.getHtml()).equals(this.oldText)) {
            this.allowUrlChange = true;
            this.browser.setText(html);
            this.allowUrlChange = false;
        }
        this.oldText = html;
    }

    private String getHtml() {
        if (this.pattern == null) {
            return "";
        }
        boolean hasBug = this.bug != null;
        StringBuilder text = new StringBuilder();
        if (!hasBug) {
            text.append("<b>Pattern</b>: ");
            text.append(this.pattern.getShortDescription());
        } else {
            text.append(this.pattern.getDetailText());
        }
        if (!hasBug) {
            return text.toString();
        }
        if (text.lastIndexOf("</p>") == -1 || text.lastIndexOf("<br>") == -1) {
            text.append("\n<p>");
        }
        text.append(this.getBugDetails());
        text.append("<br>");
        text.append(this.getPatternDetails());
        this.addXmlOutput(text);
        this.addDetectorInfo(text);
        String html = "<b>Bug</b>: " + BugInfoView.toSafeHtml(this.bug.getMessageWithoutPrefix()) + "<br>\n" + text.toString();
        return html;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addXmlOutput(StringBuilder text) {
        StringWriter stringWriter = new StringWriter();
        OutputStreamXMLOutput xmlOutput = new OutputStreamXMLOutput(stringWriter);
        try {
            this.bug.writeXML(xmlOutput);
        }
        catch (IOException e) {
        }
        finally {
            try {
                xmlOutput.finish();
            }
            catch (IOException e) {}
        }
        text.append("<hr size=\"1\" /><p><b>XML output:</b>");
        text.append("<pre>");
        text.append(BugInfoView.toSafeHtml(stringWriter.toString()));
        text.append("</pre></p><hr size=\"1\" />");
    }

    private String getBugDetails() {
        StringBuilder sb = new StringBuilder();
        int rank = 0;
        FindBugsMarker.MarkerConfidence confidence = FindBugsMarker.MarkerConfidence.Ignore;
        if (this.bug != null) {
            confidence = FindBugsMarker.MarkerConfidence.getConfidence(this.bug.getPriority());
            rank = this.bug.getBugRank();
        } else if (this.marker != null) {
            confidence = MarkerUtil.findConfidenceForMarker(this.marker);
            rank = MarkerUtil.findBugRankForMarker(this.marker);
        }
        sb.append("\n<b>Rank</b>: ");
        sb.append((Object)BugRankCategory.getRank(rank));
        sb.append(" (").append(rank).append(")");
        sb.append(", <b>confidence</b>: ").append((Object)confidence);
        return sb.toString();
    }

    private String getPatternDetails() {
        if (this.pattern == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<b>Pattern</b>: ");
        sb.append(this.pattern.getType());
        sb.append("\n<br><b>Type</b>: ").append(this.pattern.getAbbrev()).append(", <b>Category</b>: ");
        sb.append(this.pattern.getCategory());
        BugCategory category = DetectorFactoryCollection.instance().getBugCategory(this.pattern.getCategory());
        if (category != null) {
            sb.append(" (");
            sb.append(category.getShortDescription());
            sb.append(")");
        }
        return sb.toString();
    }

    private void addDetectorInfo(StringBuilder text) {
        Plugin plugin;
        DetectorFactory factory = this.bug.getDetectorFactory();
        if (factory != null && !(plugin = factory.getPlugin()).isCorePlugin()) {
            text.append("<p><small><i>Reported by: ").append(factory.getFullName());
            text.append("<br>Contributed by plugin: ").append(plugin.getPluginId());
            text.append("<br>Provider: ").append(plugin.getProvider());
            String website = plugin.getWebsite();
            if (website != null && website.length() > 0) {
                text.append(" (<a href=\"").append(website).append("\">");
                text.append(website).append("</a>)");
            }
            text.append("</i></small>");
        }
    }

    private static String toSafeHtml(String s) {
        if (s.indexOf(">") >= 0) {
            s = s.replace(">", "&gt;");
        }
        if (s.indexOf("<") >= 0) {
            s = s.replace("<", "&lt;");
        }
        return s;
    }

    @Override
    public void dispose() {
        if (this.selectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
        if (this.rootComposite != null && !this.rootComposite.isDisposed()) {
            this.rootComposite.dispose();
        }
        super.dispose();
    }

    private void openBrowserInEditor(LocationEvent event) {
        URL url;
        try {
            url = new URL(event.location);
        }
        catch (MalformedURLException ignored) {
            return;
        }
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser newBrowser = support.createBrowser(this.browserId);
            this.browserId = newBrowser.getId();
            newBrowser.openURL(url);
            return;
        }
        catch (PartInitException e) {
            FindbugsPlugin.getDefault().logException(e, "Can't open external browser");
            return;
        }
    }

    private void refreshAnnotations() {
        this.annotationList.removeAll();
        if (this.bug != null) {
            this.annotationList.add(this.bug.getMessageWithoutPrefix());
            for (BugAnnotation ba : this.bug.getAnnotationsForMessage(false)) {
                this.annotationList.add(ba.toString());
            }
        }
        this.annotationList.pack(true);
    }

    private IJavaProject getIProject() {
        if (this.javaElt != null) {
            return this.javaElt.getJavaProject();
        }
        if (this.file != null) {
            IProject p = this.file.getProject();
            try {
                if (p.hasNature("org.eclipse.jdt.core.javanature")) {
                    return JavaCore.create((IProject)p);
                }
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not open Java project for " + this.file);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void showAnnotation(IEditorPart activeEditor) {
        block25: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            if (this.showingAnnotation) {
                                FindbugsPlugin.getDefault().logInfo("Recursive showAnnotation");
                            }
                            this.showingAnnotation = true;
                            index = this.annotationList.getSelectionIndex() - 1;
                            if (index < 0) ** GOTO lbl85
                            theAnnotation = this.bug.getAnnotationsForMessage(false).get(index);
                            if (!(theAnnotation instanceof SourceLineAnnotation)) break block21;
                            sla = (SourceLineAnnotation)theAnnotation;
                            line = sla.getStartLine();
                            EditorUtil.goToLine(activeEditor, line);
                            this.showingAnnotation = false;
                            return;
                        }
                        if (!(theAnnotation instanceof MethodAnnotation)) break block22;
                        ma = (MethodAnnotation)theAnnotation;
                        className = ma.getClassName();
                        project = this.getIProject();
                        type = project.findType(className);
                        if (type != null) {
                            m = BugInfoView.getIMethod(type, ma);
                            if (m != null) {
                                JavaUI.openInEditor((IJavaElement)m, (boolean)true, (boolean)true);
                            } else {
                                activeEditor = JavaUI.openInEditor((IJavaElement)type, (boolean)true, (boolean)true);
                                sla = ma.getSourceLines();
                                EditorUtil.goToLine(activeEditor, sla.getStartLine());
                            }
                            this.showingAnnotation = false;
                            return;
                        }
                    }
                    if (!(theAnnotation instanceof FieldAnnotation)) break block23;
                    fa = (FieldAnnotation)theAnnotation;
                    className = fa.getClassName();
                    project = this.getIProject();
                    type = project.findType(className);
                    if (type != null) {
                        f = type.getField(fa.getFieldName());
                        if (f != null) {
                            JavaUI.openInEditor((IJavaElement)f, (boolean)true, (boolean)true);
                        } else {
                            activeEditor = JavaUI.openInEditor((IJavaElement)type, (boolean)true, (boolean)true);
                            sla = fa.getSourceLines();
                            EditorUtil.goToLine(activeEditor, sla.getStartLine());
                        }
                        this.showingAnnotation = false;
                        return;
                    }
                }
                if (!(theAnnotation instanceof TypeAnnotation)) break block24;
                fa = (TypeAnnotation)theAnnotation;
                className = ClassName.fromFieldSignature(fa.getTypeDescriptor());
                if (className != null && (type = (project = this.getIProject()).findType(ClassName.toDottedClassName(className))) != null) {
                    JavaUI.openInEditor((IJavaElement)type, (boolean)true, (boolean)true);
                    this.showingAnnotation = false;
                    return;
                }
            }
            if (!(theAnnotation instanceof ClassAnnotation)) break block25;
            fa = (ClassAnnotation)theAnnotation;
            className = fa.getClassName();
            project = this.getIProject();
            type = project.findType(className);
            if (type != null) {
                JavaUI.openInEditor((IJavaElement)type, (boolean)true, (boolean)true);
                this.showingAnnotation = false;
                return;
            }
        }
        try {
            block26: {
                break block26;
                {
                    catch (JavaModelException e) {
                        FindbugsPlugin.getDefault().logException(e, "Could not open editor for " + theAnnotation);
                        break block26;
                    }
                    catch (PartInitException e) {
                        FindbugsPlugin.getDefault().logException(e, "Could not open editor for " + theAnnotation);
                    }
                }
            }
            if (this.marker != null) {
                line = this.marker.getAttribute("lineNumber", 1);
                EditorUtil.goToLine(activeEditor, line);
            }
        }
        catch (Throwable var10_29) {
            throw var10_29;
        }
        finally {
            this.showingAnnotation = false;
        }
    }

    private static String stripFirstAndLast(String s) {
        return s.substring(1, s.length() - 1);
    }

    private static IMethod getIMethod(IType type, MethodAnnotation mma) throws JavaModelException {
        String name = mma.getMethodName();
        SignatureParser parser = new SignatureParser(mma.getMethodSignature());
        String[] arguments = parser.getArguments();
        block0: for (IMethod m : type.getMethods()) {
            String[] mArguments;
            if (!m.getElementName().equals(name) || arguments.length != (mArguments = m.getParameterTypes()).length) continue;
            for (int i = 0; i < arguments.length; ++i) {
                String a = arguments[i];
                String ma = mArguments[i];
                while (a.startsWith("[") && ma.startsWith("[")) {
                    a = a.substring(1);
                    ma = ma.substring(1);
                }
                if (ma.startsWith("Q")) {
                    ma = BugInfoView.stripFirstAndLast(ma);
                    ClassDescriptor ad = DescriptorFactory.createClassDescriptorFromFieldSignature(a);
                    if (ad == null) continue block0;
                    a = ad.getSimpleName();
                }
                if (!ma.equals(a)) continue block0;
            }
            return m;
        }
        return null;
    }

    private void copyInfoToClipboard() {
        if (this.bug == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(BugInfoView.removeHtmlMarkup(this.getHtml()));
        sb.append("\n\n");
        for (BugAnnotation ba : this.bug.getAnnotationsForMessage(true)) {
            sb.append(ba.toString()).append("\n");
        }
        sb.append("\n");
        if (this.file != null) {
            sb.append("File: ").append(this.file.getLocation()).append("\n");
        }
        Util.copyToClipboard(sb.toString());
    }

    private static String removeHtmlMarkup(String html) {
        html = html.replaceAll("\\s*[\\n]+\\s*", " ");
        html = html.replaceAll("<[a-zA-Z]+>", "\n");
        html = html.replaceAll("</[a-zA-Z]+>", "");
        html = html.replaceAll("&nbsp;", "");
        html = html.replaceAll("&lt;", "<");
        html = html.replaceAll("&gt;", ">");
        html = html.replaceAll("&amp;", "&");
        return html.trim();
    }

    private void selectInEditor(boolean openEditor) {
        IEditorInput input;
        if (this.bug == null || this.file == null && this.javaElt == null) {
            return;
        }
        IWorkbenchPage page = this.contributingPart.getSite().getPage();
        IEditorPart activeEditor = page.getActiveEditor();
        IEditorInput iEditorInput = input = activeEditor != null ? activeEditor.getEditorInput() : null;
        if (openEditor && !this.matchInput(input)) {
            try {
                if (this.file != null) {
                    activeEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)this.file);
                } else if (this.javaElt != null) {
                    activeEditor = JavaUI.openInEditor((IJavaElement)this.javaElt, (boolean)true, (boolean)true);
                }
                if (activeEditor != null) {
                    input = activeEditor.getEditorInput();
                }
            }
            catch (PartInitException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not open editor for " + this.bug.getMessage());
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not open editor for " + this.bug.getMessage());
            }
        }
        if (this.matchInput(input)) {
            this.showAnnotation(activeEditor);
        }
    }

    private boolean matchInput(IEditorInput input) {
        if (this.file != null && input instanceof IFileEditorInput) {
            return this.file.equals(((IFileEditorInput)input).getFile());
        }
        if (this.javaElt != null && input != null) {
            IJavaElement parent;
            IJavaElement javaElement = JavaUI.getEditorInputJavaElement((IEditorInput)input);
            if (this.javaElt.equals(javaElement)) {
                return true;
            }
            for (parent = this.javaElt.getParent(); parent != null && !parent.equals(javaElement); parent = parent.getParent()) {
            }
            if (parent != null && parent.equals(javaElement)) {
                return true;
            }
        }
        return false;
    }

    private void refreshTitle() {
        if (this.marker != null) {
            String bugType = this.marker.getAttribute("BUGTYPE", "");
            this.pattern = DetectorFactoryCollection.instance().lookupBugPattern(bugType);
        }
        if (this.pattern == null) {
            return;
        }
        if (this.bug == null) {
            return;
        }
        if (this.file != null) {
            this.setContentDescription(this.file.getName() + ": " + this.marker.getAttribute("lineNumber", 0));
        } else {
            this.setContentDescription("");
        }
    }

    @Override
    public void markerSelected(IWorkbenchPart thePart, IMarker newMarker) {
        if (this.showingAnnotation) {
            return;
        }
        this.contributingPart = thePart;
        this.showInView(newMarker);
        if (!this.isVisible()) {
            this.activate();
        }
    }

    public IWorkbenchPart getContributingPart() {
        return this.contributingPart;
    }

    private void showInView(IMarker m) {
        this.marker = m;
        if (MarkerUtil.isFindBugsMarker(this.marker)) {
            this.bug = MarkerUtil.findBugInstanceForMarker(this.marker);
            this.file = (IFile)(this.marker.getResource() instanceof IFile ? this.marker.getResource() : null);
            this.javaElt = MarkerUtil.findJavaElementForMarker(this.marker);
            this.pattern = this.bug != null ? this.bug.getBugPattern() : null;
            this.refreshTitle();
            this.refreshAnnotations();
            this.refreshBrowser();
            this.rootComposite.layout(true, true);
        }
    }
}

