/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.util;

import edu.umd.cs.findbugs.util.Archive;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class Util {
    public static boolean isJavaFile(IResource resource) {
        if (resource == null || resource.getType() != 1) {
            return false;
        }
        String ex = resource.getFileExtension();
        return "java".equalsIgnoreCase(ex);
    }

    public static boolean isJavaArchive(IResource resource) {
        if (resource == null || resource.getType() != 1) {
            return false;
        }
        String name = resource.getName();
        return Archive.isArchiveFileName(name);
    }

    public static boolean isClassFile(IResource resource) {
        if (resource == null || resource.getType() != 1) {
            return false;
        }
        String ex = resource.getFileExtension();
        return "class".equalsIgnoreCase(ex);
    }

    public static boolean isClassFile(IJavaElement elt) {
        if (elt == null) {
            return false;
        }
        return elt instanceof IClassFile || elt instanceof ICompilationUnit;
    }

    public static boolean isJavaArtifact(IResource resource) {
        if (resource == null || resource.getType() != 1) {
            return false;
        }
        String ex = resource.getFileExtension();
        if ("java".equalsIgnoreCase(ex) || "class".equalsIgnoreCase(ex)) {
            return true;
        }
        String name = resource.getName();
        return Archive.isArchiveFileName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToClipboard(String content) {
        if (content == null) {
            return;
        }
        Clipboard cb = null;
        try {
            cb = new Clipboard(Display.getDefault());
            cb.setContents((Object[])new String[]{content}, (Transfer[])new TextTransfer[]{TextTransfer.getInstance()});
        }
        finally {
            if (cb != null) {
                cb.dispose();
            }
        }
    }

    @CheckForNull
    public static <V> V getAdapter(Class<V> adapter, Object obj) {
        if (obj == null) {
            return null;
        }
        if (adapter.isAssignableFrom(obj.getClass())) {
            return (V)obj;
        }
        if (obj instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)obj;
            return (V)adaptable.getAdapter(adapter);
        }
        return null;
    }

    public static void sortIMarkers(IMarker[] markers) {
        Arrays.sort(markers, new Comparator<IMarker>(){

            @Override
            public int compare(IMarker arg0, IMarker arg1) {
                IResource resource0 = arg0.getResource();
                IResource resource1 = arg1.getResource();
                if (resource0 != null && resource1 != null) {
                    return resource0.getName().compareTo(resource1.getName());
                }
                if (resource0 != null && resource1 == null) {
                    return 1;
                }
                if (resource0 == null && resource1 != null) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public static class StopTimer {
        TreeMap<Long, String> stopTimes = new TreeMap();

        public synchronized void newPoint(String name) {
            Long time = System.currentTimeMillis();
            if (this.stopTimes.size() == 0) {
                this.stopTimes.put(time, name);
                return;
            }
            Long lastTime = this.stopTimes.lastKey();
            if (time <= lastTime) {
                time = lastTime + 1L;
            }
            this.stopTimes.put(time, name);
        }

        public synchronized String getResults() {
            StringBuilder sb = new StringBuilder();
            Iterator<Map.Entry<Long, String>> iterator = this.stopTimes.entrySet().iterator();
            Map.Entry<Long, String> firstEntry = iterator.next();
            while (iterator.hasNext()) {
                Map.Entry<Long, String> entry = iterator.next();
                long diff = entry.getKey() - firstEntry.getKey();
                sb.append(firstEntry.getValue()).append(": ").append(diff).append(" ms\n");
                firstEntry = entry;
            }
            long overall = this.stopTimes.lastKey() - this.stopTimes.firstKey();
            sb.append("Overall: ").append(overall).append(" ms");
            return sb.toString();
        }
    }
}

