/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.reporter;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.marker.FindBugsMarker;
import de.tobject.findbugs.reporter.MarkerParameter;
import de.tobject.findbugs.reporter.MarkerSeverity;
import de.tobject.findbugs.reporter.MarkerUtil;
import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.config.ProjectFilterSettings;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.preference.IPreferenceStore;

public class MarkerReporter
implements IWorkspaceRunnable {
    private final SortedBugCollection collection;
    private final List<MarkerParameter> mpList;
    private final IProject project;

    public MarkerReporter(List<MarkerParameter> mpList, SortedBugCollection theCollection, IProject project) {
        this.mpList = mpList;
        this.collection = theCollection;
        this.project = project;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        UserPreferences userPrefs = FindbugsPlugin.getUserPreferences(this.project);
        ProjectFilterSettings filterSettings = userPrefs.getFilterSettings();
        IPreferenceStore store = FindbugsPlugin.getPluginPreferences(this.project);
        for (MarkerParameter mp : this.mpList) {
            if (mp.markerType == null || !MarkerUtil.shouldDisplayWarning(mp.bug, filterSettings)) continue;
            MarkerReporter.updateMarkerSeverity(store, mp);
            this.addMarker(mp);
        }
    }

    private static void updateMarkerSeverity(IPreferenceStore store, MarkerParameter mp) {
        String markerSeverityStr = store.getString(mp.markerType);
        mp.markerSeverity = MarkerSeverity.get((String)markerSeverityStr).value;
    }

    private void addMarker(MarkerParameter mp) throws CoreException {
        IMarker oldMarker;
        Map<String, Object> attributes = this.createMarkerAttributes(mp);
        if (attributes.isEmpty()) {
            this.collection.remove(mp.bug);
            return;
        }
        IResource markerTarget = mp.resource.getMarkerTarget();
        IMarker[] existingMarkers = markerTarget.findMarkers(mp.markerType, true, 0);
        if (existingMarkers.length > 0 && (oldMarker = MarkerReporter.findSameBug(attributes, existingMarkers)) != null) {
            oldMarker.delete();
        }
        IMarker newMarker = markerTarget.createMarker(mp.markerType);
        newMarker.setAttributes(attributes);
    }

    @CheckForNull
    private static IMarker findSameBug(Map<String, Object> attributes, IMarker[] existingMarkers) throws CoreException {
        Object bugId = attributes.get("FINDBUGS_UNIQUE_ID");
        if (bugId == null) {
            return null;
        }
        Object line = attributes.get("PRIMARY_LINE");
        for (IMarker marker : existingMarkers) {
            Object idAttribute = marker.getAttribute("FINDBUGS_UNIQUE_ID");
            if (!bugId.equals(idAttribute)) continue;
            Object primaryLine = marker.getAttribute("PRIMARY_LINE");
            if ((line != null || primaryLine != null) && (line == null || !line.equals(primaryLine))) continue;
            return marker;
        }
        return null;
    }

    @Nonnull
    private Map<String, Object> createMarkerAttributes(MarkerParameter mp) {
        HashMap<String, Object> attributes;
        block11: {
            block10: {
                DetectorFactory detectorFactory;
                attributes = new HashMap<String, Object>(23);
                attributes.put("lineNumber", mp.startLine);
                attributes.put("PRIMARY_LINE", mp.primaryLine);
                attributes.put("BUGTYPE", mp.bug.getType());
                attributes.put("PATTERNTYPE", mp.bug.getAbbrev());
                attributes.put("RANK", mp.bug.getBugRank());
                attributes.put("CONFIDENCE", FindBugsMarker.MarkerConfidence.getConfidence(mp.bug.getPriority()).name());
                long seqNum = mp.bug.getFirstVersion();
                if (seqNum == 0L) {
                    attributes.put("FIRST_VERSION", "-1");
                } else {
                    AppVersion theVersion = this.collection.getAppVersionFromSequenceNumber(seqNum);
                    if (theVersion == null) {
                        attributes.put("FIRST_VERSION", "Cannot find AppVersion: seqnum=" + seqNum + "; collection seqnum=" + this.collection.getSequenceNumber());
                    } else {
                        attributes.put("FIRST_VERSION", Long.toString(theVersion.getTimestamp()));
                    }
                }
                try {
                    attributes.put("message", MarkerReporter.getMessage(mp));
                }
                catch (RuntimeException e) {
                    FindbugsPlugin.getDefault().logException(e, "Error generating msg for " + mp.bug.getType() + ", attributes: " + attributes);
                    attributes.clear();
                    return attributes;
                }
                attributes.put("severity", mp.markerSeverity);
                String uniqueId = mp.bug.getInstanceHash();
                if (uniqueId != null) {
                    attributes.put("FINDBUGS_UNIQUE_ID", uniqueId);
                }
                if ((detectorFactory = mp.bug.getDetectorFactory()) == null) break block10;
                String pluginId = detectorFactory.getPlugin().getPluginId();
                if (pluginId == null) break block11;
                attributes.put("DETECTOR_PLUGIN_ID", pluginId);
                break block11;
            }
            BugPattern pattern = mp.bug.getBugPattern();
            Iterator<DetectorFactory> fit = DetectorFactoryCollection.instance().factoryIterator();
            while (fit.hasNext()) {
                String pluginId;
                Set<BugPattern> patterns;
                DetectorFactory df2 = fit.next();
                if (!df2.isReportingDetector() || !(patterns = df2.getReportedBugPatterns()).contains(pattern) || (pluginId = df2.getPlugin().getPluginId()) == null) continue;
                attributes.put("DETECTOR_PLUGIN_ID", pluginId);
                break;
            }
        }
        if (attributes.get("DETECTOR_PLUGIN_ID") == null) {
            attributes.clear();
            return attributes;
        }
        IJavaElement javaElt = mp.resource.getCorespondingJavaElement();
        if (javaElt != null) {
            attributes.put("UNIQUE_JAVA_ID", javaElt.getHandleIdentifier());
        }
        return attributes;
    }

    private static String getMessage(MarkerParameter mp) {
        String message = mp.bug.getMessageWithoutPrefix();
        message = message + " [" + (Object)((Object)mp.bug.getBugRankCategory()) + "(" + mp.bug.getBugRank() + "), " + (Object)((Object)FindBugsMarker.MarkerConfidence.getConfidence(mp.bug.getPriority())) + " confidence]";
        return message;
    }
}

