/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.DetectorsExtensionHelper;
import de.tobject.findbugs.builder.FindBugsWorker;
import de.tobject.findbugs.properties.DetectorValidator;
import de.tobject.findbugs.properties.FindbugsPropertyPage;
import de.tobject.findbugs.properties.IPathElement;
import de.tobject.findbugs.properties.PathElement;
import de.tobject.findbugs.properties.PathsProvider;
import de.tobject.findbugs.properties.PluginElement;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.FileDialog;

public class DetectorProvider
extends PathsProvider {
    protected DetectorProvider(CheckboxTableViewer viewer, FindbugsPropertyPage propertyPage) {
        super((TableViewer)viewer, propertyPage);
        this.setDetectorPlugins(propertyPage.getCurrentUserPreferences());
    }

    public static List<IPathElement> getPluginElements(UserPreferences userPreferences) {
        DetectorValidator validator = new DetectorValidator();
        ArrayList<IPathElement> newPaths = new ArrayList<IPathElement>();
        Map<String, Boolean> pluginPaths = userPreferences.getCustomPlugins();
        HashSet<String> disabledSystemPlugins = new HashSet<String>();
        HashSet<URI> customPlugins = new HashSet<URI>();
        Set<Map.Entry<String, Boolean>> entrySet = pluginPaths.entrySet();
        for (Map.Entry<String, Boolean> entry : entrySet) {
            String idOrPath = entry.getKey();
            if (new Path(idOrPath).segmentCount() == 1) {
                PathElement element = new PathElement((IPath)new Path(idOrPath), Status.OK_STATUS);
                element.setSystem(true);
                if (!entry.getValue().booleanValue()) {
                    element.setEnabled(false);
                    disabledSystemPlugins.add(idOrPath);
                    newPaths.add(element);
                    continue;
                }
                element.setEnabled(true);
                continue;
            }
            IPath pluginPath = FindBugsWorker.getFilterPath(idOrPath, null);
            URI uri = pluginPath.toFile().toURI();
            customPlugins.add(uri);
            DetectorValidator.ValidationStatus status = validator.validate(pluginPath.toOSString());
            PathElement element = new PathElement(pluginPath, (IStatus)status);
            Plugin plugin = Plugin.getByPluginId(status.getSummary().id);
            if (plugin != null && !uri.equals(plugin.getPluginLoader().getURI())) {
                element.setEnabled(false);
            } else {
                element.setEnabled(entry.getValue());
            }
            newPaths.add(element);
        }
        Map<URI, Plugin> allPlugins = Plugin.getAllPluginsMap();
        SortedMap<String, String> contributedDetectors = DetectorsExtensionHelper.getContributedDetectors();
        for (Map.Entry<String, String> entry : contributedDetectors.entrySet()) {
            String pluginId = entry.getKey();
            URI uri = new Path(entry.getValue()).toFile().toURI();
            Plugin plugin = allPlugins.get(uri);
            if (plugin == null || DetectorProvider.isEclipsePluginDisabled(pluginId, allPlugins)) continue;
            PluginElement element = new PluginElement(plugin, true);
            newPaths.add(0, element);
            customPlugins.add(uri);
        }
        for (Plugin plugin : allPlugins.values()) {
            PluginElement element = new PluginElement(plugin, false);
            if (customPlugins.contains(plugin.getPluginLoader().getURI())) continue;
            newPaths.add(0, element);
            if (!disabledSystemPlugins.contains(plugin.getPluginId())) continue;
            element.setEnabled(false);
        }
        return newPaths;
    }

    static boolean isEclipsePluginDisabled(String pluginId, Map<URI, Plugin> allPlugins) {
        for (Plugin plugin : allPlugins.values()) {
            if (!pluginId.equals(plugin.getPluginId())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void applyToPreferences() {
        super.applyToPreferences();
        this.propertyPage.getCurrentUserPreferences().setCustomPlugins(this.pathsToStrings());
    }

    void setDetectorPlugins(UserPreferences userPreferences) {
        this.setFilters(DetectorProvider.getPluginElements(userPreferences));
    }

    @Override
    protected IStatus validate() {
        DetectorValidator validator = new DetectorValidator();
        DetectorValidator.ValidationStatus bad = null;
        for (IPathElement path : this.paths) {
            if (path.isSystem()) continue;
            String pathStr = FindBugsWorker.getFilterPath(path.getPath(), null).toOSString();
            DetectorValidator.ValidationStatus status = validator.validate(pathStr);
            path.setStatus((IStatus)status);
            if (status.isOK() || !path.isEnabled()) continue;
            bad = status;
            path.setEnabled(false);
            break;
        }
        return bad;
    }

    @Override
    protected void configureDialog(FileDialog dialog) {
        dialog.setFilterExtensions(new String[]{"*.jar"});
        dialog.setText("Select FindBugs plugins (file must have '.jar' extension)");
    }
}

