/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.marker;

import edu.umd.cs.findbugs.BugRankCategory;
import edu.umd.cs.findbugs.annotations.Confidence;
import javax.annotation.Nonnull;

public interface FindBugsMarker {
    public static final String NAME = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker";
    public static final String TYPE_SCARIEST = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerScariest";
    public static final String TYPE_SCARY = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerScary";
    public static final String TYPE_TROUBLING = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerTroubling";
    public static final String TYPE_OF_CONCERN = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerOfConcern";
    public static final String BUG_TYPE = "BUGTYPE";
    public static final String PATTERN_TYPE = "PATTERNTYPE";
    public static final String RANK = "RANK";
    public static final String PRIO_AKA_CONFIDENCE = "CONFIDENCE";
    public static final String UNIQUE_ID = "FINDBUGS_UNIQUE_ID";
    public static final String UNIQUE_JAVA_ID = "UNIQUE_JAVA_ID";
    public static final String DETECTOR_PLUGIN_ID = "DETECTOR_PLUGIN_ID";
    public static final String PRIMARY_LINE = "PRIMARY_LINE";
    public static final String FIRST_VERSION = "FIRST_VERSION";

    public static enum MarkerConfidence {
        High(Confidence.HIGH),
        Normal(Confidence.MEDIUM),
        Low(Confidence.LOW),
        Ignore(Confidence.IGNORE);

        private final Confidence confidence;

        private MarkerConfidence(Confidence confidence) {
            this.confidence = confidence;
        }

        public String iconName() {
            return "confidence-" + this.name().toLowerCase() + ".png";
        }

        @Nonnull
        public static MarkerConfidence getConfidence(int bugPrio) {
            MarkerConfidence[] values;
            Confidence con = Confidence.getConfidence((int)bugPrio);
            for (MarkerConfidence mc : values = MarkerConfidence.values()) {
                if (mc.confidence != con) continue;
                return mc;
            }
            return Ignore;
        }

        @Nonnull
        public static MarkerConfidence getConfidence(String confidence) {
            try {
                return MarkerConfidence.valueOf(confidence);
            }
            catch (IllegalArgumentException e) {
                return Ignore;
            }
        }
    }

    public static enum MarkerRank {
        Scariest("buggy-tiny.png", BugRankCategory.SCARIEST),
        Scary("buggy-tiny-orange.png", BugRankCategory.SCARY),
        Troubling("buggy-tiny-yellow.png", BugRankCategory.TROUBLING),
        OfConcern("buggy-tiny-yellow2.png", BugRankCategory.OF_CONCERN);

        private final String icon;
        private final BugRankCategory rankCategory;

        private MarkerRank(String icon, BugRankCategory rankCategory) {
            this.icon = icon;
            this.rankCategory = rankCategory;
        }

        public static MarkerRank getRank(int bugRank) {
            MarkerRank[] values;
            for (MarkerRank mr : values = MarkerRank.values()) {
                if (bugRank > mr.rankCategory.maxRank) continue;
                return mr;
            }
            throw new IllegalArgumentException("Illegal rank " + bugRank);
        }

        public String iconName() {
            return this.icon;
        }

        public String toString() {
            if (this == OfConcern) {
                return "Of Concern";
            }
            return this.name();
        }
    }
}

