/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.classify;

import de.tobject.findbugs.reporter.MarkerUtil;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugProperty;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;

public class SeverityClassificationPulldownAction
implements IWorkbenchWindowPulldownDelegate2 {
    private Menu menu;
    private MenuItem[] severityItemList;
    private BugInstance bugInstance;
    private static final String[] SEVERITY_LABEL_LIST = new String[]{"1 (Least Severe)", "2", "3", "4", "5 (Most Severe)"};

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.menu == null) {
            this.menu = new Menu(parent);
            this.fillMenu();
        }
        return this.menu;
    }

    private void fillMenu() {
        SelectionAdapter menuItemSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                Widget w = e.widget;
                for (index = 0; index < SeverityClassificationPulldownAction.this.severityItemList.length && w != SeverityClassificationPulldownAction.this.severityItemList[index]; ++index) {
                }
                if (index < SeverityClassificationPulldownAction.this.severityItemList.length && SeverityClassificationPulldownAction.this.bugInstance != null) {
                    SeverityClassificationPulldownAction.this.bugInstance.setProperty("severity", String.valueOf(index + 1));
                }
            }
        };
        this.severityItemList = new MenuItem[SEVERITY_LABEL_LIST.length];
        for (int i = 0; i < SEVERITY_LABEL_LIST.length; ++i) {
            MenuItem menuItem = new MenuItem(this.menu, 16);
            menuItem.setText(SEVERITY_LABEL_LIST[i]);
            menuItem.addSelectionListener((SelectionListener)menuItemSelectionListener);
            this.severityItemList[i] = menuItem;
        }
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                SeverityClassificationPulldownAction.this.syncMenu();
            }
        });
    }

    private void syncMenu() {
        if (this.bugInstance != null) {
            BugProperty severityProperty = this.bugInstance.lookupProperty("severity");
            if (severityProperty != null) {
                try {
                    int severity = severityProperty.getValueAsInt();
                    if (severity > 0 && severity <= this.severityItemList.length) {
                        this.selectSeverity(severity);
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.resetMenuItems(true);
        } else {
            this.resetMenuItems(false);
        }
    }

    private void selectSeverity(int severity) {
        int index = severity - 1;
        for (int i = 0; i < this.severityItemList.length; ++i) {
            MenuItem menuItem = this.severityItemList[i];
            menuItem.setEnabled(true);
            menuItem.setSelection(i == index);
        }
    }

    private void resetMenuItems(boolean enable) {
        for (int i = 0; i < this.severityItemList.length; ++i) {
            MenuItem menuItem = this.severityItemList[i];
            menuItem.setEnabled(enable);
            menuItem.setSelection(false);
        }
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.bugInstance = null;
        IMarker marker = MarkerUtil.getMarkerFromSingleSelection(selection);
        if (marker == null) {
            return;
        }
        this.bugInstance = MarkerUtil.findBugInstanceForMarker(marker);
    }
}

