/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.builder;

import de.tobject.findbugs.builder.WorkItem;
import de.tobject.findbugs.util.ProjectUtilities;
import de.tobject.findbugs.util.Util;
import edu.umd.cs.findbugs.Project;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.ui.IAggregateWorkingSet;
import org.eclipse.ui.IWorkingSet;

public class ResourceUtils {
    private static final List<WorkItem> EMPTY = Collections.emptyList();

    private ResourceUtils() {
    }

    public static IPath getOutputLocation(IClasspathEntry classpathEntry, IPath defaultOutputLocation) {
        IPath outputLocation = classpathEntry.getOutputLocation();
        outputLocation = outputLocation != null ? ResourceUtils.relativeToAbsolute(outputLocation) : defaultOutputLocation;
        return outputLocation;
    }

    public static void addFiles(Project findBugsProject, File clzDir, Pattern pat) {
        if (clzDir.isDirectory()) {
            clzDir.listFiles(new FileCollector(pat, findBugsProject));
        }
    }

    public static IPath relativeToAbsolute(IPath relativePath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(relativePath);
        if (resource != null) {
            return resource.getLocation();
        }
        return relativePath;
    }

    public static List<WorkItem> collectIncremental(IResourceDelta delta) {
        ArrayList<WorkItem> result = new ArrayList<WorkItem>();
        ArrayList<IResourceDelta> foldersDelta = new ArrayList<IResourceDelta>();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren();
        for (int i = 0; i < affectedChildren.length; ++i) {
            IResourceDelta childDelta = affectedChildren[i];
            IResource child = childDelta.getResource();
            if (child.isDerived()) continue;
            int childType = child.getType();
            int deltaKind = childDelta.getKind();
            if (childType == 1) {
                if (deltaKind != 1 && deltaKind != 4 || !Util.isJavaFile(child)) continue;
                result.add(new WorkItem(child));
                continue;
            }
            if (childType != 2) continue;
            if (deltaKind == 1) {
                result.add(new WorkItem(child));
                continue;
            }
            if (deltaKind == 2) {
                IContainer parent = child.getParent();
                if (parent instanceof IProject) {
                    result.clear();
                    result.add(new WorkItem((IResource)parent));
                    return result;
                }
                result.add(new WorkItem((IResource)parent));
                continue;
            }
            if (deltaKind == 2) continue;
            foldersDelta.add(childDelta);
        }
        for (IResourceDelta childDelta : foldersDelta) {
            result.addAll(ResourceUtils.collectIncremental(childDelta));
        }
        return result;
    }

    public static Map<IProject, List<WorkItem>> getResourcesPerProject(IStructuredSelection structuredSelection) {
        HashMap<IProject, List<WorkItem>> projectsMap = new HashMap<IProject, List<WorkItem>>();
        for (Object element : structuredSelection) {
            WorkItem workItem = ResourceUtils.getWorkItem(element);
            if (workItem == null) {
                IWorkingSet wset = Util.getAdapter(IWorkingSet.class, element);
                if (wset != null) {
                    ResourceUtils.mapResources(wset, projectsMap);
                    continue;
                }
                ChangeSet set = Util.getAdapter(ChangeSet.class, element);
                for (WorkItem change : ResourceUtils.getResources(set)) {
                    ResourceUtils.mapResource(change, projectsMap, true);
                }
                continue;
            }
            ResourceUtils.mapResource(workItem, projectsMap, false);
        }
        return projectsMap;
    }

    private static void mapResources(IWorkingSet wset, Map<IProject, List<WorkItem>> projectsMap) {
        Set<WorkItem> set = ResourceUtils.getResources(wset);
        for (WorkItem item : set) {
            ResourceUtils.mapResource(item, projectsMap, true);
        }
    }

    public static Set<WorkItem> getResources(IWorkingSet wset) {
        HashSet<WorkItem> set = new HashSet<WorkItem>();
        boolean aggregateWorkingSet = wset.isAggregateWorkingSet();
        if (aggregateWorkingSet && wset instanceof IAggregateWorkingSet) {
            IWorkingSet[] sets;
            IAggregateWorkingSet aggr = (IAggregateWorkingSet)wset;
            for (IWorkingSet iWorkingSet : sets = aggr.getComponents()) {
                set.addAll(ResourceUtils.getResources(iWorkingSet));
            }
        } else {
            IAdaptable[] elements;
            for (IAdaptable iAdaptable : elements = wset.getElements()) {
                WorkItem item = ResourceUtils.getWorkItem(iAdaptable);
                if (item == null) continue;
                set.add(item);
            }
        }
        return set;
    }

    private static void mapResource(WorkItem resource, Map<IProject, List<WorkItem>> projectsMap, boolean checkJavaProject) {
        IProject project = resource.getProject();
        if (checkJavaProject && !ProjectUtilities.isJavaProject(project)) {
            return;
        }
        List<WorkItem> resources = projectsMap.get(project);
        if (resources == null) {
            resources = new ArrayList<WorkItem>();
            projectsMap.put(project, resources);
        }
        if (!ResourceUtils.containsParents(resources, resource)) {
            resources.add(resource);
        }
    }

    public static List<WorkItem> getResources(ChangeSet set) {
        if (set != null && !set.isEmpty()) {
            IResource[] resources = set.getResources();
            ArrayList<WorkItem> filtered = new ArrayList<WorkItem>();
            for (IResource resource : resources) {
                if (resource.getType() == 1 && !Util.isJavaArtifact(resource) || !resource.exists()) continue;
                filtered.add(new WorkItem(resource));
            }
            return filtered;
        }
        return EMPTY;
    }

    private static boolean containsParents(List<WorkItem> resources, WorkItem candidate) {
        IPath location = candidate.getPath();
        if (location == null) {
            return false;
        }
        for (WorkItem resource : resources) {
            IPath parentLoc;
            if (!resource.isDirectory() || (parentLoc = resource.getPath()) == null || !parentLoc.isPrefixOf(location)) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    public static WorkItem getWorkItem(Object element) {
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            if (resource.getType() == 1 && !Util.isJavaArtifact(resource) || !resource.isAccessible()) {
                return null;
            }
            return new WorkItem((IResource)element);
        }
        if (element instanceof IJavaElement) {
            return new WorkItem((IJavaElement)element);
        }
        if (element instanceof IAdaptable) {
            Object adapter = ((IAdaptable)element).getAdapter(IResource.class);
            if (adapter instanceof IResource) {
                IResource resource = (IResource)adapter;
                if (resource.getType() == 1 && !Util.isJavaArtifact(resource) || !resource.isAccessible()) {
                    return null;
                }
                return new WorkItem(resource);
            }
            adapter = ((IAdaptable)element).getAdapter(IPackageFragment.class);
            if (adapter instanceof IPackageFragment) {
                return new WorkItem((IJavaElement)((IPackageFragment)adapter));
            }
            adapter = ((IAdaptable)element).getAdapter(IType.class);
            if (adapter instanceof IType) {
                return new WorkItem((IJavaElement)((IType)adapter));
            }
        }
        return null;
    }

    @CheckForNull
    public static IResource getResource(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getResource();
        }
        return Util.getAdapter(IResource.class, element);
    }

    public static final class FileCollector
    implements FileFilter {
        private final Pattern pat;
        private final Project findBugsProject;

        private FileCollector(Pattern pat, Project findBugsProject) {
            this.pat = pat;
            this.findBugsProject = findBugsProject;
        }

        @Override
        public boolean accept(File file) {
            if (!file.isDirectory() && this.pat.matcher(file.getName()).matches()) {
                this.findBugsProject.addFile(file.getAbsolutePath());
            }
            return false;
        }
    }
}

