/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.actions.FindBugsAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class OpenXMLResultsAction
extends FindBugsAction {
    @Override
    public void run(IAction action) {
        if (!(this.selection instanceof IStructuredSelection) || this.selection.isEmpty()) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
        IProject project = this.getProject(structuredSelection);
        if (project == null) {
            return;
        }
        IPath filePath = FindbugsPlugin.getBugCollectionFile(project);
        if (!filePath.toFile().exists()) {
            MessageDialog.openInformation(null, (String)"Open XML results", (String)("No FindBugs analysis results available for project '" + project.getName() + "'!"));
            return;
        }
        this.openEditor(filePath.toFile());
    }

    private IEditorPart openEditor(File file) {
        String editorId = OpenXMLResultsAction.getEditorId(file);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(file.getCanonicalPath()));
            FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
            return page.openEditor((IEditorInput)input, editorId);
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not get canonical file path");
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not get canonical file path");
        }
        return null;
    }

    private static String getEditorId(File file) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName(), OpenXMLResultsAction.getContentType(file));
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IContentType getContentType(File file) {
        if (file == null) {
            return null;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor((InputStream)stream, file.getName());
            return iContentType;
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "'Open xml' operation failed");
            IContentType iContentType = null;
            return iContentType;
        }
        finally {
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, "'Open xml' operation failed");
            }
        }
    }
}

