/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.related;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.task.related.DerivedFromTaskData;
import org.eclipse.osee.ats.api.task.related.IAutoGenTaskData;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsBranchService;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.MutableInteger;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.change.ArtifactDelta;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.revision.ChangeData;
import org.eclipse.osee.framework.skynet.core.revision.ChangeManager;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBox;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeBranchDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class ShowRequirementDifferencesOperation
extends AbstractOperation {
    private final Display display;
    private final Collection<? extends IAtsTask> tasks;
    private final Set<BranchToken> savedBranches = new LinkedHashSet<BranchToken>();
    private static final BranchToken BASELINE_ROOT = BranchToken.create((String)"Use root version branch (default)");

    public ShowRequirementDifferencesOperation(Display display, Collection<? extends IAtsTask> tasks, boolean useDefault) {
        super("Show Requirement Differences", "org.eclipse.osee.ats.ide");
        this.display = display;
        this.tasks = tasks;
        if (useDefault) {
            this.savedBranches.add(BASELINE_ROOT);
        }
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        ArrayList<ArtifactDelta> artifactDeltas = new ArrayList<ArtifactDelta>();
        HashSet<String> processedReqNames = new HashSet<String>();
        HashMap<IAtsTeamWorkflow, ChangeData> changeDataMap = new HashMap<IAtsTeamWorkflow, ChangeData>();
        XResultData results = new XResultData();
        for (IAtsTask iAtsTask : this.tasks) {
            ChangeData changeData;
            IAutoGenTaskData data = AtsApiService.get().getTaskRelatedService().getAutoGenTaskData(iAtsTask);
            this.checkForNoRequirementArtifacts(data);
            if (processedReqNames.contains(String.valueOf(data.getRelatedArtName()) + data.getAddDetails())) continue;
            DerivedFromTaskData trd = AtsApiService.get().getTaskRelatedService().getDerivedTeamWf(new DerivedFromTaskData(iAtsTask));
            if (trd.getResults().isErrors()) {
                results.addRaw(trd.getResults().toString());
                continue;
            }
            IAtsTeamWorkflow sourceTeamWf = trd.getDerivedFromTeamWf();
            monitor.setTaskName("Load Change Report");
            if (changeDataMap.containsKey(sourceTeamWf)) {
                changeData = (ChangeData)changeDataMap.get(sourceTeamWf);
            } else {
                IAtsBranchService branchService = AtsApiService.get().getBranchService();
                if (branchService.isWorkingBranchInWork(sourceTeamWf)) {
                    changeData = AtsApiService.get().getBranchServiceIde().getChangeDataFromEarliestTransactionId(sourceTeamWf);
                } else {
                    IAtsVersion taskTargetedVersion = AtsApiService.get().getVersionService().getTargetedVersion((IAtsWorkItem)iAtsTask);
                    List transactions = Collections.castAll((Collection)branchService.getTransactionIds(sourceTeamWf, false));
                    MutableInteger result = new MutableInteger(0);
                    TransactionRecord transaction = this.determineTransactionId(transactions, iAtsTask.getName(), taskTargetedVersion.getName(), result);
                    monitor.setCanceled(result.getValue() != 0);
                    ShowRequirementDifferencesOperation.checkForCancelledStatus((IProgressMonitor)monitor);
                    changeData = this.createChangeDataFromTransaction(transaction);
                }
                changeDataMap.put(sourceTeamWf, changeData);
            }
            monitor.worked(this.calculateWork(0.7));
            Collection changes = null;
            changes = data.getRelatedArtId().isValid() ? changeData.getArtifactChangesById(data.getRelatedArtId()) : changeData.getArtifactChangesByName(data.getRelatedArtName(), data.getAddDetails());
            ShowRequirementDifferencesOperation.checkForCancelledStatus((IProgressMonitor)monitor);
            if (!changes.isEmpty()) {
                if (this.tasks.size() == 1) {
                    Change change = this.selectChangeToDiff(monitor, changes);
                    artifactDeltas.add(change.getDelta());
                } else {
                    for (Change change : changes) {
                        artifactDeltas.add(change.getDelta());
                    }
                }
            }
            processedReqNames.add(String.valueOf(data.getRelatedArtName()) + data.getAddDetails());
        }
        this.display.showDifferences(artifactDeltas);
        if (results.isEmpty()) {
            results.log("Opening Differences in Word");
        }
        XResultDataUI.report((XResultData)results, (String)this.getName());
        monitor.worked(this.calculateWork(0.1));
    }

    private void checkForNoRequirementArtifacts(IAutoGenTaskData data) {
        if (!data.hasRelatedArt()) {
            throw new OseeArgumentException("No related artifact found for %s", new Object[]{data.getTask().toStringWithId()});
        }
    }

    private Change selectChangeToDiff(IProgressMonitor monitor, Collection<Change> changes) throws Exception {
        Change change = null;
        if (changes.size() == 1) {
            change = changes.iterator().next();
        } else {
            HashSet<Artifact> selectableArtifacts = new HashSet<Artifact>();
            for (Change artChange : changes) {
                Artifact changeArtifact = artChange.getChangeArtifact();
                if (!changeArtifact.isValid()) continue;
                selectableArtifacts.add(changeArtifact);
            }
            Artifact selectedArtifact = null;
            selectedArtifact = selectableArtifacts.size() == 1 ? (Artifact)selectableArtifacts.iterator().next() : this.display.getArtifactSelection(monitor, selectableArtifacts);
            if (selectedArtifact == null) {
                return null;
            }
            ShowRequirementDifferencesOperation.checkForCancelledStatus((IProgressMonitor)monitor);
            for (Change artChange : changes) {
                if (!artChange.getChangeArtifact().equals((Object)selectedArtifact)) continue;
                change = artChange;
                break;
            }
        }
        return change;
    }

    private TransactionRecord findMinBaselineTransaction(Collection<TransactionRecord> records) {
        Iterator<TransactionRecord> it = records.iterator();
        TransactionRecord min = it.next();
        while (it.hasNext()) {
            TransactionRecord next = it.next();
            if (BranchManager.getBaseTransaction((BranchId)min.getBranch()).getId() <= BranchManager.getBaseTransaction((BranchId)next.getBranch()).getId()) continue;
            min = next;
        }
        return min;
    }

    private ChangeData createChangeDataFromTransaction(TransactionRecord transactionId) {
        LinkedList changes = new LinkedList();
        IOperation operation = ChangeManager.comparedToPreviousTx((TransactionToken)transactionId, changes);
        Operations.executeWorkAndCheckStatus((IOperation)operation);
        return new ChangeData(changes);
    }

    private TransactionRecord determineTransactionId(Collection<TransactionRecord> records, String taskName, String versionName, MutableInteger dialogResult) {
        TransactionRecord toReturn;
        if (records.size() == 1) {
            toReturn = records.iterator().next();
        } else {
            TransactionRecord min = this.findMinBaselineTransaction(records);
            if (this.savedBranches.contains(BASELINE_ROOT)) {
                toReturn = min;
            } else {
                LinkedHashMap<BranchToken, TransactionRecord> branchToTx = new LinkedHashMap<BranchToken, TransactionRecord>();
                for (TransactionRecord record : records) {
                    BranchToken branch = BranchManager.getBranchToken((BranchId)record.getBranch());
                    branchToTx.put(branch, record);
                }
                toReturn = this.getTransactionFromSavedOrUser(branchToTx, taskName, versionName, dialogResult);
            }
        }
        return toReturn;
    }

    private TransactionRecord getTransactionFromSavedOrUser(Map<BranchToken, TransactionRecord> branchToTx, String taskName, String versionName, MutableInteger dialogResult) {
        TransactionRecord toReturn = null;
        LinkedHashSet<BranchToken> branchesInMap = new LinkedHashSet<BranchToken>(branchToTx.keySet());
        branchesInMap.retainAll(this.savedBranches);
        if (branchesInMap.size() == 1) {
            toReturn = branchToTx.get(branchesInMap.iterator().next());
        } else if (branchesInMap.size() > 1) {
            this.savedBranches.removeAll(branchesInMap);
        }
        if (toReturn == null) {
            String title = "Multiple Commits Associated With Task";
            String message = String.format("Task named [%s]\nIs targeted for [%s].\nSelect which to diff against:", taskName, versionName);
            BranchListDialogRunnable bldr = new BranchListDialogRunnable(title, message, branchToTx.keySet());
            Displays.ensureInDisplayThread((Runnable)bldr, (boolean)true);
            dialogResult.setValue(bldr.getResult());
            if (dialogResult.getValue() == 0) {
                BranchToken branch = bldr.getSelectedBranch();
                toReturn = branchToTx.get(branch);
                if (bldr.getApplyToAll()) {
                    this.savedBranches.add(branch);
                }
            }
        }
        return toReturn;
    }

    private class BranchListDialog
    extends FilteredTreeBranchDialog {
        XCheckBox applyToAll;

        public BranchListDialog(String title, String message, Collection<BranchToken> branchChoices) {
            super(title, message, branchChoices);
            this.setInput(branchChoices);
        }

        protected Control createDialogArea(Composite container) {
            Control control = super.createDialogArea(container);
            Composite comp = new Composite(control.getParent(), 0);
            comp.setLayout((Layout)new GridLayout(2, false));
            comp.setLayoutData((Object)new GridData(1808));
            this.applyToAll = new XCheckBox("Apply to all");
            this.applyToAll.set(true);
            this.applyToAll.createWidgets(comp, 2);
            return control;
        }

        private Boolean getApplyToAll() {
            return this.applyToAll.isChecked();
        }
    }

    private class BranchListDialogRunnable
    implements Runnable {
        private final String title;
        private final String message;
        private final Collection<BranchToken> branchChoices;
        private int result;
        private BranchToken selectedBranch;
        private Boolean applyToAll;

        public BranchListDialogRunnable(String title, String message, Collection<BranchToken> branchChoices) {
            this.title = title;
            this.message = message;
            this.branchChoices = branchChoices;
        }

        @Override
        public void run() {
            BranchListDialog dialog = new BranchListDialog(this.title, this.message, this.branchChoices);
            dialog.setMultiSelect(false);
            this.result = dialog.open();
            if (this.result == 0) {
                this.selectedBranch = (BranchToken)dialog.getSelectedFirst();
            }
            this.applyToAll = dialog.getApplyToAll();
        }

        public int getResult() {
            return this.result;
        }

        public BranchToken getSelectedBranch() {
            return this.selectedBranch;
        }

        public boolean getApplyToAll() {
            return this.applyToAll;
        }
    }

    public static interface Display {
        public Artifact getArtifactSelection(IProgressMonitor var1, Collection<? extends Artifact> var2) throws Exception;

        public void showDifferences(Collection<ArtifactDelta> var1);
    }
}

