/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.mini;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerSorter;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.column.AtsColumnIdValueColumn;
import org.eclipse.osee.ats.api.config.AtsAttributeValueColumn;
import org.eclipse.osee.ats.core.column.AtsColumnToken;
import org.eclipse.osee.ats.ide.column.AssigneeColumnUI;
import org.eclipse.osee.ats.ide.column.AssumptionsColumn;
import org.eclipse.osee.ats.ide.column.AtsColumnIdUi;
import org.eclipse.osee.ats.ide.column.DescriptionColumn;
import org.eclipse.osee.ats.ide.column.PointsColumn;
import org.eclipse.osee.ats.ide.column.TleReviewedColumn;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttributeValueColumn;
import org.eclipse.osee.ats.ide.world.WorldXViewerFactory;
import org.eclipse.osee.ats.ide.world.WorldXViewerSorter;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.SkynetXViewerFactory;

public abstract class MiniTaskXViewerFactory
extends SkynetXViewerFactory {
    private final String namespace;

    public MiniTaskXViewerFactory(String namespace) {
        super(namespace, null);
        this.namespace = namespace;
    }

    protected void addPreColumns(List<XViewerColumn> cols) {
    }

    protected void addPostColumns(List<XViewerColumn> cols) {
    }

    public List<XViewerColumn> getColumns() {
        ArrayList<XViewerColumn> cols = new ArrayList<XViewerColumn>();
        this.addPreColumns(cols);
        cols.add(this.getAttributeConfigColumn(AtsColumnToken.TitleColumn));
        cols.add(this.getColumnServiceColumn(AtsColumnToken.StateColumn));
        cols.add(AssigneeColumnUI.getInstance());
        PointsColumn ptsCol = PointsColumn.instance.copy();
        ptsCol.setShow(true);
        ptsCol.setWidth(30);
        cols.add(ptsCol);
        cols.add(TleReviewedColumn.instance);
        DescriptionColumn descCol = DescriptionColumn.instance.copy();
        descCol.setShow(true);
        cols.add(descCol);
        cols.add(AssumptionsColumn.instance);
        cols.add(this.getAttributeConfigColumn(AtsColumnToken.NotesColumn));
        cols.add(this.getColumnServiceColumn(AtsColumnToken.AtsIdColumnShow));
        this.addPostColumns(cols);
        for (XViewerColumn col : cols) {
            if (col.getName().equals(AtsColumnToken.TitleColumn.getName())) {
                col.setWidth(250);
                continue;
            }
            if (!col.getName().equals(AtsColumnToken.NotesColumn.getName())) continue;
            col.setWidth(150);
        }
        XViewerColumn[] xViewerColumnArray = WorldXViewerFactory.getWorldViewColumns();
        int n = xViewerColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            XViewerColumn col;
            col = xViewerColumnArray[n2];
            if (!cols.contains(col)) {
                col.setShow(false);
                cols.add(col);
            }
            ++n2;
        }
        return cols;
    }

    public XViewerColumn getColumnServiceColumn(AtsColumnIdValueColumn columnToken) {
        return new AtsColumnIdUi(columnToken, AtsApiService.get());
    }

    private XViewerColumn getAttributeConfigColumn(AtsAttributeValueColumn attrValueColumn) {
        XViewerAtsAttributeValueColumn result = null;
        for (AtsAttributeValueColumn column : AtsApiService.get().getConfigService().getConfigurations().getViews().getAttrColumns()) {
            if (!column.getNamespace().equals(this.namespace) || !column.getId().equals(attrValueColumn.getId())) continue;
            result = new XViewerAtsAttributeValueColumn(column);
            break;
        }
        if (result == null) {
            result = new XViewerAtsAttributeValueColumn(attrValueColumn);
        }
        return result;
    }

    public XViewerSorter createNewXSorter(XViewer xViewer) {
        return new WorldXViewerSorter(xViewer);
    }
}

