/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.cr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsDatabaseTypeProvider;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.builder.XWidgetBuilder;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class CreateNewChangeRequestBlam
extends AbstractBlam
implements INewActionListener {
    private static final String BLAM_DESCRIPTION = "Create program top level Demo Change Request for any new feature or problem found.\nThis will mature into all the work for all teams needed to resolve this request.";
    protected static final String TITLE = "Title";
    protected static final String PROGRAM = "Program";
    protected static final String DESCRIPTION = "Description";
    protected static final String CHANGE_TYPE = "Change Type";
    protected static final String PRIORITY = "Priority";
    protected static final String NEED_BY = "Need By";
    protected XText titleWidget;
    protected XText descWidget;
    protected XCombo changeWidget;
    protected XCombo priorityWidget;
    protected final AtsApi atsApi = AtsApiService.get();
    protected XWidgetBuilder wb;
    private ActionResult actionResult;

    public CreateNewChangeRequestBlam(String name) {
        super(name, BLAM_DESCRIPTION, null);
    }

    protected boolean isValidEntry() {
        return true;
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        String desc;
        String programAi;
        this.variableMap = variableMap;
        boolean valid = true;
        String title = variableMap.getString(TITLE);
        if (Strings.isInValid((String)title)) {
            this.log(new String[]{"Enter Title"});
            valid = false;
        }
        if (Strings.isInValid((String)(programAi = variableMap.getString(PROGRAM)))) {
            this.log(new String[]{"Select Program"});
            valid = false;
        }
        if (Strings.isInValid((String)(desc = variableMap.getString(DESCRIPTION)))) {
            this.log(new String[]{"Enter Description"});
            valid = false;
        }
        String changeType = variableMap.getString(CHANGE_TYPE);
        ChangeType cType = null;
        if (Strings.isInValid((String)changeType) || "--select--".equals(changeType)) {
            this.log(new String[]{"Select Change type"});
            valid = false;
        } else {
            try {
                cType = ChangeType.valueOf((String)changeType);
            }
            catch (Exception exception) {
                valid = false;
                this.log(new String[]{"Invalid Change Type"});
            }
        }
        String priority = variableMap.getString(PRIORITY);
        if (Strings.isInValid((String)priority) || "--select--".equals(priority)) {
            this.log(new String[]{"Select Priority"});
            valid = false;
        }
        Date needBy = (Date)variableMap.getValue(NEED_BY);
        if (!this.isValidEntry() || !valid) {
            return;
        }
        IAtsActionableItem ai = null;
        for (IAtsActionableItem ai2 : this.getProgramCrAis()) {
            if (!ai2.getName().equals(programAi)) continue;
            ai = ai2;
            break;
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet(this.getName());
        this.actionResult = this.atsApi.getActionService().createAction(this.atsApi.getUserService().getCurrentUser(), title, desc, cType, priority, false, needBy, Collections.singleton(ai), new Date(), this.atsApi.getUserService().getCurrentUser(), Collections.singleton(this), changes);
        changes.execute();
        if (this.actionResult.getResults().isErrors()) {
            this.log(new String[]{this.actionResult.getResults().toString()});
            return;
        }
        IAtsTeamWorkflow teamWf = this.actionResult.getFirstTeam();
        WorkflowEditor.edit((IAtsWorkItem)teamWf);
    }

    public abstract Collection<IAtsActionableItem> getProgramCrAis();

    public List<XWidgetRendererItem> getXWidgetItems() {
        this.wb = new XWidgetBuilder();
        this.wb.andXCombo(PROGRAM, Collections.emptyList()).andRequired().endWidget();
        this.wb.andXText(TITLE).andRequired().endWidget();
        this.wb.andXText((AttributeTypeToken)AtsAttributeTypes.Description).andHeight(80).andRequired().endWidget();
        this.addChangeTypeCombo();
        this.wb.andXCombo(this.getPriorityAttr()).andRequired().endWidget();
        this.addWidgetAfterPriority();
        this.wb.andXDate((AttributeTypeToken)AtsAttributeTypes.NeedBy).endComposite().endWidget();
        return this.wb.getItems();
    }

    private void addChangeTypeCombo() {
        this.wb.andXCombo((AttributeTypeToken)AtsAttributeTypes.ChangeType).andComposite(this.getChangeTypeRowColumns()).andRequired().endWidget();
    }

    protected void addWidgetAfterPriority() {
    }

    protected int getChangeTypeRowColumns() {
        return 6;
    }

    protected AttributeTypeToken getPriorityAttr() {
        return AtsAttributeTypes.Priority;
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, xModListener, isEditable);
        if (xWidget.getLabel().equals(TITLE)) {
            this.titleWidget = (XText)xWidget;
        } else if (xWidget.getLabel().equals(DESCRIPTION)) {
            this.descWidget = (XText)xWidget;
        } else if (xWidget.getLabel().equals(CHANGE_TYPE)) {
            this.changeWidget = (XCombo)xWidget;
            CreateNewChangeRequestBlam.setChangeTypeWidget(this.changeWidget);
        } else if (xWidget.getLabel().equals(PRIORITY)) {
            this.priorityWidget = (XCombo)xWidget;
        } else if (xWidget.getLabel().equals(PROGRAM)) {
            XCombo programCombo = (XCombo)xWidget;
            programCombo.setToolTip("Selection if multiple Change Request programs exist");
            ArrayList<String> aiStrs = new ArrayList<String>();
            for (IAtsActionableItem ai : this.getProgramCrAis()) {
                aiStrs.add(ai.getName());
            }
            programCombo.setDataStrings(aiStrs);
            if (aiStrs.size() == 1) {
                programCombo.getComboBox().select(1);
            }
            if (aiStrs.size() == 1) {
                programCombo.setEditable(false);
            }
            programCombo.getLabelWidget().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent event) {
                    if (event.button == 3) {
                        CreateNewChangeRequestBlam.this.handlePopulateWithDebugInfo();
                    }
                }
            });
        }
    }

    public static void setChangeTypeWidget(XCombo changeWidget) {
        String[] array = ChangeType.valueArray();
        for (IAtsDatabaseTypeProvider provider : AtsApiService.get().getDatabaseTypeProviders()) {
            if (!provider.useFactory() || provider.getChangeTypeValues() == null) continue;
            array = provider.getChangeTypeArray();
        }
        changeWidget.setDataStrings(array);
    }

    public void handlePopulateWithDebugInfo() {
        String title = "New CR " + this.atsApi.getRandomNum();
        this.handlePopulateWithDebugInfo(title);
    }

    public void handlePopulateWithDebugInfo(String title) {
        try {
            this.titleWidget.set(title);
            this.descWidget.set("Description...");
            this.changeWidget.getComboBox().select(1);
            this.priorityWidget.getComboBox().select(1);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public abstract String getRunText();

    public String getOutputMessage() {
        return "Not yet run.";
    }

    public String getTabTitle() {
        return "Change Request";
    }

    public String getTitle() {
        return this.getName();
    }

    public Image getImage() {
        return ImageManager.getImage((OseeImage)AtsImage.CHANGE_REQUEST);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.CHANGE_REQUEST);
    }

    public ActionResult getActionResult() {
        return this.actionResult;
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavItemCat.TOP_NEW);
    }
}

