/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.skynet.internal.ServiceUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.util.DefaultXWidgetOptionResolver;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;

public final class ATSXWidgetOptionResolver
extends DefaultXWidgetOptionResolver {
    private static ATSXWidgetOptionResolver instance = new ATSXWidgetOptionResolver();
    public static final String OPTIONS_FROM_ATTRIBUTE_VALIDITY = "OPTIONS_FROM_ATTRIBUTE_VALIDITY";

    private ATSXWidgetOptionResolver() {
    }

    public String[] getWidgetOptions(XWidgetRendererItem xWidgetData) {
        if (xWidgetData.getXWidgetName().contains(OPTIONS_FROM_ATTRIBUTE_VALIDITY) || xWidgetData.getXWidgetName().contains("ACTIVE_USER_COMMUNITIES")) {
            Set options = new HashSet();
            OrcsTokenService tokenService = ServiceUtil.getTokenService();
            AttributeTypeString attributeType = AttributeTypeGeneric.SENTINEL;
            try {
                String storeName = xWidgetData.getStoreName();
                Long storeId = xWidgetData.getStoreId();
                if (storeId > 0L) {
                    attributeType = tokenService.getAttributeType(storeId);
                } else if (Strings.isValid((String)storeName)) {
                    attributeType = tokenService.getAttributeType(storeName);
                } else if (Strings.isValid((String)xWidgetData.getName())) {
                    attributeType = tokenService.getAttributeType(xWidgetData.getName());
                } else {
                    throw new OseeArgumentException("Attribute Type can not be determined from storeName [%s] or Name [%s] and is needed for OPTIONS_FROM_ATTRIBUTE_VALIDITY for widget [%s]", new Object[]{xWidgetData.getStoreName(), xWidgetData.getName(), xWidgetData});
                }
                if (attributeType.isEnumerated()) {
                    options = attributeType.toEnum().getEnumStrValues();
                }
            }
            catch (Exception ex) {
                throw new OseeArgumentException("Exception determining Attribute Type from storeName [%s] or Name [%s] and widget [%s]: %s", new Object[]{xWidgetData.getStoreName(), xWidgetData.getName(), xWidgetData, ex.getLocalizedMessage()});
            }
            Object[] optStrs = options.toArray(new String[options.size()]);
            Arrays.sort(optStrs);
            return optStrs;
        }
        return super.getWidgetOptions(xWidgetData);
    }

    public static ATSXWidgetOptionResolver getInstance() {
        return instance;
    }
}

