/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.xviewer.column;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.nebula.widgets.xviewer.IXViewerPreComputedColumn;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.util.ColorColumn;
import org.eclipse.osee.ats.core.column.AtsColumnId;
import org.eclipse.osee.ats.ide.column.CancelledDateColumnUI;
import org.eclipse.osee.ats.ide.column.CompletedCancelledDateColumnUI;
import org.eclipse.osee.ats.ide.column.CompletedDateColumnUI;
import org.eclipse.osee.ats.ide.column.CreatedDateColumnUI;
import org.eclipse.osee.ats.ide.column.IPersistAltLeftClickProvider;
import org.eclipse.osee.ats.ide.column.ReleaseDateColumn;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.AtsAttributeColumnUtility;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public abstract class XViewerAtsColumn
extends XViewerColumn {
    private Map<Object, String> elementToForegroundColor;
    private Map<Object, String> elementToBackgroundColor;
    private Map<String, Color> hexColorToColor;
    private Boolean hasColorColumn = null;
    private ColorColumn colorColumn;
    private Boolean actionRollup = null;
    private Boolean inheritParent = null;

    protected XViewerAtsColumn() {
    }

    public XViewerAtsColumn(String id, String name, int width, XViewerAlign align, boolean show, SortDataType sortDataType, boolean multiColumnEditable, String description) {
        super(id, name, width, align, show, sortDataType, multiColumnEditable, description);
    }

    public XViewerAtsColumn(XViewer xViewer, String xml) {
        super((Object)xViewer, xml);
    }

    protected void copy(XViewerColumn fromXCol, XViewerColumn toXCol) {
        super.copy(fromXCol, toXCol);
        if (fromXCol instanceof XViewerAtsColumn && toXCol instanceof XViewerAtsColumn) {
            ((XViewerAtsColumn)toXCol).setActionRollup(this.actionRollup);
            ((XViewerAtsColumn)toXCol).setInheritParent(this.inheritParent);
            ((XViewerAtsColumn)toXCol).setHasColorColumn(this.hasColorColumn, this.colorColumn);
        }
    }

    protected boolean isPersistViewer() {
        return this.isPersistViewer((XViewer)this.getXViewer());
    }

    protected boolean isPersistViewer(XViewer xViewer) {
        return AtsAttributeColumnUtility.isPersistViewer(xViewer);
    }

    public Image getColumnImage(Object element, XViewerColumn column, int columnIndex) {
        return null;
    }

    public Color getBackground(Object element, XViewerColumn xCol, int columnIndex) {
        if (this.isColorColumn()) {
            return this.getColor(element, true, columnIndex);
        }
        return null;
    }

    public Color getForeground(Object element, XViewerColumn xCol, int columnIndex) {
        if (this.isColorColumn()) {
            return this.getColor(element, false, columnIndex);
        }
        return null;
    }

    public StyledString getStyledText(Object element, XViewerColumn viewerColumn, int columnIndex) {
        return null;
    }

    public Font getFont(Object element, XViewerColumn viewerColumn, int columnIndex) {
        return null;
    }

    protected boolean isPersistAltLeftClick() {
        XViewer xViewer = (XViewer)this.getXViewer();
        if (xViewer instanceof IPersistAltLeftClickProvider) {
            return ((IPersistAltLeftClickProvider)xViewer).isAltLeftClickPersist();
        }
        return false;
    }

    public Object getBackingData(Object element, XViewerColumn xCol, int columnIndex) throws Exception {
        XViewerAtsColumn xViewerAtsColumn;
        if (xCol.getId().equals(AtsColumnId.CreatedDate.getId())) {
            xViewerAtsColumn = CreatedDateColumnUI.getInstance();
        } else if (xCol.getId().equals(AtsColumnId.ReleaseDate.getId())) {
            xViewerAtsColumn = ReleaseDateColumn.getInstance();
        } else if (xCol.getId().equals(AtsColumnId.CompletedDate.getId())) {
            xViewerAtsColumn = CompletedDateColumnUI.getInstance();
        } else if (xCol.getId().equals(AtsColumnId.CancelledDate.getId())) {
            xViewerAtsColumn = CancelledDateColumnUI.getInstance();
        } else if (xCol.getId().equals(AtsColumnId.CompletedCancelledDate.getId())) {
            xViewerAtsColumn = CompletedCancelledDateColumnUI.getInstance();
        } else {
            return null;
        }
        return ((XViewerAtsColumn)xViewerAtsColumn).getBackingData(element, xCol, columnIndex);
    }

    private Color getColor(Object element, boolean background, int columnIndex) {
        Color resultColor = null;
        if (this.isColorColumn()) {
            String hexColor = null;
            hexColor = background ? this.elementToBackgroundColor.get(element) : this.elementToForegroundColor.get(element);
            if (!Strings.isValid((String)hexColor)) {
                Color color = this.hexColorToColor.get(hexColor);
                if (color != null) {
                    resultColor = color;
                } else {
                    try {
                        String value = null;
                        if (this instanceof IXViewerPreComputedColumn) {
                            IXViewerPreComputedColumn ixViewerPreComputedColumn = (IXViewerPreComputedColumn)this;
                            value = ixViewerPreComputedColumn.getText(element, ixViewerPreComputedColumn.getKey(element), "");
                        } else if (this instanceof IXViewerValueColumn) {
                            IXViewerValueColumn valueColumn = (IXViewerValueColumn)this;
                            value = valueColumn.getColumnText(element, (XViewerColumn)this, columnIndex);
                        } else {
                            value = this.getStyledText(element, this, 0).getString();
                        }
                        if (Strings.isValid((String)value)) {
                            hexColor = background ? this.colorColumn.getBackgroundColorHex(value) : this.colorColumn.getForgroundColorHex(value);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (Strings.isValid((String)hexColor) && (resultColor = this.hexColorToColor.get(hexColor)) == null) {
                resultColor = Displays.getColor((int)Integer.valueOf(hexColor.substring(1, 3), 16), (int)Integer.valueOf(hexColor.substring(3, 5), 16), (int)Integer.valueOf(hexColor.substring(5, 7), 16));
                this.hexColorToColor.put(hexColor, resultColor);
                if (background) {
                    this.elementToBackgroundColor.put(element, hexColor);
                } else {
                    this.elementToForegroundColor.put(element, hexColor);
                }
            }
        }
        return resultColor;
    }

    public boolean isColorColumn() {
        if (this.hasColorColumn == null) {
            this.colorColumn = AtsApiService.get().getConfigService().getConfigurations().getColorColumns().getColumnById(this.getId());
            this.hasColorColumn = this.colorColumn != null;
            if (this.hasColorColumn.booleanValue()) {
                this.elementToForegroundColor = new HashMap<Object, String>(100);
                this.elementToBackgroundColor = new HashMap<Object, String>(100);
                this.hexColorToColor = new HashMap<String, Color>(25);
            }
        }
        return this.hasColorColumn;
    }

    public Boolean isActionRollup() {
        return this.actionRollup;
    }

    public void setHasColorColumn(Boolean hasColorColumn, ColorColumn colorColumn) {
        this.hasColorColumn = hasColorColumn;
        this.colorColumn = colorColumn;
    }

    public void setActionRollup(Boolean actionRollup) {
        this.actionRollup = actionRollup;
    }

    public Boolean isInheritParent() {
        return this.inheritParent;
    }

    public void setInheritParent(Boolean inheritParent) {
        this.inheritParent = inheritParent;
    }
}

