/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.dialog;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.internal.Activator;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBox;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class FilteredTreeAtsUserDialog
extends FilteredTreeDialog {
    private Collection<AtsUser> selectable;
    private XCheckBox checkbox;
    private String checkBoxLabel;
    private boolean defaultChecked;
    private boolean checked;
    private XText text;
    private String textLabel;
    private String enteredText;

    public FilteredTreeAtsUserDialog(String title, String message, Collection<AtsUser> selectable, ILabelProvider labelProvider) {
        this(title, message, selectable, (ITreeContentProvider)new ArrayTreeContentProvider(), labelProvider);
    }

    public FilteredTreeAtsUserDialog(String title, String message, Collection<AtsUser> selectable, ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        this(title, message, selectable, contentProvider, labelProvider, (ViewerComparator)new AtsUserViewerSorter());
    }

    public FilteredTreeAtsUserDialog(String title, String message, Collection<AtsUser> selectable, ITreeContentProvider contentProvider, ILabelProvider labelProvider, ViewerComparator comparator) {
        super(title, message, (IContentProvider)contentProvider, (IBaseLabelProvider)labelProvider, comparator);
        this.selectable = selectable;
    }

    public FilteredTreeAtsUserDialog(String title, Collection<AtsUser> selectable) {
        this(title, title, selectable, (ILabelProvider)new LabelProvider());
    }

    protected Control createDialogArea(Composite container) {
        Composite comp1;
        Control comp = super.createDialogArea(container);
        try {
            this.getTreeViewer().getViewer().setInput(this.selectable);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        if (Strings.isValid((String)this.checkBoxLabel)) {
            comp1 = new Composite(container, 0);
            comp1.setLayout((Layout)new GridLayout(2, false));
            comp1.setLayoutData((Object)new GridData(1808));
            this.checkbox = new XCheckBox(this.checkBoxLabel);
            this.checkbox.createWidgets(comp1, 2);
            this.checkbox.set(this.defaultChecked);
            this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilteredTreeAtsUserDialog.this.checked = FilteredTreeAtsUserDialog.this.checkbox.isChecked();
                }
            });
        }
        if (Strings.isValid((String)this.textLabel)) {
            comp1 = new Composite(container, 0);
            comp1.setLayout((Layout)new GridLayout(1, false));
            comp1.setLayoutData((Object)new GridData(1808));
            this.text = new XText(this.textLabel);
            this.text.setFillVertically(true);
            this.text.createWidgets(comp1, 2);
            if (Strings.isValid((String)this.enteredText)) {
                this.text.set(this.enteredText);
            }
            this.text.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    FilteredTreeAtsUserDialog.this.enteredText = FilteredTreeAtsUserDialog.this.text.get();
                }
            });
        }
        return comp;
    }

    protected Result isComplete() {
        return super.isComplete();
    }

    public void setSelectable(Collection<AtsUser> selectable) {
        this.selectable = selectable;
    }

    public void setComparator(ViewerComparator comparator) {
        this.getTreeViewer().getViewer().setComparator(comparator);
    }

    public void addCheckbox(String label, boolean defaultChecked) {
        this.checkBoxLabel = label;
        this.defaultChecked = defaultChecked;
    }

    public AtsUser getSelectedFirst() {
        return (AtsUser)super.getSelectedFirst();
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public void addTextBox(String label) {
        this.textLabel = label;
    }

    public String getEnteredText() {
        return this.enteredText;
    }

    public void setEnteredText(String enteredText) {
        this.enteredText = enteredText;
    }

    public static class AtsUserViewerSorter
    extends ViewerSorter {
        private final boolean reverse;

        public AtsUserViewerSorter() {
            this(false);
        }

        public AtsUserViewerSorter(boolean reverse) {
            this.reverse = reverse;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            if (this.reverse) {
                return this.getComparator().compare(((AtsUser)o2).getName(), ((AtsUser)o1).getName());
            }
            return this.getComparator().compare(((AtsUser)o1).getName(), ((AtsUser)o2).getName());
        }
    }
}

