/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.VersionListDialog;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelValueSelection;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.Widget;

public abstract class XHyperlabelVersionSelectionWithPersist
extends XHyperlinkLabelValueSelection
implements ArtifactWidget {
    public static final String WIDGET_ID = XHyperlabelVersionSelectionWithPersist.class.getSimpleName();
    Collection<IAtsVersion> selectableVersions;
    VersionListDialog dialog = null;
    private Artifact artifact;
    private final RelationTypeSide relType;
    protected AtsApi atsApi;
    protected boolean removeAllAllowed = true;

    public XHyperlabelVersionSelectionWithPersist(String label, RelationTypeSide relType) {
        super(label);
        this.relType = relType;
        this.atsApi = AtsApiService.get();
    }

    public Version getSelectedVersion() {
        ArtifactToken related = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)this.artifact, this.relType);
        if (related.isValid()) {
            this.atsApi.getVersionService().createVersion(related);
        }
        return null;
    }

    public Object getData() {
        return this.getSelectedVersion();
    }

    public String getCurrentValue() {
        ArtifactToken related = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)this.artifact, this.relType);
        if (related.isValid()) {
            return related.getName();
        }
        return "Not Set";
    }

    public boolean handleClear() {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Update " + this.relType.getName());
        changes.unrelateAll((Object)this.getArtifact(), this.relType);
        changes.executeIfNeeded();
        this.notifyXModifiedListeners();
        return true;
    }

    public boolean handleSelection() {
        try {
            this.dialog = this.selectableVersions == null ? new VersionListDialog("Select Version", "Select Version", this.getSelectableVersions()) : new VersionListDialog("Select Version", "Select Version", this.selectableVersions);
            this.dialog.setRemoveAllAllowed(this.removeAllAllowed);
            int result = this.dialog.open();
            if (result == 0) {
                IAtsChangeSet changes = AtsApiService.get().createChangeSet("Update " + this.relType.getName());
                changes.setRelation((Object)this.getArtifact(), this.relType, this.dialog.getSelectedFirst());
                TransactionToken transaction = changes.executeIfNeeded();
                if (transaction.isValid()) {
                    this.notifyXModifiedListeners();
                }
            }
            return true;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return false;
        }
    }

    private Collection<IAtsVersion> getSelectableVersions() {
        IAtsTeamDefinition teamDefHoldingVersion;
        if (this.artifact instanceof IAtsTeamWorkflow && (teamDefHoldingVersion = this.atsApi.getTeamDefinitionService().getTeamDefHoldingVersions(((IAtsTeamWorkflow)this.artifact).getTeamDefinition())) != null) {
            return this.atsApi.getTeamDefinitionService().getVersions(teamDefHoldingVersion);
        }
        return Collections.emptyList();
    }

    public void setVersions(Collection<IAtsVersion> versions) {
        this.selectableVersions = versions;
        if (this.dialog != null) {
            this.dialog.setInput(versions);
        }
    }

    public boolean isEmpty() {
        return this.getSelectedVersion() != null;
    }

    public void setEnableHyperLink() {
        if (Widgets.isAccessible((Widget)this.labelHyperlink)) {
            this.labelHyperlink.setEnabled(true);
        }
    }

    public void setDisableHyperLink() {
        if (Widgets.isAccessible((Widget)this.labelHyperlink)) {
            this.labelHyperlink.setEnabled(false);
        }
    }

    public void setArtifact(Artifact art) {
        if (art instanceof TeamWorkFlowArtifact) {
            this.artifact = art;
        }
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void revert() {
    }

    public void saveToArtifact() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public boolean isRemoveAllAllowed() {
        return this.removeAllAllowed;
    }

    public void setRemoveAllAllowed(boolean removeAllAllowed) {
        this.removeAllAllowed = removeAllAllowed;
    }
}

