/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabel;

public class XCpaOpenPcrWidget
extends XHyperlinkLabel
implements ArtifactWidget {
    public static final String WIDGET_ID = XCpaOpenPcrWidget.class.getSimpleName();
    private Artifact artifact;
    private final AttributeTypeToken pcrIdAttr;

    public XCpaOpenPcrWidget(AttributeTypeToken pcrIdAttr) {
        super("open", "", false);
        this.pcrIdAttr = pcrIdAttr;
    }

    protected String getCpaBasepath() {
        return AtsApiService.get().getConfigValue("CpaBasepath");
    }

    public String getUrl() {
        String url = null;
        String orgPcrId = this.artifact.getSoleAttributeValueAsString(this.pcrIdAttr, null);
        String pcrTool = (String)this.artifact.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.PcrToolId, null);
        if (Strings.isValid((String)orgPcrId) && Strings.isValid((String)pcrTool)) {
            url = String.format("%s/ats/cpa/decision/%s?pcrSystem=%s", this.getCpaBasepath(), orgPcrId, pcrTool);
        }
        return url;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }
}

