/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.core.config.ActionableItemSorter;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.swt.widgets.Composite;

public class XActionableItemCombo
extends XComboViewer {
    public static final String WIDGET_ID = XActionableItemCombo.class.getSimpleName();
    private IAtsActionableItem selectedAi = null;
    private final Active active;

    public XActionableItemCombo() {
        this(Active.Active);
    }

    public XActionableItemCombo(Active active) {
        super("Actionable Item", 8);
        this.active = active;
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        super.createControls(parent, horizontalSpan);
        Collection ais = null;
        try {
            ais = AtsApiService.get().getActionableItemService().getActionableItems(this.active, AtsApiService.get().getQueryService());
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Error loading actionable items", (Throwable)ex);
        }
        if (ais != null) {
            ArrayList sortedAiArts = new ArrayList();
            sortedAiArts.addAll(ais);
            Collections.sort(sortedAiArts, new ActionableItemSorter());
            this.getComboViewer().setInput(sortedAiArts);
            ArrayList<String> defaultSelection = new ArrayList<String>();
            defaultSelection.add("--select--");
            this.setSelected(defaultSelection);
            this.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    XActionableItemCombo.this.selectedAi = (IAtsActionableItem)XActionableItemCombo.this.getSelected();
                }
            });
        }
    }

    public IAtsActionableItem getSelectedAi() {
        return this.selectedAi;
    }
}

