/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.ide.search.widget.AbstractXComboViewerSearchWidget;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItem;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;

public class StateTypeSearchWidget
extends AbstractXComboViewerSearchWidget<String> {
    private static final String COMPLETED_CANCELLED = "Completed/Cancelled";
    private static final String WORKING_CANCELLED = "Working/Cancelled";
    private static final String WORKING_COMPLETED = "Working/Completed";
    private static final String CANCELLED = "Cancelled";
    private static final String COMPLETED = "Completed";
    private static final String WORKING = "Working";
    public static final String STATE_TYPE = "State Type";

    public StateTypeSearchWidget(WorldEditorParameterSearchItem searchItem) {
        super(STATE_TYPE, searchItem);
    }

    public Collection<StateType> getTypes() {
        String value = (String)this.get();
        ArrayList<StateType> states = new ArrayList<StateType>();
        if (Strings.isValid((String)value)) {
            if (value.contains(StateType.Working.name())) {
                states.add(StateType.Working);
            }
            if (value.contains(StateType.Completed.name())) {
                states.add(StateType.Completed);
            }
            if (value.contains(StateType.Cancelled.name())) {
                states.add(StateType.Cancelled);
            }
        }
        return states;
    }

    public void set(StateType ... stateTypes) {
        List<StateType> states;
        String selected = "";
        if (stateTypes != null && stateTypes.length != 0 && !(states = Arrays.asList(stateTypes)).isEmpty()) {
            boolean isWorking = false;
            boolean isCompleted = false;
            boolean isCancelled = false;
            if (states.contains(StateType.Working)) {
                selected = WORKING;
                isWorking = true;
            }
            if (states.contains(StateType.Completed)) {
                selected = COMPLETED;
                isCompleted = true;
            }
            if (states.contains(StateType.Cancelled)) {
                selected = CANCELLED;
                isCancelled = true;
            }
            if (isWorking && isCompleted) {
                selected = WORKING_COMPLETED;
            }
            if (isWorking && isCancelled) {
                selected = WORKING_CANCELLED;
            }
            if (isCompleted && isCancelled) {
                selected = COMPLETED_CANCELLED;
            }
        }
        if (Strings.isValid((String)selected)) {
            this.getWidget().setSelected(Arrays.asList(selected));
        }
    }

    @Override
    public void set(AtsSearchData data) {
        this.setup((XWidget)this.getWidget());
        if (data.getStateTypes() != null && !data.getStateTypes().isEmpty()) {
            this.set(data.getStateTypes().toArray(new StateType[data.getStateTypes().size()]));
        } else {
            this.set(new StateType[0]);
        }
    }

    @Override
    public Collection<String> getInput() {
        return Arrays.asList("--clear--", WORKING, COMPLETED, CANCELLED, WORKING_COMPLETED, WORKING_CANCELLED, COMPLETED_CANCELLED);
    }
}

