/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.search.AtsQuickSearchData;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.world.IWorldEditorConsumer;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorOperation;
import org.eclipse.osee.ats.ide.world.WorldEditorOperationProvider;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;

class AtsQuickSearchOperation
extends AbstractOperation
implements WorldEditorOperation,
IWorldEditorConsumer {
    Set<Artifact> allArtifacts = new HashSet<Artifact>();
    private final AtsQuickSearchData data;
    private WorldEditor worldEditor;

    public AtsQuickSearchOperation(AtsQuickSearchData data) {
        super(data.toString(), "org.eclipse.osee.ats.ide");
        this.data = data;
    }

    protected void doWork(IProgressMonitor monitor) {
        if (!Strings.isValid((String)this.data.getSearchStr())) {
            AWorkbench.popup((String)"Must Enter Search String");
            return;
        }
        if (this.worldEditor == null) {
            WorldEditor.open(new WorldEditorOperationProvider(new AtsQuickSearchOperation(this.data)));
            return;
        }
        this.performSearch();
        if (this.allArtifacts.isEmpty()) {
            AWorkbench.popup((String)this.getName(), (String)(String.valueOf(this.getName()) + "\n\nNo Results Found"));
        } else if (this.worldEditor != null) {
            this.worldEditor.getWorldComposite().load(this.getName(), this.allArtifacts, XNavigateComposite.TableLoadOption.None);
        }
    }

    @Override
    public Collection<Artifact> performSearch() {
        this.allArtifacts.clear();
        this.allArtifacts.addAll(Collections.castAll((Collection)AtsApiService.get().getQueryService().getArtifactsByIdsOrAtsIds(this.data.getSearchStr())));
        for (Artifact art : ArtifactQuery.getArtifactListFromAttributeKeywords((BranchId)AtsApiService.get().getAtsBranch(), (String)this.data.getSearchStr(), (boolean)false, (DeletionFlag)DeletionFlag.EXCLUDE_DELETED, (boolean)false, (AttributeTypeId[])new AttributeTypeId[0])) {
            try {
                if (!(art instanceof AbstractWorkflowArtifact)) continue;
                AbstractWorkflowArtifact awa = (AbstractWorkflowArtifact)art;
                if (!this.data.isIncludeCompleteCancelled()) {
                    if (awa.isCompletedOrCancelled()) continue;
                    this.allArtifacts.add(art);
                    continue;
                }
                this.allArtifacts.add(art);
            }
            catch (Exception ex) {
                String str = "Exception occurred in " + art.toStringWithId();
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)str, (Throwable)ex);
            }
        }
        return this.allArtifacts;
    }

    @Override
    public String getName() {
        return this.data.toString();
    }

    @Override
    public WorldEditor getWorldEditor() {
        return this.worldEditor;
    }

    @Override
    public void setWorldEditor(WorldEditor worldEditor) {
        this.worldEditor = worldEditor;
    }
}

