/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.branch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.branch.BranchStatus;
import org.eclipse.osee.ats.api.commit.CommitConfigItem;
import org.eclipse.osee.ats.api.commit.CommitStatus;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsBranchService;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.util.widgets.XWorkingBranchEnablement;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.KindType;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.DemoBranches;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.exception.BranchDoesNotExist;
import org.eclipse.osee.framework.core.exception.MultipleAttributesExist;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.IHealthStatus;
import org.eclipse.osee.framework.logging.ILoggerListener;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.logging.SevereLoggingMonitor;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.PurgeArtifacts;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.revision.ChangeData;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.skynet.render.RenderingUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class BranchRegressionTest {
    private static final String PRE_BRANCH_CHANGES = "testMakePreBranchChanges_";
    public static String PRE_BRANCH_ARTIFACT_NAME = "Pre-Branch Artifact to Delete";
    protected static Artifact actionArt;
    protected static TeamWorkFlowArtifact reqTeam;
    protected static TeamWorkFlowArtifact codeTeam;
    protected static TeamWorkFlowArtifact testTeam;
    public static String SOFTWARE_REQUIREMENTS;
    public static String FIRST_ARTIFACT;
    public static String SECOND_ARTIFACT;
    public static String THIRD_ARTIFACT;
    public static String FOURTH_ARTIFACT;
    public static String FIFTH_ARTIFACT;
    public static String SUBSYSTEM_ARTIFACT;
    protected final List<String> ArtifactModifiedNames = new ArrayList<String>();
    protected final List<String> NonRelArtifactModifedNames = new ArrayList<String>();
    protected static SevereLoggingMonitor monitorLog;
    protected Artifact softReqArt;
    protected Artifact secondArt;
    protected Artifact thirdArt;
    protected Artifact fourthArt;
    protected Artifact fifthArt;
    protected Artifact createAndDeleteArt;
    protected Artifact subsystemArt;
    protected Artifact preBranchArt;
    protected BranchToken workingBranch;

    static {
        SOFTWARE_REQUIREMENTS = "Software Requirements";
        FIRST_ARTIFACT = "First Artifact";
        SECOND_ARTIFACT = "Second Artifact";
        THIRD_ARTIFACT = "Third Artifact";
        FOURTH_ARTIFACT = "Fourth Artifact - No CSCI";
        FIFTH_ARTIFACT = "Fifth Artifact - Unspecified CSCI";
        SUBSYSTEM_ARTIFACT = "Subsystem Artifact (no partition)";
    }

    public BranchRegressionTest() {
        this.ArtifactModifiedNames.addAll(Arrays.asList(FIRST_ARTIFACT, SECOND_ARTIFACT, THIRD_ARTIFACT, FOURTH_ARTIFACT, FIFTH_ARTIFACT, SUBSYSTEM_ARTIFACT, DemoArtifactToken.SystemReqArtifact.getName(), SOFTWARE_REQUIREMENTS));
        this.NonRelArtifactModifedNames.addAll(Arrays.asList(FIRST_ARTIFACT, SECOND_ARTIFACT, THIRD_ARTIFACT, FOURTH_ARTIFACT, FIFTH_ARTIFACT, SUBSYSTEM_ARTIFACT, DemoArtifactToken.SystemReqArtifact.getName()));
    }

    @BeforeClass
    public static void setUp() {
        RenderingUtil.setPopupsAllowed((boolean)false);
        OseeProperties.setIsInTest((boolean)true);
    }

    @AfterClass
    public static void tearDown() {
        OseeProperties.setIsInTest((boolean)false);
    }

    protected void testAfterCreateBranchSectionTime() {
    }

    public void testWorkingBranchCommitCheck() {
    }

    @Test
    public void test() {
        this.testSetup();
        this.testSetupInitialConditions();
        this.testMakePreBranchChanges();
        this.testCreateAction();
        this.testXCommitManagerAfterActionCreate();
        this.testCreateBranchFirstTime();
        this.testDeleteBranch();
        this.testXCommitManagerAfterDeleteBranch();
        this.testCreateBranchSecondTime();
        this.testXWorkingBranchAfterSecondCreateBranch();
        this.testBranchesListedInXCommitManager();
        this.testAfterCreateBranchSectionTime();
        this.createFirstAndSecondReqArt();
        this.testCodeTaskCreationAfterFirstAndSecond();
        this.createThirdFourthFifthReqArt();
        this.testCodeTaskCreationAfterThirdFourthFifth();
        this.createReqArtToDelete();
        this.testCodeTaskCreationAfterCreateReqArtToDelete();
        this.makeNameChangeToReqArtToDelete();
        this.testCodeTestCreationAfterChangeToReqArtifactToDelete();
        this.deleteReqArtToDelete();
        this.testCodeTestCreationAfterDeleteReqArtifactToDelete();
        this.createSubsystemArt();
        this.deletePreBranchArt();
        this.testWorkingBranchCommitCheck();
        this.createParentArtsOnWorkingBranch();
        this.testAfterCreateParentArtsOnWorkingBranch();
        this.testWorkingBranchCommit();
        this.testXWorkingBranchAfterBranchCommit();
        this.testChangesMadeWereCommitted();
        this.testRequirementsWorkflowCompletion();
        this.testCodeTaskCreationAfterReqCompletion();
        this.testShowRelatedTasksAction();
        this.testShowRelatedRequirementAction();
        this.testShowRequirementDiffsAction();
        this.testSevereLoggingMonitorResults();
        this.testCleanup();
    }

    public void testSetup() {
        OseeEventManager.removeAllListeners();
        List actionArts = org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)AtsApiService.get().getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andAttr((AttributeTypeId)AtsAttributeTypes.LegacyPcrId, this.getLegacyPcrId(), new QueryOption[0]).createFilter().getActions());
        HashSet<Artifact> artsToDel = new HashSet<Artifact>();
        for (IAtsAction actionArt : actionArts) {
            artsToDel.add((Artifact)actionArt.getStoreObject());
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)actionArt)) {
                artsToDel.add((Artifact)team.getStoreObject());
                artsToDel.addAll(org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)AtsObjects.getArtifacts((Collection)AtsApiService.get().getTaskService().getTasks(team))));
            }
        }
        Operations.executeWorkAndCheckStatus((IOperation)new PurgeArtifacts(artsToDel));
        this.testCleanup();
    }

    public void testCleanup() {
        HashSet<Artifact> artsToDel = new HashSet<Artifact>();
        for (String artName : Arrays.asList(PRE_BRANCH_ARTIFACT_NAME)) {
            for (Artifact art : ArtifactQuery.getArtifactListFromName((String)artName, (BranchId)DemoBranches.SAW_Bld_2, (DeletionFlag)DeletionFlag.INCLUDE_DELETED, (QueryOption[])QueryOption.EXACT_MATCH_OPTIONS)) {
                artsToDel.add(art);
            }
        }
        if (!artsToDel.isEmpty()) {
            Operations.executeWorkAndCheckStatus((IOperation)new PurgeArtifacts(artsToDel));
        }
        ArrayList<String> branchNameStrs = new ArrayList<String>();
        branchNameStrs.add(this.getLegacyPcrId());
        branchNameStrs.add(PRE_BRANCH_CHANGES);
        if (Strings.isValid((String)this.getBranchNameContains())) {
            branchNameStrs.add(this.getBranchNameContains());
        }
        BranchRegressionTest.purgeWorkingBranches(branchNameStrs);
        AtsUtilClient.setEmailEnabled(true);
        OseeEventManager.removeAllListeners();
    }

    protected static void purgeWorkingBranches(Collection<String> branchNamesContain) {
        try {
            for (BranchToken workingBranch : BranchManager.getBranches((BranchArchivedState)BranchArchivedState.ALL, (BranchType[])new BranchType[]{BranchType.WORKING})) {
                for (String branchName : branchNamesContain) {
                    if (!workingBranch.getName().contains(branchName)) continue;
                    ArtifactCache.deCache((BranchId)workingBranch);
                    BranchManager.purgeBranch((BranchId)workingBranch);
                }
            }
        }
        catch (BranchDoesNotExist branchDoesNotExist) {}
    }

    public void testSetupInitialConditions() {
        AtsUtilClient.setEmailEnabled(false);
        AtsUtil.setIsInTest((boolean)true);
        monitorLog = new SevereLoggingMonitor();
        OseeLog.registerLoggerListener((ILoggerListener)monitorLog);
    }

    public void testMakePreBranchChanges() {
        Assert.assertNotNull((String)"Can't get program workingBranch", (Object)this.getProgramBranch());
        Artifact softReqArt = ArtifactQuery.getArtifactFromAttribute((AttributeTypeId)CoreAttributeTypes.Name, (String)SOFTWARE_REQUIREMENTS, (BranchId)this.getProgramBranch());
        Assert.assertNotNull((String)"Can't get softReqArt", (Object)softReqArt);
        AtsApiService.get().getAccessControlService().setPermission((ArtifactToken)UserManager.getUser(), (BranchId)this.getProgramBranch(), PermissionEnum.FULLACCESS);
        this.createSoftwareArtifact(CoreArtifactTypes.SoftwareRequirementMsWord, softReqArt, PRE_BRANCH_ARTIFACT_NAME, this.getPreBranchCscis(), this.getProgramBranch());
        Assert.assertNotNull((String)"Can't get new software requirement artifact", (Object)softReqArt);
    }

    public abstract void testCreateAction();

    public boolean hasCodeWorkflow() {
        return true;
    }

    protected void testTeamWorkflows(Collection<IAtsTeamWorkflow> teamWfs) {
        for (IAtsTeamWorkflow teamWf : teamWfs) {
            if (teamWf.getTeamDefinition().getName().contains("Req")) {
                reqTeam = (TeamWorkFlowArtifact)teamWf.getStoreObject();
            }
            if (this.hasCodeWorkflow() && teamWf.getTeamDefinition().getName().contains("Code")) {
                codeTeam = (TeamWorkFlowArtifact)teamWf.getStoreObject();
            }
            if (!teamWf.getTeamDefinition().getName().contains("Test")) continue;
            testTeam = (TeamWorkFlowArtifact)teamWf.getStoreObject();
        }
        actionArt = (Artifact)reqTeam.getParentAction().getStoreObject();
        this.validateNoBoostrapUser();
        Assert.assertNotNull((String)"Req workflow not created", (Object)((Object)reqTeam));
        if (this.hasCodeWorkflow()) {
            Assert.assertNotNull((String)"Code workflow not created", (Object)((Object)codeTeam));
        }
        Assert.assertNotNull((String)"Test workflow not created", (Object)((Object)testTeam));
        Assert.assertNotNull((String)"Action not created", (Object)actionArt);
        WorkflowEditor.editArtifact(reqTeam);
        XWorkingBranchEnablement enablement = new XWorkingBranchEnablement(reqTeam);
        Assert.assertEquals((Object)BranchStatus.Not_Started, (Object)enablement.getStatus());
        Assert.assertTrue((String)"Create Branch Button should be enabled", (boolean)enablement.isCreateBranchButtonEnabled());
        Assert.assertFalse((String)"Show Artifact Explorer Button should be disabled", (boolean)enablement.isShowArtifactExplorerButtonEnabled());
        Assert.assertFalse((String)"Show Change Report Button should be disabled", (boolean)enablement.isShowChangeReportButtonEnabled());
        Assert.assertFalse((String)"Delete Button should be disabled", (boolean)enablement.isDeleteBranchButtonEnabled());
    }

    protected void validateNoBoostrapUser() {
        for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)actionArt)) {
            team.getStateMgr().validateNoBootstrapUser();
        }
    }

    public void testXCommitManagerAfterActionCreate() {
        Assert.assertEquals((String)"Should be no committed branches", (long)0L, (long)AtsApiService.get().getBranchService().getBranchesCommittedTo((IAtsTeamWorkflow)reqTeam).size());
    }

    public void testCreateBranchFirstTime() {
        AtsApiService.get().getBranchServiceIde().createWorkingBranch_Create((IAtsTeamWorkflow)reqTeam, true);
        this.workingBranch = reqTeam.getWorkingBranchForceCacheUpdate();
        Assert.assertNotNull((String)"workingBranch returned null", (Object)this.workingBranch);
        XWorkingBranchEnablement enablement = new XWorkingBranchEnablement(reqTeam);
        Assert.assertEquals((Object)BranchStatus.Changes_InProgress, (Object)enablement.getStatus());
        Assert.assertFalse((String)"Create Branch Button should be disabled", (boolean)enablement.isCreateBranchButtonEnabled());
        Assert.assertTrue((String)"Show Artifact Explorer Button should be enabled", (boolean)enablement.isShowArtifactExplorerButtonEnabled());
        Assert.assertTrue((String)"Show Change Report Button should be enabled", (boolean)enablement.isShowChangeReportButtonEnabled());
        Assert.assertTrue((String)"Delete Button should be enabled", (boolean)enablement.isDeleteBranchButtonEnabled());
    }

    public void testDeleteBranch() {
        AtsApiService.get().getBranchServiceIde().deleteWorkingBranch(reqTeam, false, true);
        Assert.assertTrue((boolean)reqTeam.getWorkingBranch().isInvalid());
        XWorkingBranchEnablement enablement = new XWorkingBranchEnablement(reqTeam);
        Assert.assertEquals((Object)BranchStatus.Not_Started, (Object)enablement.getStatus());
        Assert.assertTrue((String)"Create Branch Button should be enabled", (boolean)enablement.isCreateBranchButtonEnabled());
        Assert.assertFalse((String)"Show Artifact Explorer Button should be disabled", (boolean)enablement.isShowArtifactExplorerButtonEnabled());
        Assert.assertFalse((String)"Show Change Report Button should be disabled", (boolean)enablement.isShowChangeReportButtonEnabled());
        Assert.assertFalse((String)"Delete Button should be disabled", (boolean)enablement.isDeleteBranchButtonEnabled());
    }

    public void testXCommitManagerAfterDeleteBranch() {
        IAtsBranchService branchService = AtsApiService.get().getBranchService();
        Collection configArtSet = branchService.getConfigArtifactsConfiguredToCommitTo((IAtsTeamWorkflow)reqTeam);
        for (CommitConfigItem configArt : configArtSet) {
            CommitStatus xCommitStatus = branchService.getCommitStatus((IAtsTeamWorkflow)reqTeam, configArt);
            Assert.assertTrue((String)("XCommitManager Status not as expected: " + CommitStatus.Working_Branch_Not_Created.name() + " [" + configArt.getCommitFullDisplayName() + "]"), (boolean)xCommitStatus.equals((Object)CommitStatus.Working_Branch_Not_Created));
        }
    }

    public void testCreateBranchSecondTime() {
        AtsApiService.get().getBranchServiceIde().createWorkingBranch_Create((IAtsTeamWorkflow)reqTeam, true);
        this.workingBranch = reqTeam.getWorkingBranchForceCacheUpdate();
        Assert.assertNotNull((String)"workingBranch returned null", (Object)this.workingBranch);
    }

    public void testXWorkingBranchAfterSecondCreateBranch() {
        XWorkingBranchEnablement enablement = new XWorkingBranchEnablement(reqTeam);
        Assert.assertEquals((Object)BranchStatus.Changes_InProgress, (Object)enablement.getStatus());
        Assert.assertFalse((String)"Create Branch Button should be disabled", (boolean)enablement.isCreateBranchButtonEnabled());
        Assert.assertTrue((String)"Show Artifact Explorer Button should be enabled", (boolean)enablement.isShowArtifactExplorerButtonEnabled());
        Assert.assertTrue((String)"Show Change Report Button should be enabled", (boolean)enablement.isShowChangeReportButtonEnabled());
        Assert.assertTrue((String)"Delete Button should be enabled", (boolean)enablement.isDeleteBranchButtonEnabled());
    }

    public void testBranchesListedInXCommitManager() {
        IAtsBranchService branchService = AtsApiService.get().getBranchService();
        Collection configItems = branchService.getConfigArtifactsConfiguredToCommitTo((IAtsTeamWorkflow)reqTeam);
        Assert.assertTrue((String)("parallel workingBranch check failed => " + configItems.size()), (configItems.size() == this.getBranchNames().size() ? 1 : 0) != 0);
        for (CommitConfigItem configItem : configItems) {
            BranchId branch = branchService.getBranch(configItem);
            Assert.assertTrue((String)("Missing parallel workingBranch => " + branchService.getBranchName(branch)), (boolean)this.getBranchNames().contains(branchService.getBranchName(branch)));
        }
    }

    protected Artifact getOrCreateArtifact(ArtifactTypeToken artifactType, String artifactName, BranchToken branch, Artifact parent, boolean persist) {
        Artifact art = ArtifactQuery.checkArtifactFromTypeAndName((ArtifactTypeId)artifactType, (String)artifactName, (BranchId)branch);
        if (art == null) {
            art = ArtifactTypeManager.addArtifact((ArtifactTypeToken)artifactType, (BranchToken)branch, (String)artifactName);
            if (parent != null) {
                parent.addChild(art);
            }
            if (persist) {
                art.persist(this.getClass().getSimpleName());
            }
        }
        return art;
    }

    protected void setAttribute(Artifact artifact, AttributeTypeId attributeType, String ... values) {
        artifact.setAttributeValues(attributeType, Arrays.asList(values));
    }

    private void deletePreBranchArt() {
        this.preBranchArt = this.softReqArt.getChild(PRE_BRANCH_ARTIFACT_NAME);
        Assert.assertNotNull((String)"Couldn't retrieve pre-workingBranch artifact", (Object)this.preBranchArt);
        this.preBranchArt.deleteAndPersist(this.getClass().getSimpleName());
    }

    private void createSubsystemArt() {
        this.subsystemArt = this.createSubsystemArtifact(this.softReqArt, SUBSYSTEM_ARTIFACT);
        Assert.assertNotNull((Object)this.subsystemArt);
        this.subsystemArt.setSingletonAttributeValue((AttributeTypeId)CoreAttributeTypes.StaticId, "Test");
        this.subsystemArt.persist(this.getClass().getSimpleName());
    }

    private void deleteReqArtToDelete() {
        this.createAndDeleteArt.deleteAndPersist(this.getClass().getSimpleName());
    }

    private void makeNameChangeToReqArtToDelete() {
        this.createAndDeleteArt.setName(String.valueOf(DemoArtifactToken.InBranchArtifactToDelete.getName()) + " Changed");
        this.createAndDeleteArt.persist(this.getClass().getSimpleName());
    }

    private void createReqArtToDelete() {
        this.createAndDeleteArt = this.createSoftwareArtifact(DemoArtifactToken.InBranchArtifactToDelete, this.softReqArt, this.getInBranchArtifactCscis(), this.workingBranch);
        Assert.assertNotNull((Object)this.createAndDeleteArt);
    }

    protected void createThirdFourthFifthReqArt() {
        this.thirdArt = this.createSoftwareArtifact(CoreArtifactTypes.SoftwareRequirementProcedureMsWord, this.softReqArt, THIRD_ARTIFACT, this.getThirdArtifactCscis(), this.workingBranch);
        Assert.assertNotNull((Object)this.thirdArt);
        this.fourthArt = this.createSoftwareArtifact(CoreArtifactTypes.SoftwareRequirementFunctionMsWord, this.softReqArt, FOURTH_ARTIFACT, null, this.workingBranch);
        Assert.assertNotNull((Object)this.fourthArt);
        this.fifthArt = this.createSoftwareArtifact(CoreArtifactTypes.SoftwareRequirementFunctionMsWord, this.softReqArt, FIFTH_ARTIFACT, new String[]{"Unspecified"}, this.workingBranch);
        Assert.assertNotNull((Object)this.fifthArt);
    }

    private void createFirstAndSecondReqArt() {
        this.softReqArt = this.getSoftwareReqFolder((BranchId)this.workingBranch);
        Artifact firstArt = this.createSoftwareArtifact(CoreArtifactTypes.SoftwareRequirementMsWord, this.softReqArt, FIRST_ARTIFACT, this.getFirstArtifactCscis(), this.workingBranch);
        Assert.assertNotNull((Object)firstArt);
        this.secondArt = this.createSoftwareArtifact(CoreArtifactTypes.SoftwareRequirementMsWord, this.softReqArt, SECOND_ARTIFACT, this.getSecondArtifactCscis(), this.workingBranch);
        Assert.assertNotNull((Object)this.secondArt);
    }

    protected Artifact getSoftwareReqFolder(BranchId branch) {
        return ArtifactQuery.getArtifactFromId((ArtifactId)CoreArtifactTokens.SoftwareRequirementsFolder, (BranchId)branch);
    }

    public void createParentArtsOnWorkingBranch() {
        Artifact softReqArt = this.getSoftwareReqFolder((BranchId)this.workingBranch);
        Artifact systemReqArt = this.createSoftwareArtifact(DemoArtifactToken.SystemReqArtifact, softReqArt, this.getFirstArtifactCscis(), this.workingBranch);
        Assert.assertNotNull((Object)systemReqArt);
        Artifact firstArt = ArtifactQuery.getArtifactFromAttribute((AttributeTypeId)CoreAttributeTypes.Name, (String)FIRST_ARTIFACT, (BranchId)this.workingBranch);
        Artifact secondArt = ArtifactQuery.getArtifactFromAttribute((AttributeTypeId)CoreAttributeTypes.Name, (String)SECOND_ARTIFACT, (BranchId)this.workingBranch);
        systemReqArt.addRelation(CoreRelationTypes.RequirementTrace_LowerLevelRequirement, firstArt);
        systemReqArt.addRelation(CoreRelationTypes.RequirementTrace_LowerLevelRequirement, secondArt);
        systemReqArt.persist("System Req for Arts");
    }

    public void testWorkingBranchCommit() {
        IAtsBranchService branchService = AtsApiService.get().getBranchService();
        Collection configItems = branchService.getConfigArtifactsConfiguredToCommitTo((IAtsTeamWorkflow)reqTeam);
        Assert.assertTrue((String)("Epected " + this.getExpectedBranchConfigItems() + " artifacts configured to commit to;  Actual " + configItems.size()), (configItems.size() == this.getExpectedBranchConfigItems() ? 1 : 0) != 0);
        for (CommitConfigItem configItem : configItems) {
            if (!branchService.isBranchValid(configItem) || !BranchManager.getParentBranch((BranchId)this.workingBranch).equals(configItem.getBaselineBranchId())) continue;
            BranchId branch = branchService.getBranch(configItem);
            XResultData rd = AtsApiService.get().getBranchServiceIde().commitWorkingBranch(reqTeam, false, true, branch, branchService.isBranchesAllCommittedExcept((IAtsTeamWorkflow)reqTeam, branch), new XResultData());
            Assert.assertTrue((String)("Commit Failed " + rd.toString()), (boolean)rd.isSuccess());
        }
        int commitCount = 0;
        for (CommitConfigItem configItem : configItems) {
            if (!branchService.isBranchValid(configItem) || BranchManager.getParentBranch((BranchId)this.workingBranch).equals(configItem.getBaselineBranchId())) continue;
            BranchId branch = branchService.getBranch(configItem);
            XResultData rd = AtsApiService.get().getBranchServiceIde().commitWorkingBranch(reqTeam, false, true, branch, branchService.isBranchesAllCommittedExcept((IAtsTeamWorkflow)reqTeam, branch), new XResultData());
            Assert.assertTrue((String)("Commit Failed " + rd.toString()), (boolean)rd.isSuccess());
            ++commitCount;
        }
        Assert.assertTrue((String)("Expected to commit " + (this.getExpectedBranchConfigItems() - 1) + " other branches;  only committed " + commitCount), (commitCount == this.getExpectedBranchConfigItems() - 1 ? 1 : 0) != 0);
    }

    public void testXWorkingBranchAfterBranchCommit() {
        WorkflowEditor.editArtifact(reqTeam);
        XWorkingBranchEnablement enablement = new XWorkingBranchEnablement(reqTeam);
        Assert.assertEquals((Object)BranchStatus.Changes_NotPermitted__BranchCommitted, (Object)enablement.getStatus());
        Assert.assertFalse((String)"Create Branch Button should be disabled", (boolean)enablement.isCreateBranchButtonEnabled());
        Assert.assertFalse((String)"Show Artifact Explorer Button should be disabled", (boolean)enablement.isShowArtifactExplorerButtonEnabled());
        Assert.assertTrue((String)"Show Change Report Button should be enabled", (boolean)enablement.isShowChangeReportButtonEnabled());
        Assert.assertFalse((String)"Delete Button should be disabled", (boolean)enablement.isDeleteBranchButtonEnabled());
        IAtsBranchService branchService = AtsApiService.get().getBranchService();
        Collection configItems = branchService.getConfigArtifactsConfiguredToCommitTo((IAtsTeamWorkflow)reqTeam);
        for (CommitConfigItem configItem : configItems) {
            CommitStatus xCommitStatus = branchService.getCommitStatus((IAtsTeamWorkflow)reqTeam, configItem);
            Assert.assertTrue((String)("XCommitManager Status not as expected: " + CommitStatus.Committed.name() + " [" + configItem.getCommitFullDisplayName() + "]"), (boolean)xCommitStatus.equals((Object)CommitStatus.Committed));
        }
    }

    public void testChangesMadeWereCommitted() {
        ChangeData changeData = AtsApiService.get().getBranchServiceIde().getChangeDataFromEarliestTransactionId(reqTeam);
        Collection artifactsModified = changeData.getArtifacts(KindType.ArtifactOrRelation, new ModificationType[]{ModificationType.NEW, ModificationType.MODIFIED});
        for (Artifact artifact : artifactsModified) {
            Assert.assertTrue((String)("Unexpected Modified Artifact named \"" + artifact.getName() + "\""), (boolean)this.ArtifactModifiedNames.contains(artifact.getName()));
        }
        for (String artifactName : this.ArtifactModifiedNames) {
            boolean found = false;
            for (Artifact artifact : artifactsModified) {
                if (!artifact.getName().equals(artifactName)) continue;
                found = true;
            }
            Assert.assertTrue((String)("Modified Artifact expected but not found; named \"" + artifactName + "\""), (boolean)found);
        }
        Collection nonRelationArtifactsModified = changeData.getArtifacts(KindType.Artifact, new ModificationType[]{ModificationType.NEW, ModificationType.MODIFIED});
        for (Artifact artifact : nonRelationArtifactsModified) {
            Assert.assertTrue((String)("Unexpected Non-Relation Modified Artifact named \"" + artifact.getName() + "\""), (boolean)this.NonRelArtifactModifedNames.contains(artifact.getName()));
        }
        for (String artifactName : this.NonRelArtifactModifedNames) {
            boolean found = false;
            for (Artifact artifact : nonRelationArtifactsModified) {
                if (!artifact.getName().equals(artifactName)) continue;
                found = true;
            }
            Assert.assertTrue((String)("Non-Relation Modified Artifact expected but not found; named \"" + artifactName + "\""), (boolean)found);
        }
        Collection deleted = changeData.getArtifacts(KindType.Artifact, new ModificationType[]{ModificationType.DELETED});
        if (deleted.size() != 1) {
            Assert.fail((String)("Deleted Artifacts should be 1; Actual is " + deleted.size()));
        } else {
            Artifact art = (Artifact)deleted.iterator().next();
            Assert.assertTrue((String)"Pre-Branch Artifact should have been returned as deleted", (boolean)art.getName().equals(PRE_BRANCH_ARTIFACT_NAME));
            Assert.assertFalse((String)"In-Branch Artifact should NOT have been returned as deleted, and was", (boolean)art.getName().equals(DemoArtifactToken.InBranchArtifactToDelete.getName()));
        }
    }

    public void testRequirementsWorkflowCompletion() {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("testRequirementsWorkflowCompletion");
        TransitionHelper helper = new TransitionHelper("Branch Regression Test", Arrays.asList(new IAtsWorkItem[]{reqTeam}), TeamState.Completed.getName(), null, null, changes, (AtsApi)AtsApiService.get(), new TransitionOption[]{TransitionOption.OverrideAssigneeCheck});
        TransitionResults results = AtsApiService.get().getWorkItemService().transition((ITransitionHelper)helper);
        if (!results.isEmpty()) {
            Assert.fail((String)("Complete Requirements Failed " + results.toString()));
        }
    }

    protected void testCodeTaskCreationAfterCreateReqArtToDelete() {
    }

    protected void testCodeTestCreationAfterChangeToReqArtifactToDelete() {
    }

    protected void testCodeTestCreationAfterDeleteReqArtifactToDelete() {
    }

    protected void testCodeTaskCreationAfterThirdFourthFifth() {
    }

    protected void testCodeTaskCreationAfterFirstAndSecond() {
    }

    protected Collection<String> getFinalTaskNames() {
        return Collections.emptyList();
    }

    protected void testCodeTaskCreationAfterReqCompletion() {
        for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)actionArt)) {
            if (team.getTeamDefinition().toString().contains("Req")) continue;
            IAtsTeamWorkflow testWf = null;
            IAtsTeamWorkflow codeWf = null;
            if (team.isOfType(new ArtifactTypeId[]{this.getTestTeamWfArtType()})) {
                testWf = team;
            } else if (team.isOfType(new ArtifactTypeId[]{this.getCodeTeamWfArtType()})) {
                codeWf = team;
            }
            Assert.assertTrue((testWf != null || codeWf != null ? 1 : 0) != 0);
            int loopCount = 0;
            int count = 0;
            Collection tasks = AtsApiService.get().getTaskService().getTasks(team);
            while (this.getFinalTaskNames().size() != count && loopCount < 10) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                AtsApiService.get().getStoreService().reload(Arrays.asList(team));
                tasks = AtsApiService.get().getTaskService().getTasks(team);
                count = tasks.size();
                ++loopCount;
            }
            Assert.assertEquals((long)this.getFinalTaskNames().size(), (long)count);
            XResultData results = new XResultData();
            for (IAtsTask task : tasks) {
                if (this.getFinalTaskNames().contains(task.getName())) continue;
                results.errorf("Task named [%s]; not found for task %s", new Object[]{task.getName(), task.toStringWithId()});
            }
            for (String taskName : this.getFinalTaskNames()) {
                boolean found = false;
                for (IAtsTask task : tasks) {
                    if (!task.getName().equals(taskName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                results.errorf("Expected Task named [%s] not found", new Object[]{taskName});
            }
            Assert.assertTrue((String)results.toString(), (boolean)results.isSuccess());
        }
    }

    protected void testShowRequirementDiffsAction() {
    }

    public void testSevereLoggingMonitorResults() {
        List stats = monitorLog.getAllLogs();
        for (IHealthStatus stat : new ArrayList(stats)) {
            if (stat.getException() == null) continue;
            Assert.fail((String)("Exception: " + Lib.exceptionToString((Throwable)stat.getException())));
        }
    }

    protected Artifact createSoftwareArtifact(ArtifactToken artifactToken, Artifact parent, String[] partitions, BranchToken branch) throws MultipleAttributesExist {
        SkynetTransaction tx = TransactionManager.createTransaction((BranchId)branch, (String)("Create " + artifactToken.getName()));
        Artifact newArt = ArtifactTypeManager.addArtifact((ArtifactToken)artifactToken, (BranchToken)branch);
        Artifact parentArt = this.setParent(parent, partitions, newArt, tx);
        tx.addArtifact(newArt);
        tx.addArtifact(parent);
        tx.execute();
        return parentArt;
    }

    private Artifact setParent(Artifact parent, String[] partitions, Artifact art1, SkynetTransaction tx) {
        if (partitions != null) {
            art1.setAttributeValues(this.getCsciAttribute(), Arrays.asList(partitions));
        }
        parent.addChild(art1);
        return art1;
    }

    protected Artifact createSoftwareArtifact(ArtifactTypeToken artifactType, Artifact parent, String title, String[] partitions, BranchToken branch) {
        Artifact parentArt = null;
        try {
            SkynetTransaction.setOverrideAccess((boolean)true);
            SkynetTransaction tx = TransactionManager.createTransaction((BranchId)branch, (String)("Create " + title));
            Artifact newArt = ArtifactTypeManager.addArtifact((ArtifactTypeToken)artifactType, (BranchToken)branch, (String)title);
            parentArt = this.setParent(parent, partitions, newArt, tx);
            tx.addArtifact(newArt);
            tx.addArtifact(parent);
            tx.execute();
        }
        finally {
            SkynetTransaction.setOverrideAccess((boolean)false);
        }
        return parentArt;
    }

    public Artifact createSubsystemArtifact(Artifact parent, String title) {
        Artifact art1 = null;
        try {
            art1 = ArtifactTypeManager.addArtifact((ArtifactTypeToken)CoreArtifactTypes.SubsystemRequirementMsWord, (BranchToken)this.workingBranch);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.fail((String)("Can't find descriptor for " + CoreArtifactTypes.SubsystemRequirementMsWord));
            return null;
        }
        art1.setName(title);
        art1.persist(this.getClass().getSimpleName());
        parent.addChild(art1);
        parent.persist(this.getClass().getSimpleName());
        return art1;
    }

    protected void testTasksAgainstExpected(IAtsTeamWorkflow teamWf, Collection<String> expected) {
        Collection tasks = AtsApiService.get().getTaskService().getTasks(teamWf);
        Assert.assertEquals((long)expected.size(), (long)tasks.size());
        for (IAtsTask task : tasks) {
            boolean contains = expected.contains(task.getName());
            Assert.assertTrue((String)String.format("Expected task [%s] and not found in %s", task.getName(), expected), (boolean)contains);
            boolean deReferenced = AtsApiService.get().getTaskService().isAutoGenDeReferenced(task);
            boolean autoGen = AtsApiService.get().getTaskService().isAutoGen(task);
            if (deReferenced) {
                Assert.assertFalse((boolean)autoGen);
            } else {
                Assert.assertTrue((boolean)autoGen);
            }
            if (autoGen) {
                Assert.assertFalse((boolean)deReferenced);
                continue;
            }
            Assert.assertTrue((boolean)deReferenced);
        }
    }

    public abstract String getLegacyPcrId();

    public String getBranchNameContains() {
        return null;
    }

    public abstract String[] getPreBranchCscis();

    public abstract String[] getFirstArtifactCscis();

    public abstract String[] getSecondArtifactCscis();

    public abstract String[] getThirdArtifactCscis();

    public abstract String[] getInBranchArtifactCscis();

    public abstract AttributeTypeId getCsciAttribute();

    public abstract BranchToken getProgramBranch();

    public abstract ArtifactTypeToken getCodeTeamWfArtType();

    public abstract ArtifactTypeToken getTestTeamWfArtType();

    protected void testAfterCreateParentArtsOnWorkingBranch() {
    }

    protected void testShowRelatedTasksAction() {
    }

    protected void testTransitionCreatedTasks(Collection<IAtsTask> tasks) {
    }

    protected int getExpectedBranchConfigItems() {
        return 1;
    }

    protected void testShowRelatedRequirementAction() {
    }

    public abstract List<String> getBranchNames();

    protected void testTaskWorkDefinition(StringBuffer sb, IAtsTask taskArt) {
        String taskWorkDefName = taskArt.getWorkDefinition().getName();
        boolean isTest = taskWorkDefName.contains("Test");
        if (isTest && !taskWorkDefName.equals("WorkDef_Task_Lba_Test_ForRpcr")) {
            sb.append("Error: Test " + taskArt + " work definition should be WorkDef_Task_Lba_Test_ForRpcr and not " + taskWorkDefName + "\n");
        } else if (!isTest && !taskWorkDefName.equals("WorkDef_Task_Lba_Code_ForRpcr")) {
            sb.append("Error: Code " + taskArt + " work definition should be WorkDef_Task_Lba_Code_ForRpcr and not " + taskWorkDefName + "\n");
        }
    }

    public static enum XWorkingBranchButtonState {
        CreateBranch,
        ArtExplore,
        ShowChangeReport,
        DeleteBranch;

    }
}

