/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability;

import java.io.File;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class TraceabilityExtractor {
    private static final Pattern ofpTraceabilityPattern = Pattern.compile("\\^SRS\\s*([^;\n\r]+);");
    private static final Pattern scriptTraceabilityPattern = Pattern.compile("addTraceability\\s*\\(\\s*\\\"\\s*(?:SubDD|SRS|CSID)?\\s*([^\\\"]+)\\\"");
    private static final Pattern invalidTraceabilityPattern = Pattern.compile("(\\[[A-Za-z]|USES_).*");
    private static final Pattern embeddedVolumePattern = Pattern.compile("\\{\\d+ (.*)\\}[ .]*");
    private static final Pattern nonWordPattern = Pattern.compile("[^A-Z_0-9]");
    private static final Pattern structuredReqNamePattern = Pattern.compile("\\[?(\\{[^\\}]+\\})(.*)");
    private static final Pattern stripTrailingReqNamePatern = Pattern.compile("(\\}|\\])(.*)");
    private static TraceabilityExtractor instance = null;
    private final Matcher scriptReqTraceMatcher;
    private final Matcher ofpReqTraceMatcher = ofpTraceabilityPattern.matcher("");
    private final Matcher invalidTraceMatcher;
    private final Matcher embeddedVolumeMatcher;
    private final Matcher nonWordMatcher;
    private final Matcher structuredRequirementMatcher;
    private final Matcher stripTrailingReqNameMatcher;

    private TraceabilityExtractor() {
        this.scriptReqTraceMatcher = scriptTraceabilityPattern.matcher("");
        this.invalidTraceMatcher = invalidTraceabilityPattern.matcher("");
        this.embeddedVolumeMatcher = embeddedVolumePattern.matcher("");
        this.nonWordMatcher = nonWordPattern.matcher("");
        this.structuredRequirementMatcher = structuredReqNamePattern.matcher("");
        this.stripTrailingReqNameMatcher = stripTrailingReqNamePatern.matcher("");
    }

    public static TraceabilityExtractor getInstance() {
        if (instance == null) {
            instance = new TraceabilityExtractor();
        }
        return instance;
    }

    public List<String> getTraceMarksFromFile(File sourceFile) throws IOException {
        CharBuffer buffer = Lib.fileToCharBuffer((File)sourceFile);
        Matcher matcher = this.isScriptFile(sourceFile) ? this.getScriptTraceMarkMatcher() : this.getCodeTraceMarkMatcher();
        return this.getTraceMarks(buffer, matcher);
    }

    private List<String> getTraceMarks(CharBuffer buffer, Matcher matcher) {
        ArrayList<String> toReturn = new ArrayList<String>();
        matcher.reset(buffer);
        while (matcher.find()) {
            String mark = matcher.group(1);
            if (!Strings.isValid((String)mark)) continue;
            toReturn.add(mark);
        }
        return toReturn;
    }

    public boolean isValidTraceMark(String toCheck) {
        this.invalidTraceMatcher.reset(toCheck);
        return !this.invalidTraceMatcher.matches();
    }

    private Matcher getScriptTraceMarkMatcher() {
        return this.scriptReqTraceMatcher;
    }

    public Matcher getCodeTraceMarkMatcher() {
        return this.ofpReqTraceMatcher;
    }

    private boolean isScriptFile(File sourceFile) {
        return sourceFile.getName().endsWith("java");
    }

    public String getCanonicalRequirementName(String requirementMark) {
        String canonicalReqReference = requirementMark;
        if (Strings.isValid((String)requirementMark)) {
            String trail;
            canonicalReqReference = requirementMark.toUpperCase();
            this.embeddedVolumeMatcher.reset(canonicalReqReference);
            if (this.embeddedVolumeMatcher.find()) {
                canonicalReqReference = this.embeddedVolumeMatcher.group(1);
            }
            this.stripTrailingReqNameMatcher.reset(canonicalReqReference);
            if (this.stripTrailingReqNameMatcher.find() && Strings.isValid((String)(trail = this.stripTrailingReqNameMatcher.group(2))) && !trail.startsWith(".")) {
                canonicalReqReference = canonicalReqReference.substring(0, this.stripTrailingReqNameMatcher.start(1) + 1);
            }
            this.nonWordMatcher.reset(canonicalReqReference);
            canonicalReqReference = this.nonWordMatcher.replaceAll("");
        }
        return canonicalReqReference;
    }

    public Pair<String, String> getStructuredRequirement(String requirementMark) {
        Pair toReturn = null;
        this.structuredRequirementMatcher.reset(requirementMark);
        if (this.structuredRequirementMatcher.matches()) {
            String primary = this.structuredRequirementMatcher.group(1);
            String secondary = this.structuredRequirementMatcher.group(2);
            if (Strings.isValid((String)primary)) {
                toReturn = new Pair((Object)primary, (Object)secondary);
            }
        }
        return toReturn;
    }
}

