/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.client.server;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.core.client.internal.Activator;
import org.eclipse.osee.framework.core.client.server.HttpRequest;
import org.eclipse.osee.framework.core.client.server.HttpResponse;
import org.eclipse.osee.framework.core.client.server.IHttpMethod;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.ExtensionPoints;
import org.osgi.framework.Bundle;

public class HttpResourceRequest
implements IHttpMethod {
    private static HttpResourceRequest instance = new HttpResourceRequest();

    private HttpResourceRequest() {
    }

    public static HttpResourceRequest getInstance() {
        return instance;
    }

    @Override
    public void processRequest(HttpRequest httpRequest, HttpResponse httpResponse) {
        String urlRequest = httpRequest.getUrlRequest();
        URL url = this.findResource(urlRequest);
        if (url != null) {
            this.sendResource(url, httpResponse.getOutputStream());
        } else {
            httpResponse.outputStandardError(400, "Invalid Request: *" + urlRequest + "*");
        }
    }

    private void sendResource(URL url, OutputStream outputStream) {
        BufferedInputStream bis = null;
        try {
            try {
                int count;
                bis = new BufferedInputStream(url.openStream());
                PrintStream ps = new PrintStream(outputStream, true, "UTF-8");
                byte[] buffer = new byte[1024];
                while ((count = bis.read(buffer)) != -1) {
                    ps.write(buffer, 0, count);
                }
            }
            catch (IOException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error sending requested resource", (Throwable)ex);
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException ex2) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error closing stream", (Throwable)ex2);
                }
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error closing stream", (Throwable)ex);
            }
        }
    }

    private URL findResource(String urlRequested) {
        URL resource = null;
        if (Strings.isValid((String)urlRequested) && !urlRequested.endsWith("/")) {
            List elements = ExtensionPoints.getExtensionElements((String)"org.eclipse.osee.framework.skynet.core.WebPage", (String)"WebPageFolder");
            for (IConfigurationElement element : elements) {
                String resourceName = element.getAttribute("Path");
                String bundleName = element.getContributor().getName();
                if (!Strings.isValid((String)bundleName) || !Strings.isValid((String)resourceName)) continue;
                try {
                    Bundle bundle = Platform.getBundle((String)bundleName);
                    URL url = bundle.getEntry(String.valueOf(resourceName) + urlRequested);
                    if (url == null) continue;
                    resource = FileLocator.resolve((URL)url);
                    break;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format("Unable to Load: [%s.%s]", bundleName, resourceName));
                }
            }
        }
        return resource;
    }
}

