/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.client;

import org.eclipse.osee.framework.jdk.core.util.OseeProperties;

public class OseeClientProperties
extends OseeProperties {
    private static final OseeClientProperties instance = new OseeClientProperties();
    private static final String OSEE_LOCAL_APPLICATION_SERVER = "osee.local.application.server";
    private static final String OSEE_LOCAL_HTTP_WORKER_PORT = "osee.local.http.worker.port";
    private static final String OSEE_IMPORT_DURING_DB_INIT = "osee.import.on.db.init";
    private static final String OSEE_CHOICE_ON_DB_INIT = "osee.choice.on.db.init";
    private static final String OSEE_COMMIT_SKIP_CHECKS_AND_EVENTS = "osee.commit.skipChecksAndEvents";

    public static boolean isSkipCommitChecksAndEvents() {
        return Boolean.valueOf(OseeClientProperties.getProperty((String)OSEE_COMMIT_SKIP_CHECKS_AND_EVENTS, (String)"false"));
    }

    public static String getChoiceOnDbInit() {
        return OseeClientProperties.getProperty((String)OSEE_CHOICE_ON_DB_INIT);
    }

    public static boolean isOseeImportAllowed() {
        return Boolean.valueOf(OseeClientProperties.getProperty((String)OSEE_IMPORT_DURING_DB_INIT));
    }

    public static boolean isLocalApplicationServerRequired() {
        return Boolean.valueOf(OseeClientProperties.getProperty((String)OSEE_LOCAL_APPLICATION_SERVER));
    }

    public static String getLocalHttpWorkerPort() {
        return OseeClientProperties.getProperty((String)OSEE_LOCAL_HTTP_WORKER_PORT);
    }

    public static void setOseeApplicationServer(String value) {
        System.setProperty("osee.application.server", value);
    }

    public static String getOseeApplicationServer() {
        return OseeClientProperties.getProperty((String)"osee.application.server", (String)"http://localhost:8089");
    }

    public static String getAllSettings() {
        return instance.toString();
    }
}

