/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io.xml;

import java.io.IOException;
import org.eclipse.osee.framework.jdk.core.util.io.xml.AbstractSaxHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class WordSaxHandler
extends AbstractSaxHandler {
    private boolean inHeader;
    private boolean inFooter;
    private final StringBuilder headerText = new StringBuilder();
    private final StringBuilder footerText = new StringBuilder();

    public void reset() {
        this.headerText.delete(0, 99999999);
        this.footerText.delete(0, 99999999);
    }

    @Override
    public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
        if (localName.equalsIgnoreCase("hdr")) {
            this.inHeader = true;
        } else if (localName.equalsIgnoreCase("ftr")) {
            this.inFooter = true;
        }
    }

    @Override
    public void endElementFound(String uri, String localName, String qName) throws SAXException {
        try {
            if (localName.equalsIgnoreCase("t")) {
                if (this.inHeader) {
                    this.addContentsTo(this.headerText);
                } else if (this.inFooter) {
                    this.addContentsTo(this.footerText);
                }
            } else if (localName.equalsIgnoreCase("hdr")) {
                this.inHeader = false;
            } else if (localName.equalsIgnoreCase("ftr")) {
                this.inFooter = false;
            }
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
    }

    public String getHeaderText() {
        return this.headerText.toString();
    }

    public String getFooterText() {
        return this.footerText.toString();
    }
}

