/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io.xml;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.CharBackedInputStream;
import org.eclipse.osee.framework.jdk.core.util.io.xml.AbstractSheetWriter;

public final class TextSheetWriter
extends AbstractSheetWriter {
    private final Map<String, CharBackedInputStream> sheetMap = new LinkedHashMap<String, CharBackedInputStream>();
    private CharBackedInputStream currentStream = null;
    private boolean wasDataAdded = false;
    private final String lineSeparator = System.getProperty("line.separator", "\r\n");
    private int columnCount;

    public boolean hasData() {
        return this.wasDataAdded;
    }

    public CharBackedInputStream getInputStream() {
        return this.currentStream;
    }

    public Set<String> getSheetNames() {
        return this.sheetMap.keySet();
    }

    public CharBackedInputStream getSheetBackerByName(String tabName) {
        return this.sheetMap.get(tabName);
    }

    @Override
    protected void startRow() {
    }

    @Override
    protected void writeCellText(Object data, int cellIndex) throws IOException {
        if (data instanceof String) {
            String dataStr = (String)data;
            if (Strings.isValid(dataStr)) {
                this.currentStream.append(dataStr);
            }
            if (cellIndex < this.columnCount - 1) {
                this.currentStream.append("\t");
            }
            this.wasDataAdded = true;
        }
    }

    @Override
    protected void writeEndRow() throws IOException {
        this.currentStream.append(this.lineSeparator);
        this.wasDataAdded = true;
    }

    @Override
    public void endSheet() {
        this.currentStream = null;
    }

    @Override
    public void endWorkbook() {
    }

    @Override
    public void startSheet(String worksheetName, int columnCount) throws IOException {
        this.columnCount = columnCount;
        this.currentStream = new CharBackedInputStream();
        this.sheetMap.put(worksheetName, this.currentStream);
    }

    @Override
    public void setActiveSheet(int sheetNum) {
    }

    @Override
    public void endWorkbook(boolean closeFile) {
    }
}

