/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io.xml;

import java.util.Arrays;
import org.eclipse.osee.framework.jdk.core.util.io.xml.AbstractSaxHandler;
import org.eclipse.osee.framework.jdk.core.util.io.xml.RowProcessor;
import org.xml.sax.Attributes;

public class ExcelSaxHandler
extends AbstractSaxHandler {
    private String[] row;
    private StringBuilder cellData;
    private boolean inCellData = false;
    private int cellIndex;
    private int rowIndex;
    private final RowProcessor rowProcessor;
    private boolean isRowHeader;
    private final boolean firstRowIsHeader;
    private final boolean multiTable;
    private boolean rowEmpty;

    public ExcelSaxHandler(RowProcessor rowProcessor, boolean firstRowIsHeader, boolean enableMultiTableSupport) {
        this.rowProcessor = rowProcessor;
        this.firstRowIsHeader = firstRowIsHeader;
        this.multiTable = enableMultiTableSupport;
        this.rowIndex = 0;
    }

    public ExcelSaxHandler(RowProcessor rowProcessor, boolean hasHeaderRow) {
        this(rowProcessor, hasHeaderRow, false);
    }

    @Override
    public void startElementFound(String uri, String localName, String qName, Attributes attributes) throws Exception {
        if (localName.equalsIgnoreCase("Row")) {
            this.cellIndex = -1;
            this.rowEmpty = true;
            Arrays.fill(this.row, 0, this.row.length, null);
            String indexStr = attributes.getValue("ss:Index");
            if (indexStr != null) {
                int oldRowIndex = this.rowIndex;
                this.rowIndex = Integer.parseInt(indexStr) - 1;
                int i = oldRowIndex;
                while (i < this.rowIndex) {
                    this.rowProcessor.processEmptyRow();
                    ++i;
                }
            } else {
                ++this.rowIndex;
            }
        } else if (localName.equalsIgnoreCase("Cell")) {
            String indexStr = attributes.getValue("ss:Index");
            this.cellData = null;
            this.inCellData = true;
            this.cellIndex = indexStr != null ? Integer.parseInt(indexStr) - 1 : ++this.cellIndex;
        } else if (localName.equalsIgnoreCase("Table")) {
            String columnCountStr = attributes.getValue("ss:ExpandedColumnCount");
            if (columnCountStr == null) {
                throw new IllegalArgumentException("missing ss:ExpandedColumnCount attribute of Table element");
            }
            this.row = new String[Integer.parseInt(columnCountStr)];
            String rowCountStr = attributes.getValue("ss:ExpandedRowCount");
            if (rowCountStr == null) {
                rowCountStr = "0";
            }
            this.rowProcessor.detectedRowAndColumnCounts(Integer.parseInt(rowCountStr), this.row.length);
        } else if (localName.equalsIgnoreCase("Worksheet")) {
            this.isRowHeader = this.firstRowIsHeader;
            this.rowProcessor.foundStartOfWorksheet(attributes.getValue("ss:Name"));
        }
    }

    @Override
    public void endElementFound(String uri, String localName, String qName) throws Exception {
        if (this.inCellData) {
            if (this.cellData == null) {
                this.cellData = new StringBuilder();
            }
            this.cellData.append(this.getContents());
        }
        if (localName.equalsIgnoreCase("Data") && this.cellData != null) {
            this.inCellData = false;
            String contentStr = this.cellData.toString();
            this.cellData = null;
            if (!contentStr.equals("data stored in EmbeddedClob since longer than 32767 chars")) {
                this.row[this.cellIndex] = contentStr.equals("\u00f8") ? "" : contentStr;
            }
            this.rowEmpty = false;
        } else if (localName.equalsIgnoreCase("Row")) {
            if (this.rowEmpty) {
                this.rowProcessor.processEmptyRow();
                if (this.multiTable) {
                    this.isRowHeader = true;
                }
            } else if (this.row[0] != null && this.row[0].startsWith("#")) {
                this.rowProcessor.processCommentRow(this.row);
            } else if (this.isRowHeader) {
                this.isRowHeader = false;
                this.rowProcessor.processHeaderRow(this.row);
            } else {
                this.rowProcessor.processRow(this.row);
            }
        } else if (localName.equalsIgnoreCase("Worksheet")) {
            this.rowProcessor.reachedEndOfWorksheet();
        } else if (localName.equalsIgnoreCase("EmbeddedClob")) {
            this.row[this.cellIndex] = this.getContents();
        }
    }
}

