/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.io.PrintStream;
import java.nio.ByteBuffer;

public class ByteUtil {
    public static void printBinary(byte[] data, int bytesPerGroup, int groupPerLine, PrintStream out) {
        int groups = 0;
        int i = 0;
        while (i < data.length) {
            out.print(ByteUtil.toBinaryString(data[i]));
            if ((i + 1) % bytesPerGroup == 0) {
                out.print(" ");
                if (++groups % groupPerLine == 0) {
                    out.println();
                }
            }
            ++i;
        }
    }

    public static void printHex(byte[] data, int bytesPerGroup, int groupPerLine, PrintStream out) {
        int groups = 0;
        int i = 0;
        while (i < data.length) {
            out.print(ByteUtil.toHexString(data[i]));
            if ((i + 1) % bytesPerGroup == 0) {
                out.print(" ");
                if (++groups % groupPerLine == 0) {
                    out.println();
                }
            }
            ++i;
        }
    }

    public static void printHex(byte[] data, int bytesPerGroup, int groupPerLine, StringBuilder strBuilder) {
        int i = 0;
        while (i < data.length) {
            strBuilder.append(ByteUtil.toHexString(data[i]));
            if ((i + 1) % bytesPerGroup == 0) {
                strBuilder.append(" ");
            }
            ++i;
        }
    }

    public static void printHex(byte[] data, int bytesPerGroup, int groupPerLine, boolean isSpaced, StringBuilder strBuilder) {
        int i = 0;
        while (i < data.length) {
            strBuilder.append(ByteUtil.toHexString(data[i]));
            if ((i + 1) % bytesPerGroup == 0 && isSpaced) {
                strBuilder.append(" ");
            }
            ++i;
        }
    }

    public static String toBinaryString(byte b) {
        StringBuffer sb = new StringBuffer();
        sb.append(b >> 7 & 1);
        sb.append(b >> 6 & 1);
        sb.append(b >> 5 & 1);
        sb.append(b >> 4 & 1);
        sb.append(b >> 3 & 1);
        sb.append(b >> 2 & 1);
        sb.append(b >> 1 & 1);
        sb.append(b & 1);
        return sb.toString();
    }

    public static byte[] toBytes(long n) {
        byte[] bytes = new byte[8];
        ByteUtil.toBytes(bytes, 0, n);
        return bytes;
    }

    public static void toBytes(byte[] bytes, int startPos, long n) {
        int i = startPos + 7;
        while (i >= startPos) {
            bytes[i] = (byte)n;
            n >>>= 8;
            --i;
        }
    }

    public static void toBytes(byte[] bytes, int startPos, int n) {
        int i = startPos + 3;
        while (i >= startPos) {
            bytes[i] = (byte)n;
            n >>>= 8;
            --i;
        }
    }

    public static String toHexString(byte b) {
        String temp = Integer.toHexString(b);
        if (temp.length() >= 2) {
            return temp.substring(temp.length() - 2).toUpperCase();
        }
        return "0" + temp.toUpperCase();
    }

    public static long toLong(byte[] b) {
        if (b.length != 8) {
            throw new IllegalArgumentException();
        }
        return ((long)b[7] & 0xFFL) + (((long)b[6] & 0xFFL) << 8) + (((long)b[5] & 0xFFL) << 16) + (((long)b[4] & 0xFFL) << 24) + (((long)b[3] & 0xFFL) << 32) + (((long)b[2] & 0xFFL) << 40) + (((long)b[1] & 0xFFL) << 48) + (((long)b[0] & 0xFFL) << 56);
    }

    public static void printByteDump(StringBuilder strBuilder, byte[] data, int offset, int length, int columnNum) {
        ByteUtil.printByteDump(strBuilder, data, offset, length, columnNum, true);
    }

    public static void printByteDump(StringBuilder strBuilder, byte[] data, int offset, int length, int columnNum, boolean hex) {
        int columnCount = 0;
        int endIndex = offset + length;
        int i = offset;
        while (i < endIndex) {
            if (columnCount == columnNum) {
                strBuilder.append('\n');
                columnCount = 0;
            }
            if (hex) {
                strBuilder.append(String.format("%02x ", data[i]));
            } else {
                strBuilder.append(data[i]).append(' ');
            }
            ++columnCount;
            ++i;
        }
        strBuilder.append('\n');
    }

    public static void printByteDump(StringBuilder strBuilder, ByteBuffer data, int offset, int length, int columnNum) {
        int currentPosition = data.position();
        int columnCount = 0;
        int endIndex = offset + length;
        int i = offset;
        while (i < endIndex) {
            if (columnCount == columnNum) {
                strBuilder.append('\n');
                columnCount = 0;
            }
            strBuilder.append(String.format("%02x ", data.get(i)));
            ++columnCount;
            ++i;
        }
        strBuilder.append('\n');
        data.position(currentPosition);
    }

    public static void main(String[] args) {
        System.out.println(ByteUtil.toHexString((byte)-128));
    }
}

