/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResourceToken;

public class ResourceRegistry
implements IResourceRegistry {
    private final ConcurrentHashMap<Long, ResourceToken> registry = new ConcurrentHashMap();

    @Override
    public ResourceToken registerResource(Long universalId, ResourceToken token) {
        return this.registry.put(universalId, token);
    }

    @Override
    public InputStream getResource(Long universalId) {
        ResourceToken token = this.getResourceToken(universalId);
        try {
            return token.getUrl().openStream();
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap(ex);
        }
    }

    @Override
    public ResourceToken getResourceToken(Long universalId) {
        ResourceToken token = this.registry.get(universalId);
        if (token == null) {
            throw new OseeArgumentException("Resource with universal ID [%X] not found.", universalId);
        }
        return token;
    }

    @Override
    public void registerAll(Iterable<ResourceToken> tokens) {
        for (ResourceToken token : tokens) {
            this.registerResource((Long)token.getGuid(), token);
        }
    }
}

